/*
 * Decompiled with CFR 0.152.
 */
package org.trustedanalytics.hadoop;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.hadoop.conf.Configuration;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;
import org.trustedanalytics.hadoop.HadoopServiceType;

@Deprecated
public final class HadoopConfigurationHelper {
    private static final ObjectMapper jsonMapper = new ObjectMapper();
    public static final String VCAP_SERVICES = "VCAP_SERVICES";

    public static void mergeConfiguration(Configuration conf, Map<String, String> props) {
        if (props != null) {
            props.forEach((arg_0, arg_1) -> ((Configuration)conf).set(arg_0, arg_1));
        }
    }

    private HadoopConfigurationHelper() {
    }

    public static Optional<Map<String, String>> getHadoopConfFromEnv(String envVariableName) throws IOException {
        return HadoopConfigurationHelper.getHadoopConfFromJson(System.getenv(envVariableName));
    }

    public static Optional<Map<String, String>> getHadoopConfFromJson(String jsonConf) throws IOException, IllegalArgumentException {
        if (jsonConf == null) {
            throw new IllegalArgumentException("Json configuration string can not be null!");
        }
        JsonNode jsonNode = HadoopConfigurationHelper.getConfigurationAsJsonTree(jsonConf);
        return Optional.of(HadoopConfigurationHelper.parseJsonConf(jsonNode));
    }

    public static Optional<Map<String, String>> getHadoopConfByServiceName(String jsonConf, HadoopServiceType type) throws IOException {
        return HadoopConfigurationHelper.getHadoopConfByServiceName(jsonConf, type.getTypeName());
    }

    public static Optional<Map<String, String>> getHadoopConfByServiceName(String jsonConf, String type) throws IOException {
        JsonNode jsonNode = HadoopConfigurationHelper.getConfigurationAsJsonTree(jsonConf).findParent(type);
        return Optional.of(HadoopConfigurationHelper.parse(jsonNode));
    }

    private static Map<String, String> parse(JsonNode jsonNode) {
        HashMap<String, String> found = new HashMap<String, String>();
        JsonNode hadoopConfParent = jsonNode.findParent("HADOOP_CONFIG_KEY");
        Iterator trustedAnalyticsConfSections = hadoopConfParent.getElements();
        trustedAnalyticsConfSections.forEachRemaining(entry -> {
            Iterator paramRowfields = entry.getFields();
            paramRowfields.forEachRemaining(paramEntry -> found.put((String)paramEntry.getKey(), ((JsonNode)paramEntry.getValue()).getTextValue()));
        });
        return found;
    }

    private static Map<String, String> parseJsonConf(JsonNode jsonNode) throws IOException {
        HashMap<String, String> found = new HashMap<String, String>();
        List hadoopConfParents = jsonNode.findParents("HADOOP_CONFIG_KEY");
        for (JsonNode hadoopConf : hadoopConfParents) {
            found.putAll(HadoopConfigurationHelper.parse(hadoopConf));
        }
        return found;
    }

    private static JsonNode getConfigurationAsJsonTree(String jsonConf) throws IOException {
        return jsonMapper.readTree(jsonConf);
    }
}

