/*
 * Decompiled with CFR 0.152.
 */
package org.trustedanalytics.hadoop.config;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.trustedanalytics.hadoop.config.ConfigurationHelper;
import org.trustedanalytics.hadoop.config.ConfigurationLocator;
import org.trustedanalytics.hadoop.config.PropertyLocator;
import org.trustedanalytics.hadoop.config.internal.ConfigNode;
import org.trustedanalytics.hadoop.config.internal.ConfigurationReader;
import org.trustedanalytics.hadoop.config.internal.JsonConfigurationReader;
import org.trustedanalytics.hadoop.config.internal.Path;

@Deprecated
public final class ConfigurationHelperImpl
implements ConfigurationHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigurationHelperImpl.class);
    private FactoryHelper factoryHelper;

    ConfigurationHelperImpl(FactoryHelper factoryHelper) {
        this.factoryHelper = factoryHelper;
    }

    public static ConfigurationHelperImpl getInstance() {
        return new ConfigurationHelperImpl(new FactoryHelper());
    }

    @Override
    public Map<String, String> getConfigurationFromJson(String jsonConf, ConfigurationLocator location) throws IOException {
        List<ConfigNode> found = this.pickConfNodes(jsonConf, location);
        HashMap<String, String> config = new HashMap<String, String>();
        found.forEach(confSection -> confSection.getChildren().forEach(param -> config.put(param.name(), param.value())));
        LOGGER.info("Returning following config to app: " + config);
        return config;
    }

    @Override
    public Map<String, String> getConfigurationFromEnv(String envVariableName, ConfigurationLocator location) throws IOException {
        return this.getConfigurationFromJson(System.getenv(envVariableName), location);
    }

    @Override
    public Map<String, String> getConfigurationFromEnv(ConfigurationLocator location) throws IOException {
        return this.getConfigurationFromEnv("VCAP_SERVICES", location);
    }

    @Override
    public Optional<String> getPropertyFromJson(String jsonConf, PropertyLocator location) throws IOException {
        String value = null;
        if (jsonConf != null) {
            List<ConfigNode> found = this.pickConfNodes(jsonConf, location);
            for (ConfigNode node : found) {
                value = node.value();
            }
        }
        return Optional.ofNullable(value);
    }

    @Override
    public Optional<String> getPropertyFromEnv(String envVariableName, PropertyLocator location) throws IOException {
        return this.getPropertyFromJson(System.getenv(envVariableName), location);
    }

    @Override
    public Optional<String> getPropertyFromEnv(PropertyLocator location) throws IOException {
        return this.getPropertyFromEnv("VCAP_SERVICES", location);
    }

    private List<ConfigNode> pickConfNodes(String jsonConf, Path location) throws IOException {
        Function<ConfigNode, List<ConfigNode>> action;
        ConfigurationReader reader = this.factoryHelper.getConfigurationReader(jsonConf);
        ConfigNode node = reader.getRootNode();
        List<ConfigNode> found = new ArrayList<ConfigNode>();
        Iterator<Function<ConfigNode, List<ConfigNode>>> iterator = location.getConfPath().getStack().iterator();
        while (iterator.hasNext() && (found = (action = iterator.next()).apply(node)).size() == 1) {
            node = found.get(0);
        }
        return found;
    }

    static final class FactoryHelper {
        FactoryHelper() {
        }

        ConfigurationReader getConfigurationReader(String jsonConf) throws IOException {
            return JsonConfigurationReader.getReader(jsonConf);
        }
    }
}

