/*
 * Decompiled with CFR 0.152.
 */
package org.trustedanalytics.hadoop.config.client;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Optional;
import org.trustedanalytics.hadoop.config.client.AppConfiguration;
import org.trustedanalytics.hadoop.config.client.CloudFoundryServiceInstanceConfiguration;
import org.trustedanalytics.hadoop.config.client.ServiceInstanceConfiguration;
import org.trustedanalytics.hadoop.config.client.ServiceType;
import org.trustedanalytics.hadoop.config.internal.ConfigNode;
import org.trustedanalytics.hadoop.config.internal.ConfigPath;

public final class CloudFoundryAppConfiguration
implements AppConfiguration {
    private ConfigNode rootConfigNode;

    CloudFoundryAppConfiguration(ConfigNode node) {
        this.rootConfigNode = node;
    }

    @Override
    public ServiceInstanceConfiguration getServiceConfig(String serviceInstanceName) {
        Optional<Object> found = Optional.empty();
        for (ServiceType serviceType : ServiceType.values()) {
            ConfigPath configPath = ConfigPath.createPath().append(serviceType.getConfPath()).add(configNode -> Lists.newArrayList((Object[])new ConfigNode[]{configNode.selectOne("name", serviceInstanceName)}));
            found = CloudFoundryServiceInstanceConfiguration.getConfiguration(this.rootConfigNode, configPath);
            if (found.isPresent()) break;
        }
        return (ServiceInstanceConfiguration)found.orElseThrow(() -> new IllegalStateException("Not found configuration for service instance named " + serviceInstanceName + "!"));
    }

    @Override
    public ServiceInstanceConfiguration getServiceConfig(ServiceType serviceTypeLocation) throws IllegalStateException {
        ConfigPath configPath = ConfigPath.createPath().append(serviceTypeLocation.getConfPath()).add(ConfigNode::getChildren);
        Optional<ServiceInstanceConfiguration> found = CloudFoundryServiceInstanceConfiguration.getConfiguration(this.rootConfigNode, configPath);
        return found.orElseThrow(() -> new IllegalStateException("Not found " + serviceTypeLocation + " service configuration!"));
    }

    @Override
    public List<ServiceInstanceConfiguration> getServiceConfigList(ServiceType serviceTypeLocation) {
        ConfigPath typeSection = ConfigPath.createPath().append(serviceTypeLocation.getConfPath()).add(ConfigNode::getChildren);
        return CloudFoundryServiceInstanceConfiguration.getListConfiguration(this.rootConfigNode, typeSection);
    }
}

