/*
 * Decompiled with CFR 0.152.
 */
package org.trustedanalytics.hadoop.config.client;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import org.apache.hadoop.conf.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.trustedanalytics.hadoop.config.client.Property;
import org.trustedanalytics.hadoop.config.client.ServiceInstanceConfiguration;
import org.trustedanalytics.hadoop.config.internal.ConfigNode;
import org.trustedanalytics.hadoop.config.internal.ConfigPath;

final class CloudFoundryServiceInstanceConfiguration
implements ServiceInstanceConfiguration {
    private ConfigNode configuration;
    private static final Logger LOGGER = LoggerFactory.getLogger(CloudFoundryServiceInstanceConfiguration.class);

    private CloudFoundryServiceInstanceConfiguration(ConfigNode conf) {
        this.configuration = conf;
    }

    static List<ServiceInstanceConfiguration> getListConfiguration(ConfigNode root, ConfigPath path) {
        ConfigNode node = root;
        ArrayList<ServiceInstanceConfiguration> ret = new ArrayList<ServiceInstanceConfiguration>();
        int step = 1;
        int pathLength = path.getStack().size();
        for (Function<ConfigNode, List<ConfigNode>> action : path.getStack()) {
            List<ConfigNode> found = action.apply(node);
            if (found.size() == 1) {
                node = found.get(0);
            } else if (found.size() > 1 && step == pathLength) {
                found.forEach(config -> ret.add(new CloudFoundryServiceInstanceConfiguration((ConfigNode)config)));
            } else {
                throw new IllegalStateException("Incorrect configuration path! Path can't fork!");
            }
            ++step;
        }
        return ret;
    }

    static Optional<ServiceInstanceConfiguration> getConfiguration(ConfigNode root, ConfigPath path) {
        ConfigNode node = root;
        CloudFoundryServiceInstanceConfiguration ret = null;
        try {
            for (Function<ConfigNode, List<ConfigNode>> action : path.getStack()) {
                List<ConfigNode> found = action.apply(node);
                if (found.size() != 1) {
                    throw new IllegalStateException("Ambiguity. Impossible to determine which configuration should be returned!");
                }
                node = found.get(0);
            }
            ret = new CloudFoundryServiceInstanceConfiguration(node);
        }
        catch (NullPointerException ignore) {
            LOGGER.info("Attempting to read not existing configuration! " + ignore.getMessage());
        }
        return Optional.ofNullable(ret);
    }

    @Override
    public String getName() {
        return this.configuration.name();
    }

    @Override
    public Configuration asHadoopConfiguration() {
        Configuration conf = new Configuration(false);
        this.configuration.find("HADOOP_CONFIG_KEY").getChildren().forEach(param -> conf.set(param.name(), param.value()));
        return conf;
    }

    @Override
    public Map<String, String> asMap() {
        HashMap<String, String> properties = new HashMap<String, String>();
        this.configuration.find("HADOOP_CONFIG_KEY").getChildren().forEach(param -> properties.put(param.name(), param.value()));
        return properties;
    }

    @Override
    public Optional<String> getProperty(Property propertyLocation) throws IllegalStateException {
        ConfigNode node = this.configuration;
        try {
            for (Function<ConfigNode, List<ConfigNode>> action : propertyLocation.getConfPath().getStack()) {
                List<ConfigNode> found = action.apply(node);
                if (found.size() != 1) {
                    throw new IllegalStateException("Incorrect property path! Path can't fork!");
                }
                node = found.get(0);
            }
        }
        catch (NullPointerException ignore) {
            LOGGER.debug("Not existing property!", (Throwable)ignore);
            return Optional.empty();
        }
        return Optional.ofNullable(node.value());
    }
}

