/*
 * Decompiled with CFR 0.152.
 */
package org.trustedanalytics.hadoop.config.client.helper;

import java.io.IOException;
import java.util.Optional;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginException;
import org.apache.hadoop.conf.Configuration;
import org.trustedanalytics.hadoop.config.client.AppConfiguration;
import org.trustedanalytics.hadoop.config.client.Configurations;
import org.trustedanalytics.hadoop.config.client.JwtToken;
import org.trustedanalytics.hadoop.config.client.Property;
import org.trustedanalytics.hadoop.config.client.ServiceInstanceConfiguration;
import org.trustedanalytics.hadoop.config.client.ServiceType;
import org.trustedanalytics.hadoop.kerberos.KrbLoginManager;
import org.trustedanalytics.hadoop.kerberos.KrbLoginManagerFactory;

class HadoopClient {
    private static final String AUTHENTICATION_METHOD = "kerberos";
    private static final String AUTHENTICATION_METHOD_PROPERTY = "hadoop.security.authentication";
    private KrbLoginManager loginManager;
    private ServiceInstanceConfiguration serviceConfiguration;
    private ServiceInstanceConfiguration krbServiceConfiguration;

    private HadoopClient() {
    }

    public Configuration createConfig() throws LoginException, IOException {
        Configuration hadoopConf = this.serviceConfiguration.asHadoopConfiguration();
        if (this.isKerberosEnabled(hadoopConf)) {
            this.loginManager.loginInHadoop(this.getLoggedUserIdentity(), hadoopConf);
        }
        return hadoopConf;
    }

    public Configuration createConfig(JwtToken jwtToken) throws LoginException, IOException {
        throw new UnsupportedOperationException("Not implemented, yet!");
    }

    public boolean isKerberosEnabled(Configuration hadoopConf) {
        return AUTHENTICATION_METHOD.equals(hadoopConf.get(AUTHENTICATION_METHOD_PROPERTY));
    }

    Subject getLoggedUserIdentity() throws LoginException {
        String userName = this.getKrbServiceProperty(Property.USER);
        String pass = this.getKrbServiceProperty(Property.PASSWORD);
        return this.loginManager.loginWithCredentials(userName, pass.toCharArray());
    }

    String getServiceProperty(Property property) {
        return this.serviceConfiguration.getProperty(property).orElseThrow(() -> new IllegalStateException(property.name() + " not found in configuration!"));
    }

    String getKrbServiceProperty(Property property) {
        return this.krbServiceConfiguration.getProperty(property).orElseThrow(() -> new IllegalStateException(property.name() + " not found in configuration!"));
    }

    void setLoginManager(Optional<KrbLoginManager> loginManager) {
        this.loginManager = loginManager.orElse(this.getDefaultLoginManager());
    }

    void setServiceConfiguration(ServiceInstanceConfiguration serviceConfiguration) {
        this.serviceConfiguration = serviceConfiguration;
    }

    void setKrbServiceConfiguration(ServiceInstanceConfiguration krbServiceConfiguration) {
        this.krbServiceConfiguration = krbServiceConfiguration;
    }

    private KrbLoginManager getDefaultLoginManager() {
        String kdc = this.getKrbServiceProperty(Property.KRB_KDC);
        String realm = this.getKrbServiceProperty(Property.KRB_REALM);
        return KrbLoginManagerFactory.getInstance().getKrbLoginManagerInstance(kdc, realm);
    }

    static class Builder {
        private static String KRB_SERVICE_DEFAULT_NAME = "kerberos-service";
        private String serviceName;
        private String krbServiceName;
        private AppConfiguration appConfiguration;
        private KrbLoginManager loginManager;
        private ServiceType serviceType;
        private HadoopClient hadoopClient = new HadoopClient();

        private Builder() {
        }

        public static Builder newInstance() {
            return new Builder();
        }

        public Builder withServiceName(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        public Builder withKrbServiceName(String krbServiceName) {
            this.krbServiceName = this.serviceName;
            return this;
        }

        public Builder withAppConfiguration(AppConfiguration appConfiguration) {
            this.appConfiguration = appConfiguration;
            return this;
        }

        public Builder withLoginManager(KrbLoginManager loginManager) {
            this.loginManager = loginManager;
            return this;
        }

        public Builder withServiceType(ServiceType serviceType) {
            this.serviceType = serviceType;
            return this;
        }

        public Optional<String> getServiceName() {
            return Optional.ofNullable(this.serviceName);
        }

        public Optional<AppConfiguration> getAppConfiguration() {
            return Optional.ofNullable(this.appConfiguration);
        }

        public Optional<String> getKrbServiceName() {
            return Optional.ofNullable(this.krbServiceName);
        }

        public Optional<KrbLoginManager> getLoginManager() {
            return Optional.ofNullable(this.loginManager);
        }

        public Optional<ServiceType> getServiceType() {
            return Optional.ofNullable(this.serviceType);
        }

        public HadoopClient build() {
            AppConfiguration conf = this.getAppConfiguration().orElseGet(() -> {
                try {
                    return Configurations.newInstanceFromEnv();
                }
                catch (IOException ignore) {
                    throw new IllegalStateException("Can't read configuration from environment! Probably not set env variable VCAP_SERVICES!", ignore);
                }
            });
            this.getServiceType().ifPresent(sType -> this.hadoopClient.setServiceConfiguration(conf.getServiceConfig((ServiceType)sType)));
            this.getServiceName().ifPresent(serviceName -> this.hadoopClient.setServiceConfiguration(conf.getServiceConfig((String)serviceName)));
            this.hadoopClient.setKrbServiceConfiguration(conf.getServiceConfig(this.getKrbServiceName().orElse(KRB_SERVICE_DEFAULT_NAME)));
            this.hadoopClient.setLoginManager(this.getLoginManager());
            return this.hadoopClient;
        }
    }
}

