/*
 * Decompiled with CFR 0.152.
 */
package org.trustedanalytics.hadoop.config.client.helper;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.security.UserProvider;
import org.apache.hadoop.security.UserGroupInformation;
import org.trustedanalytics.hadoop.config.client.JwtToken;
import org.trustedanalytics.hadoop.config.client.Property;
import org.trustedanalytics.hadoop.config.client.ServiceType;
import org.trustedanalytics.hadoop.config.client.helper.HadoopClient;

public final class Hbase {
    private final HadoopClient hadoopClient;

    public static Hbase newInstance() throws IOException {
        return new Hbase(HadoopClient.Builder.newInstance().withServiceType(ServiceType.HBASE_TYPE).build());
    }

    public static Hbase newInstance(String instanceName) throws IOException {
        return new Hbase(HadoopClient.Builder.newInstance().withServiceName(instanceName).build());
    }

    @VisibleForTesting
    static Hbase newInstanceForTests(HadoopClient.Builder builder) throws IOException {
        return new Hbase(builder.build());
    }

    private Hbase(HadoopClient hadoopClient) throws IOException {
        this.hadoopClient = hadoopClient;
    }

    public Connection createConnection() throws LoginException, IOException {
        Configuration hbaseConf = HBaseConfiguration.create((Configuration)this.hadoopClient.createConfig());
        if (!this.hadoopClient.isKerberosEnabled(hbaseConf)) {
            return ConnectionFactory.createConnection((Configuration)hbaseConf);
        }
        User user = UserProvider.instantiate((Configuration)hbaseConf).create(UserGroupInformation.getUGIFromSubject((Subject)this.hadoopClient.getLoggedUserIdentity()));
        return ConnectionFactory.createConnection((Configuration)hbaseConf, (User)user);
    }

    public Connection createConnection(JwtToken jwtToken) {
        throw new UnsupportedOperationException("Not implemented, yet!");
    }

    public Configuration createConfig() throws LoginException, IOException {
        return this.hadoopClient.createConfig();
    }

    public Configuration createConfig(JwtToken jwtToken) throws LoginException, IOException {
        return this.hadoopClient.createConfig(jwtToken);
    }

    public boolean isKerberosEnabled(Configuration hadoopConf) {
        return this.hadoopClient.isKerberosEnabled(hadoopConf);
    }

    String getServiceProperty(Property property) {
        return this.hadoopClient.getServiceProperty(property);
    }

    String getKrbServiceProperty(Property property) {
        return this.hadoopClient.getKrbServiceProperty(property);
    }
}

