/*
 * Decompiled with CFR 0.152.
 */
package org.trustedanalytics.hadoop.config.client.helper;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.security.auth.login.LoginException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.trustedanalytics.hadoop.config.client.JwtToken;
import org.trustedanalytics.hadoop.config.client.Property;
import org.trustedanalytics.hadoop.config.client.ServiceType;
import org.trustedanalytics.hadoop.config.client.helper.HadoopClient;

public final class Hdfs {
    private final HadoopClient hadoopClient;

    public static Hdfs newInstance() throws IOException {
        return new Hdfs(HadoopClient.Builder.newInstance().withServiceType(ServiceType.HDFS_TYPE).build());
    }

    public static Hdfs newInstance(String instanceName) throws IOException {
        return new Hdfs(HadoopClient.Builder.newInstance().withServiceName(instanceName).build());
    }

    @VisibleForTesting
    static Hdfs newInstanceForTests(HadoopClient.Builder builder) throws IOException {
        return new Hdfs(builder.build());
    }

    private Hdfs(HadoopClient hadoopClient) throws IOException {
        this.hadoopClient = hadoopClient;
    }

    public FileSystem createFileSystem() throws LoginException, IOException, InterruptedException, URISyntaxException {
        Configuration hadoopConf = this.createConfig();
        String user = this.hadoopClient.getKrbServiceProperty(Property.USER);
        URI hdfsUri = new URI(this.hadoopClient.getServiceProperty(Property.HDFS_URI));
        return FileSystem.get((URI)hdfsUri, (Configuration)hadoopConf, (String)user);
    }

    public FileSystem createFileSystem(JwtToken jwtToken) throws LoginException, IOException, InterruptedException, URISyntaxException {
        throw new UnsupportedOperationException("Not implemented, yet!");
    }

    public Configuration createConfig() throws LoginException, IOException {
        return this.hadoopClient.createConfig();
    }

    public Configuration createConfig(JwtToken jwtToken) throws LoginException, IOException {
        return this.hadoopClient.createConfig(jwtToken);
    }

    public boolean isKerberosEnabled(Configuration hadoopConf) {
        return this.hadoopClient.isKerberosEnabled(hadoopConf);
    }

    String getServiceProperty(Property property) {
        return this.hadoopClient.getServiceProperty(property);
    }

    String getKrbServiceProperty(Property property) {
        return this.hadoopClient.getKrbServiceProperty(property);
    }
}

