/*
 * Decompiled with CFR 0.152.
 */
package org.trustedanalytics.hadoop.config.client.helper;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import javax.security.auth.login.LoginException;
import org.apache.hadoop.conf.Configuration;
import org.trustedanalytics.hadoop.config.client.JwtToken;
import org.trustedanalytics.hadoop.config.client.Property;
import org.trustedanalytics.hadoop.config.client.ServiceType;
import org.trustedanalytics.hadoop.config.client.helper.HadoopClient;

public final class Yarn {
    private final HadoopClient hadoopClient;

    public static Yarn newInstance() throws IOException {
        return new Yarn(HadoopClient.Builder.newInstance().withServiceType(ServiceType.YARN_TYPE).build());
    }

    public static Yarn newInstance(String instanceName) throws IOException {
        return new Yarn(HadoopClient.Builder.newInstance().withServiceName(instanceName).build());
    }

    @VisibleForTesting
    static Yarn newInstanceForTests(HadoopClient.Builder builder) throws IOException {
        return new Yarn(builder.build());
    }

    private Yarn(HadoopClient defaultClient) throws IOException {
        this.hadoopClient = defaultClient;
    }

    public Configuration createConfig() throws LoginException, IOException {
        return this.hadoopClient.createConfig();
    }

    public Configuration createConfig(JwtToken jwtToken) throws LoginException, IOException {
        return this.hadoopClient.createConfig(jwtToken);
    }

    public boolean isKerberosEnabled(Configuration hadoopConf) {
        return this.hadoopClient.isKerberosEnabled(hadoopConf);
    }

    String getServiceProperty(Property property) {
        return this.hadoopClient.getServiceProperty(property);
    }

    String getKrbServiceProperty(Property property) {
        return this.hadoopClient.getKrbServiceProperty(property);
    }
}

