/*
 * Decompiled with CFR 0.152.
 */
package org.trustedanalytics.hadoop.config.internal;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import org.codehaus.jackson.JsonNode;
import org.trustedanalytics.hadoop.config.internal.ConfigNode;

public class JsonConfigNode
implements ConfigNode {
    private JsonNode root;
    private String name = null;

    private JsonConfigNode(String name, JsonNode rootNode) {
        this.root = rootNode;
        this.name = name;
    }

    private JsonConfigNode(JsonNode rootNode) {
        this.root = rootNode;
    }

    public static JsonConfigNode createInstance(JsonNode node) {
        return new JsonConfigNode(node);
    }

    public static JsonConfigNode createInstance(String name, JsonNode node) {
        return new JsonConfigNode(name, node);
    }

    @Override
    public List<ConfigNode> getChildren() {
        ArrayList<ConfigNode> ret = new ArrayList<ConfigNode>();
        if (this.root.isArray()) {
            this.root.getElements().forEachRemaining(child -> {
                JsonNode nameNode = child.get("name");
                if (nameNode == null) {
                    ret.add(JsonConfigNode.createInstance(child));
                } else {
                    ret.add(JsonConfigNode.createInstance(nameNode.getValueAsText(), child));
                }
            });
        } else {
            this.root.getFields().forEachRemaining(child -> {
                String localName = (String)child.getKey();
                JsonNode value = (JsonNode)child.getValue();
                ret.add(JsonConfigNode.createInstance(localName, value));
            });
        }
        return ret;
    }

    @Override
    public ConfigNode find(String name) {
        JsonNode found = (JsonNode)Preconditions.checkNotNull((Object)this.root.findValue(name), (Object)("Can not find config node: " + name));
        return JsonConfigNode.createInstance(name, found);
    }

    @Override
    public List<ConfigNode> findAll(String name) {
        List parents = (List)Preconditions.checkNotNull((Object)this.root.findParents(name), (Object)("None of " + name + " nodes found in configuration"));
        ArrayList<ConfigNode> found = new ArrayList<ConfigNode>();
        parents.forEach(parent -> found.add(JsonConfigNode.createInstance(name, parent.get(name))));
        return found;
    }

    @Override
    public ConfigNode get(String name) {
        JsonNode got = (JsonNode)Preconditions.checkNotNull((Object)this.root.get(name), (Object)("Can not get config node: " + name));
        return JsonConfigNode.createInstance(name, got);
    }

    @Override
    public ConfigNode selectOne(String name, String value) {
        List parents = (List)Preconditions.checkNotNull((Object)this.root.findParents(name), (Object)("None of " + name + " nodes found in configuration"));
        Predicate<JsonNode> conditions = parent -> parent.get(name).isTextual() && parent.get(name).getTextValue().equals(value);
        Optional<JsonNode> found = parents.stream().filter(conditions).findFirst();
        return JsonConfigNode.createInstance(value, found.orElseThrow(() -> new NullPointerException("Can't find child node that has name " + name + " and value " + value + "!")));
    }

    @Override
    public String value() {
        return (String)Preconditions.checkNotNull((Object)this.root.getValueAsText());
    }

    @Override
    public String name() {
        Preconditions.checkNotNull((Object)this.name);
        return this.name;
    }
}

