/*
 * Decompiled with CFR 0.152.
 */
package org.trustedanalytics.hadoop.config.internal;

import com.google.common.base.Preconditions;
import java.io.IOException;
import org.codehaus.jackson.map.ObjectMapper;
import org.trustedanalytics.hadoop.config.internal.ConfigNode;
import org.trustedanalytics.hadoop.config.internal.ConfigurationReader;
import org.trustedanalytics.hadoop.config.internal.JsonConfigNode;

public final class JsonConfigurationReader
implements ConfigurationReader {
    private ConfigNode rootNode;

    public static JsonConfigurationReader getReader(String json) throws IOException {
        Preconditions.checkNotNull((Object)json);
        return new JsonConfigurationReader(json);
    }

    JsonConfigurationReader(FactoryHelper helperFactory, String json) throws IOException {
        this.rootNode = JsonConfigNode.createInstance(helperFactory.getJsonMapper().readTree(json));
    }

    private JsonConfigurationReader(String json) throws IOException {
        this(new FactoryHelper(), json);
    }

    @Override
    public ConfigNode getRootNode() {
        return this.rootNode;
    }

    static final class FactoryHelper {
        FactoryHelper() {
        }

        ObjectMapper getJsonMapper() {
            return new ObjectMapper();
        }
    }
}

