/*
 * Decompiled with CFR 0.152.
 */
package org.trustedanalytics.hadoop.kerberos;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.kerberos.KeyTab;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.authentication.jaas.memory.InMemoryConfiguration;
import org.trustedanalytics.hadoop.kerberos.KrbLoginManager;
import sun.security.krb5.KrbAsReqBuilder;
import sun.security.krb5.KrbException;
import sun.security.krb5.PrincipalName;
import sun.security.krb5.internal.KDCOptions;
import sun.security.krb5.internal.ccache.Credentials;
import sun.security.krb5.internal.ccache.CredentialsCache;

final class HadoopKrbLoginManager
implements KrbLoginManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(HadoopKrbLoginManager.class);
    static final String KRB5_KDC = "java.security.krb5.kdc";
    static final String KRB5_REALM = "java.security.krb5.realm";
    static final String KRB5_KINIT_CMD_PROP_NAME = "hadoop.kerberos.kinit.command";
    static final String KRB5_USE_SUBJECT_CREDS_LIMITATION = "javax.security.auth.useSubjectCredsOnly";
    static final String KRB5_CONF = "java.security.krb5.conf";
    static final String KRB5_TGT_PRINCIPAL_NAME = "krbtgt";
    private static final String KERB_MODULE = "com.sun.security.auth.module.Krb5LoginModule";
    private static final String KRB5_CREDENTIALS_CACHE_DIR = "/tmp/";
    private FactoryHelper helper;

    HadoopKrbLoginManager(String kdc, String defaultRealm, FactoryHelper helper) {
        HadoopKrbLoginManager.validateParams(kdc, defaultRealm);
        this.initKerberos(kdc, defaultRealm);
        this.helper = helper;
    }

    HadoopKrbLoginManager(String kdc, String defaultRealm) {
        this(kdc, defaultRealm, new FactoryHelper());
    }

    static void validateParams(String kdcParam, String defaultRealmParam) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)kdcParam) ? 1 : 0) != 0, (Object)"KDC address cannot be empty");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)defaultRealmParam) ? 1 : 0) != 0, (Object)"Default realm cannot be empty");
    }

    @Override
    public Subject loginWithJWTtoken(String jwtToken) throws LoginException {
        return null;
    }

    @Override
    public Subject loginWithCredentials(String user, char[] password) throws LoginException {
        this.setKerbConfigFromOpts(HadoopKrbLoginManager.getDefaultOptionsForPrincipal(user));
        LoginContext lc = this.helper.getLoginContext(KERB_MODULE, new FixedPasswordHandler(password));
        this.helper.cacheKrbCredentials(user, password);
        return this.login(lc);
    }

    @Override
    public Subject loginWithKeyTab(String user, String path) throws LoginException {
        this.setKerbConfigFromOpts(HadoopKrbLoginManager.getKeyTabOptionsForPrincipal(user, path));
        LoginContext lc = this.helper.getLoginContext(KERB_MODULE);
        this.helper.cacheKrbCredentials(user, path);
        return this.login(lc);
    }

    @Override
    public void loginInHadoop(Subject subject, Configuration hadoopConf) throws IOException {
        Preconditions.checkNotNull((Object)subject, (Object)"Subject can't be null!");
        Preconditions.checkNotNull((Object)hadoopConf, (Object)"Hadoop configuration can't be null!");
        String ccLocation = this.ticketCacheLocation(subject);
        hadoopConf.set("hadoop.security.kerberos.ticket.cache.path", ccLocation);
        hadoopConf.set(KRB5_KINIT_CMD_PROP_NAME, "kinit -c " + ccLocation);
        this.getUGI(subject);
        UserGroupInformation.setConfiguration((Configuration)hadoopConf);
    }

    @Override
    public UserGroupInformation getUGI(Subject subject) throws IOException {
        Preconditions.checkNotNull((Object)subject, (Object)"Subject can't be null!");
        return UserGroupInformation.getBestUGI((String)this.ticketCacheLocation(subject), (String)this.getUserName(subject));
    }

    String getUserName(Subject subject) {
        Preconditions.checkNotNull((Object)subject, (Object)"Subject can't be null!");
        Preconditions.checkArgument((!subject.getPrincipals().isEmpty() ? 1 : 0) != 0, (Object)"Can't find any principal in given Subject!");
        return subject.getPrincipals().iterator().next().getName();
    }

    private String ticketCacheLocation(Subject subject) {
        return KRB5_CREDENTIALS_CACHE_DIR + this.getUserName(subject);
    }

    private void initKerberos(String kdc, String defaultRealm) {
        System.setProperty(KRB5_KDC, kdc);
        System.setProperty(KRB5_REALM, defaultRealm);
        System.setProperty(KRB5_USE_SUBJECT_CREDS_LIMITATION, "false");
    }

    private static Map<String, String> getKeyTabOptionsForPrincipal(String user, String path) {
        Map<String, String> opts = HadoopKrbLoginManager.getDefaultOptionsForPrincipal(user);
        opts.put("keyTab", path);
        opts.put("useKeyTab", "true");
        return opts;
    }

    private Subject login(LoginContext lc) throws LoginException {
        lc.login();
        return lc.getSubject();
    }

    public void setKerbConfigFromOpts(Map<String, String> opts) {
        AppConfigurationEntry[] appConfigurationEntry = new AppConfigurationEntry[]{new AppConfigurationEntry(KERB_MODULE, AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, opts)};
        javax.security.auth.login.Configuration.setConfiguration((javax.security.auth.login.Configuration)new InMemoryConfiguration(appConfigurationEntry));
    }

    private static Map<String, String> getDefaultOptionsForPrincipal(String user) {
        HashMap<String, String> options = new HashMap<String, String>();
        LOGGER.debug("Using principal name : " + user);
        options.put("principal", user);
        options.put("storeKey", "false");
        options.put("doNotPrompt", "false");
        options.put("useTicketCache", "true");
        options.put("renewTGT", "true");
        options.put("refreshKrb5Config", "true");
        options.put("isInitiator", "true");
        options.put("clearPass", "false");
        options.put("ticketCache", KRB5_CREDENTIALS_CACHE_DIR + user + "@" + System.getProperty(KRB5_REALM));
        options.put("debug", "true");
        return options;
    }

    static class FactoryHelper {
        FactoryHelper() {
        }

        LoginContext getLoginContext(String module, CallbackHandler handler) throws LoginException {
            return new LoginContext(module, handler);
        }

        LoginContext getLoginContext(String module) throws LoginException {
            return new LoginContext(module);
        }

        synchronized void cacheKrbCredentials(String user, char[] pass) throws LoginException {
            try {
                PrincipalName pName = new PrincipalName(user, 1);
                this.getTgt(pName, this.prepareTgtReq(pName, pass));
            }
            catch (IOException | KrbException e) {
                LoginException propagate = new LoginException(e.getMessage());
                propagate.initCause(e);
                throw propagate;
            }
        }

        synchronized void cacheKrbCredentials(String user, String keyTabPath) throws LoginException {
            try {
                PrincipalName pName = new PrincipalName(user, 1);
                this.getTgt(pName, this.prepareTgtReq(pName, keyTabPath));
            }
            catch (IOException | KrbException e) {
                LoginException propagate = new LoginException(e.getMessage());
                propagate.initCause(e);
                throw propagate;
            }
        }

        private KrbAsReqBuilder prepareTgtReq(PrincipalName pName, char[] secret) throws KrbException {
            return new KrbAsReqBuilder(pName, secret);
        }

        private KrbAsReqBuilder prepareTgtReq(PrincipalName pName, String keyTabLocation) throws KrbException {
            KeyTab secret = KeyTab.getInstance(new File(keyTabLocation));
            return new KrbAsReqBuilder(pName, secret);
        }

        private void getTgt(PrincipalName pName, KrbAsReqBuilder builder) throws KrbException, IOException {
            PrincipalName krbTGTpName = new PrincipalName("krbtgt/" + System.getProperty(HadoopKrbLoginManager.KRB5_REALM), 2);
            String cCacheLocation = "FILE:/tmp/" + pName.getName();
            KDCOptions kdcOptions = new KDCOptions();
            kdcOptions.set(1, true);
            kdcOptions.set(3, true);
            kdcOptions.set(8, true);
            builder.setOptions(kdcOptions);
            builder.setTarget(krbTGTpName);
            builder.action();
            Credentials cCreds = builder.getCCreds();
            builder.destroy();
            CredentialsCache cc = CredentialsCache.getInstance(pName, cCacheLocation);
            if (cc == null) {
                LOGGER.debug("Creating new credentials cache file: " + cCacheLocation);
                cc = CredentialsCache.create(pName, cCacheLocation);
            }
            cc.update(cCreds);
            cc.save();
        }
    }

    static final class FixedPasswordHandler
    implements CallbackHandler {
        private char[] password;

        public FixedPasswordHandler(char[] password) {
            this.password = password;
        }

        @Override
        public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
            for (Callback callback : callbacks) {
                if (!(callback instanceof PasswordCallback)) {
                    throw new UnsupportedCallbackException(callback);
                }
                ((PasswordCallback)callback).setPassword(this.password);
            }
        }
    }
}

