/*
 * Decompiled with CFR 0.152.
 */
package org.trustedanalytics.hadoop.kerberos;

import com.google.common.annotations.VisibleForTesting;
import org.trustedanalytics.hadoop.kerberos.HadoopKrbLoginManager;
import org.trustedanalytics.hadoop.kerberos.KrbLoginManager;

public class KrbLoginManagerFactory {
    private volatile KrbLoginManager managerInstance = null;
    private String kdc;
    private String defaultRealm;

    @VisibleForTesting
    KrbLoginManagerFactory() {
    }

    public static KrbLoginManagerFactory getInstance() {
        return Holder.factory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public KrbLoginManager getKrbLoginManagerInstance(String kdcParam, String defaultRealmParam) {
        if (this.managerInstance == null) {
            KrbLoginManagerFactory krbLoginManagerFactory = this;
            synchronized (krbLoginManagerFactory) {
                if (this.managerInstance == null) {
                    this.kdc = kdcParam;
                    this.defaultRealm = defaultRealmParam;
                    this.managerInstance = new HadoopKrbLoginManager(this.kdc, this.defaultRealm);
                }
            }
        }
        this.ensureSameInstanceRequested(kdcParam, defaultRealmParam);
        return this.managerInstance;
    }

    private void ensureSameInstanceRequested(String kdcParam, String defaultRealmParam) {
        if (!kdcParam.equals(this.kdc) || !defaultRealmParam.equals(this.defaultRealm)) {
            throw new IllegalArgumentException("Not implemented. This factory can not newInstance new instance of KrbLoginManager. KrbLoginManager(" + kdcParam + "," + defaultRealmParam + ") requested, but " + "KrbLoginManager(" + this.kdc + "," + this.defaultRealm + ") was previously created");
        }
    }

    private static class Holder {
        static final KrbLoginManagerFactory factory = new KrbLoginManagerFactory();

        private Holder() {
        }
    }
}

