/*
 * Decompiled with CFR 0.152.
 */
package org.tupol.spark.io;

import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.tupol.spark.io.DataAwareSink;
import org.tupol.spark.io.DataAwareSinkFactory;
import org.tupol.spark.io.DataSinkConfiguration;
import org.tupol.spark.io.DataSource;
import org.tupol.spark.io.DataSourceConfiguration;
import org.tupol.spark.io.DataSourceFactory;
import org.tupol.spark.io.FileDataAwareSink;
import org.tupol.spark.io.FileDataSource;
import org.tupol.spark.io.FileSinkConfiguration;
import org.tupol.spark.io.FileSourceConfiguration;
import org.tupol.spark.io.GenericDataAwareSink;
import org.tupol.spark.io.GenericDataSource;
import org.tupol.spark.io.GenericSinkConfiguration;
import org.tupol.spark.io.JdbcDataAwareSink;
import org.tupol.spark.io.JdbcDataSource;
import org.tupol.spark.io.JdbcSinkConfiguration;
import org.tupol.spark.io.sources.package;
import org.tupol.spark.io.streaming.structured.FileStreamDataAwareSink;
import org.tupol.spark.io.streaming.structured.FileStreamDataSinkConfiguration;
import org.tupol.spark.io.streaming.structured.FileStreamDataSource;
import org.tupol.spark.io.streaming.structured.FileStreamDataSourceConfiguration;
import org.tupol.spark.io.streaming.structured.GenericStreamDataAwareSink;
import org.tupol.spark.io.streaming.structured.GenericStreamDataSinkConfiguration;
import org.tupol.spark.io.streaming.structured.GenericStreamDataSource;
import org.tupol.spark.io.streaming.structured.GenericStreamDataSourceConfiguration;
import org.tupol.spark.io.streaming.structured.KafkaStreamDataAwareSink;
import org.tupol.spark.io.streaming.structured.KafkaStreamDataSinkConfiguration;
import org.tupol.spark.io.streaming.structured.KafkaStreamDataSource;
import org.tupol.spark.io.streaming.structured.KafkaStreamDataSourceConfiguration;
import scala.MatchError;
import scala.Product;
import scala.runtime.BoxesRunTime;

public final class package$ {
    public static package$ MODULE$;
    private final DataSourceFactory DataSourceFactory;
    private final DataAwareSinkFactory DataAwareSinkFactory;

    static {
        new package$();
    }

    public DataSourceFactory DataSourceFactory() {
        return this.DataSourceFactory;
    }

    public DataAwareSinkFactory DataAwareSinkFactory() {
        return this.DataAwareSinkFactory;
    }

    private package$() {
        MODULE$ = this;
        this.DataSourceFactory = new DataSourceFactory(){

            public <C extends DataSourceConfiguration> DataSource<C> apply(C configuration) {
                DataSource<FileSourceConfiguration> dataSource;
                C c = configuration;
                if (c instanceof FileSourceConfiguration) {
                    FileSourceConfiguration fileSourceConfiguration = (FileSourceConfiguration)c;
                    dataSource = new FileDataSource(fileSourceConfiguration);
                } else if (c instanceof package.JdbcSourceConfiguration) {
                    package.JdbcSourceConfiguration jdbcSourceConfiguration = (package.JdbcSourceConfiguration)c;
                    dataSource = new JdbcDataSource(jdbcSourceConfiguration);
                } else if (c instanceof package.GenericSourceConfiguration) {
                    package.GenericSourceConfiguration genericSourceConfiguration = (package.GenericSourceConfiguration)c;
                    dataSource = new GenericDataSource(genericSourceConfiguration);
                } else if (c instanceof FileStreamDataSourceConfiguration) {
                    FileStreamDataSourceConfiguration fileStreamDataSourceConfiguration = (FileStreamDataSourceConfiguration)c;
                    dataSource = new FileStreamDataSource(fileStreamDataSourceConfiguration);
                } else if (c instanceof KafkaStreamDataSourceConfiguration) {
                    KafkaStreamDataSourceConfiguration kafkaStreamDataSourceConfiguration = (KafkaStreamDataSourceConfiguration)c;
                    dataSource = new KafkaStreamDataSource(kafkaStreamDataSourceConfiguration);
                } else if (c instanceof GenericStreamDataSourceConfiguration) {
                    GenericStreamDataSourceConfiguration genericStreamDataSourceConfiguration = (GenericStreamDataSourceConfiguration)c;
                    dataSource = new GenericStreamDataSource(genericStreamDataSourceConfiguration);
                } else {
                    throw new IllegalArgumentException(new StringBuilder(32).append("Unsupported configuration type ").append(c.getClass()).append(".").toString());
                }
                return dataSource;
            }
        };
        this.DataAwareSinkFactory = new DataAwareSinkFactory(){

            public <C extends DataSinkConfiguration, WO> DataAwareSink<C, WO> apply(C configuration, Dataset<Row> data) {
                Product product;
                boolean bl = data.isStreaming();
                if (!bl) {
                    Product product2;
                    C c = configuration;
                    if (c instanceof FileSinkConfiguration) {
                        FileSinkConfiguration fileSinkConfiguration = (FileSinkConfiguration)c;
                        product2 = new FileDataAwareSink(fileSinkConfiguration, data);
                    } else if (c instanceof JdbcSinkConfiguration) {
                        JdbcSinkConfiguration jdbcSinkConfiguration = (JdbcSinkConfiguration)c;
                        product2 = new JdbcDataAwareSink(jdbcSinkConfiguration, data);
                    } else if (c instanceof GenericSinkConfiguration) {
                        GenericSinkConfiguration genericSinkConfiguration = (GenericSinkConfiguration)c;
                        product2 = new GenericDataAwareSink(genericSinkConfiguration, data);
                    } else {
                        throw new IllegalArgumentException(new StringBuilder(32).append("Unsupported configuration type ").append(c.getClass()).append(".").toString());
                    }
                    product = product2;
                } else if (bl) {
                    Product product3;
                    C c = configuration;
                    if (c instanceof FileStreamDataSinkConfiguration) {
                        FileStreamDataSinkConfiguration fileStreamDataSinkConfiguration = (FileStreamDataSinkConfiguration)c;
                        product3 = new FileStreamDataAwareSink(fileStreamDataSinkConfiguration, data);
                    } else if (c instanceof KafkaStreamDataSinkConfiguration) {
                        KafkaStreamDataSinkConfiguration kafkaStreamDataSinkConfiguration = (KafkaStreamDataSinkConfiguration)c;
                        product3 = new KafkaStreamDataAwareSink(kafkaStreamDataSinkConfiguration, data);
                    } else if (c instanceof GenericStreamDataSinkConfiguration) {
                        GenericStreamDataSinkConfiguration genericStreamDataSinkConfiguration = (GenericStreamDataSinkConfiguration)c;
                        product3 = new GenericStreamDataAwareSink(genericStreamDataSinkConfiguration, data);
                    } else {
                        throw new IllegalArgumentException(new StringBuilder(32).append("Unsupported configuration type ").append(c.getClass()).append(".").toString());
                    }
                    product = product3;
                } else {
                    throw new MatchError((Object)BoxesRunTime.boxToBoolean((boolean)bl));
                }
                return product;
            }
        };
    }
}

