/*
 * Decompiled with CFR 0.152.
 */
package org.tweetyproject.beliefdynamics.examples;

import java.util.Collection;
import org.tweetyproject.arg.dung.reasoner.SatCompleteReasoner;
import org.tweetyproject.arg.dung.syntax.Argument;
import org.tweetyproject.arg.dung.syntax.ArgumentationFramework;
import org.tweetyproject.arg.dung.syntax.Attack;
import org.tweetyproject.arg.dung.syntax.DungTheory;
import org.tweetyproject.beliefdynamics.DefaultMultipleBaseExpansionOperator;
import org.tweetyproject.beliefdynamics.LeviMultipleBaseRevisionOperator;
import org.tweetyproject.beliefdynamics.kernels.KernelContractionOperator;
import org.tweetyproject.beliefdynamics.kernels.RandomIncisionFunction;
import org.tweetyproject.logics.pl.reasoner.SimplePlReasoner;
import org.tweetyproject.logics.pl.sat.SatSolver;
import org.tweetyproject.logics.pl.semantics.PossibleWorld;
import org.tweetyproject.logics.pl.syntax.PlBeliefSet;
import org.tweetyproject.logics.pl.syntax.PlSignature;
import org.tweetyproject.logics.pl.syntax.Proposition;

public class AbstractArgumentationExample {
    public static void main(String[] args) {
        DungTheory theory = new DungTheory();
        Argument a = new Argument("a");
        Argument b = new Argument("b");
        Argument c = new Argument("c");
        theory.add(a);
        theory.add(b);
        theory.add(c);
        theory.add(new Attack(a, b));
        theory.add(new Attack(b, c));
        theory.add(new Attack(c, b));
        theory.add(new Attack(c, a));
        SatCompleteReasoner reasoner = new SatCompleteReasoner(SatSolver.getDefaultSolver());
        System.out.println(reasoner.getModels((ArgumentationFramework)theory));
        System.out.println();
        PlBeliefSet beliefSet = reasoner.getPropositionalCharacterisation(theory);
        System.out.println(beliefSet);
        System.out.println();
        for (PossibleWorld w : PossibleWorld.getAllPossibleWorlds((PlSignature)beliefSet.getMinimalSignature())) {
            if (!w.satisfies(beliefSet)) continue;
            System.out.println(w);
        }
        LeviMultipleBaseRevisionOperator<Proposition> revise = new LeviMultipleBaseRevisionOperator<Proposition>(new KernelContractionOperator(new RandomIncisionFunction(), new SimplePlReasoner()), new DefaultMultipleBaseExpansionOperator());
        PlBeliefSet beliefSet2 = new PlBeliefSet(revise.revise((Collection<Proposition>)beliefSet, new Proposition("in_a")));
        System.out.println(beliefSet2);
        System.out.println();
        for (PossibleWorld w : PossibleWorld.getAllPossibleWorlds((PlSignature)beliefSet2.getMinimalSignature())) {
            if (!w.satisfies(beliefSet2)) continue;
            System.out.println(w);
        }
    }
}

