/*
 * Decompiled with CFR 0.152.
 */
package org.tweetyproject.beliefdynamics.examples;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.tweetyproject.agents.Agent;
import org.tweetyproject.agents.DummyAgent;
import org.tweetyproject.beliefdynamics.DefaultMultipleBaseExpansionOperator;
import org.tweetyproject.beliefdynamics.LeviMultipleBaseRevisionOperator;
import org.tweetyproject.beliefdynamics.kernels.KernelContractionOperator;
import org.tweetyproject.beliefdynamics.kernels.RandomIncisionFunction;
import org.tweetyproject.beliefdynamics.mas.CrMasBeliefSet;
import org.tweetyproject.beliefdynamics.mas.CrMasRevisionWrapper;
import org.tweetyproject.beliefdynamics.mas.InformationObject;
import org.tweetyproject.beliefdynamics.operators.CrMasArgumentativeRevisionOperator;
import org.tweetyproject.beliefdynamics.operators.CrMasSimpleRevisionOperator;
import org.tweetyproject.commons.ParserException;
import org.tweetyproject.graphs.orders.Order;
import org.tweetyproject.logics.pl.parser.PlParser;
import org.tweetyproject.logics.pl.reasoner.SimplePlReasoner;
import org.tweetyproject.logics.pl.syntax.PlFormula;
import org.tweetyproject.logics.pl.syntax.PlSignature;

public class CrMasExample {
    public static void main(String[] args) throws ParserException, IOException {
        PlParser parser = new PlParser();
        ArrayList<DummyAgent> agents = new ArrayList<DummyAgent>();
        agents.add(new DummyAgent("A1"));
        agents.add(new DummyAgent("A2"));
        agents.add(new DummyAgent("A3"));
        Order credOrder = new Order(agents);
        credOrder.setOrderedBefore((Object)((Agent)agents.get(0)), (Object)((Agent)agents.get(1)));
        credOrder.setOrderedBefore((Object)((Agent)agents.get(1)), (Object)((Agent)agents.get(2)));
        CrMasBeliefSet bs = new CrMasBeliefSet((Order<Agent>)credOrder, new PlSignature());
        bs.add(new InformationObject<PlFormula>((PlFormula)parser.parseFormula("!c"), (Agent)agents.get(1)));
        bs.add(new InformationObject<PlFormula>((PlFormula)parser.parseFormula("b"), (Agent)agents.get(2)));
        bs.add(new InformationObject<PlFormula>((PlFormula)parser.parseFormula("!b||!a"), (Agent)agents.get(2)));
        HashSet<InformationObject<PlFormula>> newInformation = new HashSet<InformationObject<PlFormula>>();
        newInformation.add(new InformationObject<PlFormula>((PlFormula)parser.parseFormula("a"), (Agent)agents.get(2)));
        newInformation.add(new InformationObject<PlFormula>((PlFormula)parser.parseFormula("!a||c"), (Agent)agents.get(2)));
        System.out.println(bs + " * " + newInformation);
        System.out.println();
        CrMasRevisionWrapper<PlFormula> rev = new CrMasRevisionWrapper<PlFormula>(new LeviMultipleBaseRevisionOperator(new KernelContractionOperator(new RandomIncisionFunction(), new SimplePlReasoner()), new DefaultMultipleBaseExpansionOperator()));
        System.out.println("PRIO       :\t " + rev.revise((Collection<InformationObject<PlFormula>>)((Object)bs), (Collection<InformationObject<PlFormula>>)newInformation));
        CrMasSimpleRevisionOperator rev2 = new CrMasSimpleRevisionOperator();
        System.out.println("N-PRIO CRED:\t " + rev2.revise((Collection<InformationObject<PlFormula>>)((Object)bs), (Collection<InformationObject<PlFormula>>)newInformation));
        CrMasArgumentativeRevisionOperator theRevision = new CrMasArgumentativeRevisionOperator();
        System.out.println("ARG        :\t " + theRevision.revise((Collection<InformationObject<PlFormula>>)((Object)bs), (Collection<InformationObject<PlFormula>>)newInformation));
    }
}

