/*
 * Decompiled with CFR 0.152.
 */
package org.tweetyproject.beliefdynamics.gui;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.tweetyproject.beliefdynamics.BaseRevisionOperator;
import org.tweetyproject.commons.Formula;

public class RevisionCompareModel {
    private PropertyChangeSupport change = new PropertyChangeSupport(this);
    protected BaseRevisionOperator<?> leftOperator;
    protected BaseRevisionOperator<?> rightOperator;
    protected boolean leftIterative;
    protected boolean rightIterative;
    protected Set<BaseRevisionOperator<?>> selectableOperators = new HashSet();
    protected List<Collection<?>> beliefBases = new LinkedList();

    public void addListener(PropertyChangeListener listener) {
        this.change.addPropertyChangeListener(listener);
    }

    public void removeListener(PropertyChangeListener listener) {
        this.change.removePropertyChangeListener(listener);
    }

    public void setLeftOperator(BaseRevisionOperator<?> left) {
        if (this.selectableOperators.contains(left)) {
            BaseRevisionOperator<?> old = this.leftOperator;
            this.leftOperator = left;
            this.change.firePropertyChange("leftOperator", old, left);
        }
    }

    public void setRightOperator(BaseRevisionOperator<?> right) {
        if (this.selectableOperators.contains(right)) {
            BaseRevisionOperator<?> old = this.rightOperator;
            this.rightOperator = right;
            this.change.firePropertyChange("rightOperator", old, right);
        }
    }

    public void addBeliefbase(Collection<? extends Formula> beliefBase) {
        this.beliefBases.add(beliefBase);
        this.change.fireIndexedPropertyChange("beliefBases", this.beliefBases.size() - 1, null, beliefBase);
    }

    public void removeBeliefbase(Collection<?> beliefBase) {
        int index = this.beliefBases.indexOf(beliefBase);
        if (index != -1) {
            this.beliefBases.remove(index);
            this.change.fireIndexedPropertyChange("beliefBases", index, beliefBase, null);
        }
    }

    public void moveBeliefbase(Collection<?> beliefBase, int dir) {
        int newIndex;
        if (dir != -1 && dir != 1) {
            throw new IllegalArgumentException("dir must not be 1 for upwards or -1 for downwards");
        }
        int index = this.beliefBases.indexOf(beliefBase);
        if (index != -1 && (newIndex = index + dir) >= 0 && newIndex < this.beliefBases.size()) {
            Collection<?> other = this.beliefBases.get(newIndex);
            this.beliefBases.set(newIndex, beliefBase);
            this.beliefBases.set(index, other);
            this.change.fireIndexedPropertyChange("beliefBases", index, beliefBase, other);
            this.change.fireIndexedPropertyChange("beliefBases", newIndex, other, beliefBase);
        }
    }

    public void addOperator(BaseRevisionOperator<?> op) {
        if (this.selectableOperators.add(op)) {
            this.change.firePropertyChange("selectableOperators", null, op);
        }
    }

    public void removeOperator(BaseRevisionOperator<?> op) {
        if (this.selectableOperators.remove(op)) {
            this.change.firePropertyChange("selectableOperators", op, null);
        }
    }

    public void setLeftIterative(boolean b) {
        if (this.leftIterative != b) {
            this.leftIterative = b;
            this.change.firePropertyChange("leftIterative", !this.leftIterative, this.leftIterative);
        }
    }

    public void setRightIterative(boolean b) {
        if (this.rightIterative != b) {
            this.rightIterative = b;
            this.change.firePropertyChange("rightIterative", !this.rightIterative, this.rightIterative);
        }
    }
}

