/*
 * Decompiled with CFR 0.152.
 */
package org.tweetyproject.beliefdynamics.gui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.util.Collection;
import java.util.LinkedList;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.filechooser.FileFilter;
import org.tweetyproject.beliefdynamics.BaseRevisionOperator;
import org.tweetyproject.beliefdynamics.gui.RevisionCompareModel;
import org.tweetyproject.beliefdynamics.gui.RevisionCompareView;
import org.tweetyproject.commons.Formula;
import org.tweetyproject.commons.Signature;

public class RevisionComparePresenter
implements ItemListener,
ChangeListener,
ActionListener {
    private RevisionCompareModel model;
    private RevisionCompareView view;
    private FileHandler fileHandler = new DefaultFileHandler();

    public RevisionComparePresenter(RevisionCompareModel model, RevisionCompareView view) {
        this.model = model;
        this.view = view;
        model.addListener(view);
        this.registerAsViewListener();
    }

    public void setFileHandler(FileHandler handler) {
        this.fileHandler = handler == null ? new DefaultFileHandler() : handler;
    }

    private void registerAsViewListener() {
        this.view.cbOperatorLeft.addItemListener(this);
        this.view.cbOperatorRight.addItemListener(this);
        this.view.checkIterativeLeft.addChangeListener(this);
        this.view.checkIterativeRight.addChangeListener(this);
        this.view.sliderStep.addChangeListener(this);
        this.view.btnUp.addActionListener(this);
        this.view.btnDown.addActionListener(this);
        this.view.btnAdd.addActionListener(this);
        this.view.btnRemove.addActionListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        if (ev.getSource() == this.view.btnAdd) {
            File[] choosenFiles;
            JFileChooser chooser = new JFileChooser();
            chooser.setAcceptAllFileFilterUsed(false);
            chooser.setCurrentDirectory(this.fileHandler.getCurrentDiretory());
            chooser.setFileFilter(this.fileHandler.getFilter());
            chooser.setMultiSelectionEnabled(true);
            chooser.showOpenDialog(this.view);
            for (File choosenFile : choosenFiles = chooser.getSelectedFiles()) {
                Collection<? extends Formula> beliefBase = this.fileHandler.load(choosenFile);
                if (beliefBase == null) {
                    JOptionPane.showMessageDialog(this.view, "Cannot load '" + choosenFile.getPath() + "' using the file handler: '" + this.fileHandler.getClass().getName() + "'.");
                    continue;
                }
                this.model.addBeliefbase(beliefBase);
            }
        } else if (ev.getSource() == this.view.btnRemove) {
            this.model.removeBeliefbase(this.view.lstBeliefBases.getSelectedValue());
        } else if (ev.getSource() == this.view.btnUp || ev.getSource() == this.view.btnDown) {
            int dir = ev.getSource() == this.view.btnUp ? -1 : 1;
            this.model.moveBeliefbase(this.view.lstBeliefBases.getSelectedValue(), dir);
        }
    }

    @Override
    public void stateChanged(ChangeEvent ev) {
        if (ev.getSource() != this.view.sliderStep) {
            if (ev.getSource() == this.view.checkIterativeLeft) {
                this.model.setLeftIterative(this.view.checkIterativeLeft.isSelected());
            } else if (ev.getSource() == this.view.checkIterativeRight) {
                this.model.setRightIterative(this.view.checkIterativeRight.isSelected());
            }
        }
    }

    @Override
    public void itemStateChanged(ItemEvent ev) {
        if (ev.getSource() == this.view.cbOperatorLeft) {
            this.model.setLeftOperator((BaseRevisionOperator)this.view.cbOperatorLeft.getSelectedItem());
        } else if (ev.getSource() == this.view.cbOperatorRight) {
            this.model.setRightOperator((BaseRevisionOperator)this.view.cbOperatorRight.getSelectedItem());
        }
    }

    public static void main(String[] args) {
        RevisionCompareModel model = new RevisionCompareModel();
        RevisionCompareView view = new RevisionCompareView();
        new RevisionComparePresenter(model, view);
        JFrame frame = new JFrame("Functional Test: Revision Compare View");
        frame.setDefaultCloseOperation(3);
        frame.add(view);
        frame.setVisible(true);
        LinkedList<MockFormula> c1 = new LinkedList<MockFormula>();
        LinkedList<MockFormula> c2 = new LinkedList<MockFormula>();
        LinkedList<MockFormula> c3 = new LinkedList<MockFormula>();
        c1.add(new MockFormula());
        c2.add(new MockFormula());
        c1.add(new MockFormula());
        c3.add(new MockFormula());
        c3.add(new MockFormula());
        model.addBeliefbase(c1);
        model.addBeliefbase(c2);
        model.addBeliefbase(c3);
        model.addOperator(new MockOperator("Preference Handling"));
        model.addOperator(new MockOperator("Credibility Aware"));
        frame.pack();
    }

    private static class DefaultFileHandler
    implements FileHandler {
        private DefaultFileHandler() {
        }

        @Override
        public Collection<? extends Formula> load(File file) {
            return null;
        }

        @Override
        public FileFilter getFilter() {
            return new FileFilter(){

                @Override
                public String getDescription() {
                    return "NO-FILE-HANDLER-CODDING-ERROR";
                }

                @Override
                public boolean accept(File f) {
                    return false;
                }
            };
        }

        @Override
        public File getCurrentDiretory() {
            return new File(".");
        }
    }

    public static interface FileHandler {
        public Collection<? extends Formula> load(File var1);

        public FileFilter getFilter();

        public File getCurrentDiretory();
    }

    private static class MockFormula
    implements Formula {
        private char mc;
        private static char c = (char)97;

        public MockFormula() {
            char c = MockFormula.c;
            MockFormula.c = (char)(c + '\u0001');
            this.mc = c;
        }

        public Signature getSignature() {
            return null;
        }

        public String toString() {
            return "" + this.mc;
        }
    }

    private static class MockOperator
    implements BaseRevisionOperator<MockFormula> {
        private String name;

        public MockOperator(String name) {
            this.name = name;
        }

        @Override
        public Collection<MockFormula> revise(Collection<MockFormula> base, MockFormula formula) {
            base.add(formula);
            return base;
        }

        public String toString() {
            return this.name;
        }
    }
}

