/*
 * Decompiled with CFR 0.152.
 */
package org.tweetyproject.beliefdynamics.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.beans.IndexedPropertyChangeEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTextArea;
import org.tweetyproject.beliefdynamics.BaseRevisionOperator;
import org.tweetyproject.beliefdynamics.CredibilityRevision;
import org.tweetyproject.beliefdynamics.MultipleBaseRevisionOperator;
import org.tweetyproject.commons.Formula;

public class RevisionCompareView
extends JPanel
implements PropertyChangeListener {
    private static final long serialVersionUID = 5699544277473453367L;
    protected JComboBox<BaseRevisionOperator<?>> cbOperatorLeft;
    protected JComboBox<BaseRevisionOperator<?>> cbOperatorRight;
    protected JCheckBox checkIterativeLeft;
    protected JCheckBox checkIterativeRight;
    protected JButton btnUp;
    protected JButton btnDown;
    protected JButton btnAdd;
    protected JButton btnRemove;
    protected JSlider sliderStep;
    protected JTextArea txtResultLeft;
    protected JTextArea txtResultRight;
    protected JTextArea txtBeliefBases;
    private DefaultListModel<Collection<? extends Formula>> lstModel = new DefaultListModel();
    protected JList<Collection<? extends Formula>> lstBeliefBases;

    public RevisionCompareView() {
        this.createUpperBar();
        this.createCompareView();
        this.createBeliefbaseControl();
    }

    private void createBeliefbaseControl() {
        JPanel actPanel = new JPanel();
        actPanel.setLayout(new BorderLayout());
        actPanel.add((Component)new JLabel("Textual belief base representation"), "North");
        this.txtBeliefBases = new JTextArea(10, 20);
        actPanel.add((Component)new JScrollPane(this.txtBeliefBases), "Center");
        JPanel lstPanel = new JPanel();
        lstPanel.setLayout(new BorderLayout());
        this.lstBeliefBases = new JList();
        this.lstBeliefBases.setModel(this.lstModel);
        lstPanel.add(this.lstBeliefBases, "Center");
        JPanel btnPanel = new JPanel();
        btnPanel.setLayout(new BoxLayout(btnPanel, 1));
        this.btnUp = new JButton("Up");
        this.btnDown = new JButton("Down");
        this.btnAdd = new JButton("Load...");
        this.btnRemove = new JButton("Remove");
        btnPanel.add(this.btnUp);
        btnPanel.add(this.btnDown);
        btnPanel.add(this.btnAdd);
        btnPanel.add(this.btnRemove);
        lstPanel.add((Component)btnPanel, "West");
        actPanel.add((Component)lstPanel, "South");
        this.add((Component)actPanel, "South");
    }

    private void createCompareView() {
        JPanel parentPanel = new JPanel();
        parentPanel.setLayout(new BorderLayout());
        JPanel topPanel = new JPanel();
        topPanel.setLayout(new BorderLayout());
        topPanel.add((Component)new JLabel("Step Slider"), "North");
        this.sliderStep = new JSlider(0, 1);
        topPanel.add((Component)this.sliderStep, "Center");
        topPanel.add((Component)new JLabel("Comparison: revision result"), "South");
        parentPanel.add((Component)topPanel, "North");
        JPanel txtPanel = new JPanel();
        txtPanel.setLayout(new GridLayout(1, 2, 5, 5));
        this.txtResultLeft = new JTextArea(10, 20);
        this.txtResultLeft.setEditable(false);
        txtPanel.add(this.txtResultLeft);
        this.txtResultRight = new JTextArea(10, 20);
        this.txtResultRight.setEditable(false);
        txtPanel.add(this.txtResultRight);
        parentPanel.add((Component)new JScrollPane(txtPanel), "Center");
        this.add((Component)parentPanel, "Center");
    }

    private void createUpperBar() {
        JPanel actPanel = new JPanel();
        actPanel.add(new JLabel("Left Revisions Operator:"));
        this.cbOperatorLeft = new JComboBox();
        this.checkIterativeLeft = new JCheckBox("i", true);
        actPanel.add(this.checkIterativeLeft);
        actPanel.add(this.cbOperatorLeft);
        actPanel.add(new JLabel("Right Revisions Operator:"));
        this.cbOperatorRight = new JComboBox();
        this.checkIterativeRight = new JCheckBox("i", true);
        actPanel.add(this.checkIterativeRight);
        actPanel.add(this.cbOperatorRight);
        this.setLayout(new BorderLayout());
        this.add((Component)actPanel, "North");
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("leftOperator")) {
            this.cbOperatorLeft.setSelectedItem(evt.getNewValue());
            this.checkIterativeLeft.setEnabled(evt.getNewValue() instanceof CredibilityRevision);
            String content = this.updateRevision(evt.getNewValue(), this.checkIterativeLeft.isSelected());
            this.txtResultLeft.setText(content);
        } else if (evt.getPropertyName().equals("rightOperator")) {
            this.cbOperatorRight.setSelectedItem(evt.getNewValue());
            this.checkIterativeRight.setEnabled(evt.getNewValue() instanceof CredibilityRevision);
            String content = this.updateRevision(evt.getNewValue(), this.checkIterativeRight.isSelected());
            this.txtResultRight.setText(content);
        } else if (evt.getPropertyName().equals("beliefBases")) {
            IndexedPropertyChangeEvent ipce = (IndexedPropertyChangeEvent)evt;
            Collection n = (Collection)ipce.getNewValue();
            if (ipce.getNewValue() == null) {
                this.lstModel.removeElement(ipce.getOldValue());
            } else if (ipce.getOldValue() == null) {
                this.lstModel.addElement(n);
            } else {
                this.lstModel.set(ipce.getIndex(), n);
            }
            this.beliefbasesUpdated();
            this.updateRevision();
        } else if (evt.getPropertyName() == "selectableOperators") {
            if (evt.getOldValue() == null) {
                BaseRevisionOperator op = (BaseRevisionOperator)evt.getNewValue();
                this.cbOperatorLeft.addItem(op);
                this.cbOperatorRight.addItem(op);
            } else if (evt.getNewValue() == null) {
                BaseRevisionOperator op = (BaseRevisionOperator)evt.getOldValue();
                this.cbOperatorLeft.removeItem(op);
                this.cbOperatorRight.removeItem(op);
            }
        } else if (evt.getPropertyName() == "leftIterative") {
            boolean it = (Boolean)evt.getNewValue();
            this.checkIterativeLeft.setSelected(it);
            if (this.cbOperatorLeft.getSelectedItem() != null) {
                String content = this.updateRevision(this.cbOperatorLeft.getSelectedItem(), it);
                this.txtResultLeft.setText(content);
            }
        } else if (evt.getPropertyName() == "rightIterative") {
            boolean it = (Boolean)evt.getNewValue();
            this.checkIterativeRight.setSelected(it);
            if (this.cbOperatorRight.getSelectedItem() != null) {
                String content = this.updateRevision(this.cbOperatorRight.getSelectedItem(), it);
                this.txtResultRight.setText(content);
            }
        }
    }

    private void beliefbasesUpdated() {
        Object txtRepr = "";
        for (int i = 0; i < this.lstBeliefBases.getModel().getSize(); ++i) {
            Collection<? extends Formula> col = this.lstBeliefBases.getModel().getElementAt(i);
            for (Formula formula : col) {
                txtRepr = (String)txtRepr + formula.toString() + "\n";
            }
            txtRepr = (String)txtRepr + "\n";
        }
        this.txtBeliefBases.setText((String)txtRepr);
        this.sliderStep.setMaximum(this.lstModel.getSize());
    }

    private void updateRevision() {
        String content;
        if (this.cbOperatorLeft.getSelectedItem() != null) {
            content = this.updateRevision(this.cbOperatorLeft.getSelectedItem(), this.checkIterativeLeft.isSelected());
            this.txtResultLeft.setText(content);
        }
        if (this.cbOperatorRight.getSelectedItem() != null) {
            content = this.updateRevision(this.cbOperatorRight.getSelectedItem(), this.checkIterativeRight.isSelected());
            this.txtResultRight.setText(content);
        }
    }

    private String updateRevision(Object op, boolean b) {
        BaseRevisionOperator cop;
        if (this.lstModel.getSize() < 2) {
            return "";
        }
        Map<Object, Object> revisionSteps = new HashMap();
        if (op instanceof CredibilityRevision && !b) {
            cop = (CredibilityRevision)op;
            revisionSteps = this.revision((CredibilityRevision)cop);
        } else if (op instanceof MultipleBaseRevisionOperator) {
            cop = (MultipleBaseRevisionOperator)op;
            revisionSteps = this.revision((MultipleBaseRevisionOperator)cop);
        } else {
            cop = (BaseRevisionOperator)op;
            revisionSteps = this.revision(cop);
        }
        Object reval = "";
        for (Integer n : revisionSteps.keySet()) {
            reval = (String)reval + n + ".\n";
            for (Formula f : (Collection)revisionSteps.get(n)) {
                reval = (String)reval + f.toString() + "\n";
            }
            reval = (String)reval + "\n";
        }
        return reval;
    }

    private <T extends Formula> Map<Integer, Collection<? extends Formula>> revision(CredibilityRevision<T> op) {
        HashMap<Integer, Collection<? extends Formula>> reval = new HashMap<Integer, Collection<? extends Formula>>();
        LinkedList orderedList = new LinkedList();
        for (int i = 0; i < this.lstModel.getSize(); ++i) {
            orderedList.add(new HashSet<Formula>(this.lstModel.get(i)));
        }
        reval.put(1, op.revise(orderedList));
        return reval;
    }

    private <T extends Formula> Map<Integer, Collection<? extends Formula>> revision(MultipleBaseRevisionOperator<T> op) {
        HashMap<Integer, Collection<? extends Formula>> reval = new HashMap<Integer, Collection<? extends Formula>>();
        Collection<? extends Formula> base = new HashSet<Formula>(this.lstModel.get(0));
        for (int i = 1; i < this.lstModel.getSize(); ++i) {
            HashSet<? extends Formula> extension = new HashSet<Formula>(this.lstModel.get(i));
            base = op.revise(base, extension);
            reval.put(i, base);
            base = new HashSet<Formula>(base);
        }
        return reval;
    }

    private <T extends Formula> Map<Integer, Collection<? extends Formula>> revision(BaseRevisionOperator<T> op) {
        HashMap<Integer, Collection<? extends Formula>> reval = new HashMap<Integer, Collection<? extends Formula>>();
        Collection<Object> base = new HashSet<Formula>(this.lstModel.get(0));
        for (int i = 1; i < this.lstModel.getSize(); ++i) {
            HashSet<? extends Formula> extension = new HashSet<Formula>(this.lstModel.get(i));
            for (Formula formula : extension) {
                base = op.revise(base, formula);
            }
            reval.put(i, base);
            base = new HashSet<Formula>(base);
        }
        return reval;
    }
}

