/*
 * Decompiled with CFR 0.152.
 */
package org.tweetyproject.beliefdynamics.kernels;

import java.util.Collection;
import java.util.HashSet;
import org.tweetyproject.beliefdynamics.MultipleBaseContractionOperator;
import org.tweetyproject.beliefdynamics.kernels.IncisionFunction;
import org.tweetyproject.commons.Formula;
import org.tweetyproject.commons.KernelProvider;

public class KernelContractionOperator<T extends Formula>
extends MultipleBaseContractionOperator<T> {
    private IncisionFunction<T> incisionFunction;
    private KernelProvider<T> kernelProvider;

    public KernelContractionOperator(IncisionFunction<T> incisionFunction, KernelProvider<T> kernelProvider) {
        this.incisionFunction = incisionFunction;
        this.kernelProvider = kernelProvider;
    }

    @Override
    public Collection<T> contract(Collection<T> base, Collection<T> formulas) {
        HashSet kernels = new HashSet();
        for (Formula formula : formulas) {
            kernels.addAll(this.kernelProvider.getKernels(base, formula));
        }
        Collection<T> incision = this.incisionFunction.incise(kernels);
        HashSet<T> contractedBase = new HashSet<T>();
        contractedBase.addAll(base);
        contractedBase.removeAll(incision);
        return contractedBase;
    }
}

