/*
 * Decompiled with CFR 0.152.
 */
package org.tweetyproject.beliefdynamics.kernels;

import java.util.Collection;
import java.util.HashSet;
import org.tweetyproject.beliefdynamics.kernels.IncisionFunction;
import org.tweetyproject.commons.Formula;

public class RandomIncisionFunction<T extends Formula>
implements IncisionFunction<T> {
    @Override
    public Collection<T> incise(Collection<Collection<T>> kernelSets) {
        HashSet<Formula> toBeRemoved = new HashSet<Formula>();
        for (Collection<T> kernel : kernelSets) {
            if (kernel.isEmpty()) continue;
            toBeRemoved.add((Formula)kernel.iterator().next());
        }
        boolean didRemove = false;
        block1: do {
            for (Formula formula : toBeRemoved) {
                HashSet newPossibleIncision = new HashSet(toBeRemoved);
                newPossibleIncision.remove(formula);
                if (!this.isIncision(kernelSets, newPossibleIncision)) continue;
                toBeRemoved.remove(formula);
                didRemove = true;
                continue block1;
            }
        } while (didRemove);
        return toBeRemoved;
    }

    private boolean isIncision(Collection<Collection<T>> kernelSets, Collection<T> possibleIncision) {
        for (Collection<T> kernel : kernelSets) {
            if (kernel.isEmpty()) continue;
            HashSet<T> testSet = new HashSet<T>(kernel);
            testSet.retainAll(possibleIncision);
            if (!testSet.isEmpty()) continue;
            return false;
        }
        return true;
    }
}

