/*
 * Decompiled with CFR 0.152.
 */
package org.tweetyproject.beliefdynamics.mas;

import java.util.Collection;
import java.util.HashSet;
import org.tweetyproject.agents.Agent;
import org.tweetyproject.beliefdynamics.mas.InformationObject;
import org.tweetyproject.graphs.orders.Order;
import org.tweetyproject.logics.pl.syntax.PlFormula;

public abstract class AbstractCredibilityComparer {
    private Order<Agent> credOrder;
    private Collection<InformationObject<PlFormula>> formulas;

    public AbstractCredibilityComparer(Collection<InformationObject<PlFormula>> formulas, Order<Agent> credOrder) {
        this.formulas = formulas;
        this.credOrder = credOrder;
    }

    protected boolean isAtLeastAsPreferredAs(Collection<? extends PlFormula> col1, Collection<? extends PlFormula> col2) {
        for (PlFormula plFormula : col1) {
            if (this.isAtLeastAsPreferredAs(plFormula, col2)) continue;
            return false;
        }
        return true;
    }

    protected boolean isAtLeastAsPreferredAs(PlFormula f, Collection<? extends PlFormula> formulas) {
        for (PlFormula plFormula : formulas) {
            if (!this.isAtLeastAsPreferredAs(f, plFormula)) continue;
            return true;
        }
        return false;
    }

    protected boolean isAtLeastAsPreferredAs(PlFormula f, PlFormula f2) {
        HashSet<Agent> agents1 = new HashSet<Agent>();
        for (InformationObject<PlFormula> i : this.formulas) {
            if (!i.getFormula().equals((Object)f)) continue;
            agents1.add(i.getSource());
        }
        HashSet<Agent> agents2 = new HashSet<Agent>();
        for (InformationObject<PlFormula> i : this.formulas) {
            if (!i.getFormula().equals((Object)f2)) continue;
            agents2.add(i.getSource());
        }
        for (Agent a : agents1) {
            boolean mostCredible = true;
            for (Agent b : agents2) {
                if (!this.credOrder.isOrderedBefore((Object)b, (Object)a) || this.credOrder.isOrderedBefore((Object)a, (Object)b)) continue;
                mostCredible = false;
                break;
            }
            if (!mostCredible) continue;
            return true;
        }
        return false;
    }
}

