/*
 * Decompiled with CFR 0.152.
 */
package org.tweetyproject.beliefdynamics.operators;

import java.util.Collection;
import java.util.HashSet;
import org.tweetyproject.agents.Agent;
import org.tweetyproject.beliefdynamics.DefaultMultipleBaseExpansionOperator;
import org.tweetyproject.beliefdynamics.LeviMultipleBaseRevisionOperator;
import org.tweetyproject.beliefdynamics.MultipleBaseRevisionOperator;
import org.tweetyproject.beliefdynamics.mas.AbstractCredibilityComparer;
import org.tweetyproject.beliefdynamics.mas.CrMasBeliefSet;
import org.tweetyproject.beliefdynamics.mas.CrMasRevisionWrapper;
import org.tweetyproject.beliefdynamics.mas.InformationObject;
import org.tweetyproject.beliefdynamics.operators.RandomKernelContractionOperator;
import org.tweetyproject.commons.Formula;
import org.tweetyproject.graphs.orders.Order;
import org.tweetyproject.logics.pl.reasoner.SimplePlReasoner;
import org.tweetyproject.logics.pl.syntax.Negation;
import org.tweetyproject.logics.pl.syntax.PlFormula;

public class CrMasSimpleRevisionOperator
extends MultipleBaseRevisionOperator<InformationObject<PlFormula>> {
    @Override
    public Collection<InformationObject<PlFormula>> revise(Collection<InformationObject<PlFormula>> base, Collection<InformationObject<PlFormula>> formulas) {
        if (!(base instanceof CrMasBeliefSet)) {
            throw new IllegalArgumentException("Argument 'base' has to be of type CrMasBeliefSet.");
        }
        HashSet<InformationObject<PlFormula>> allInformation = new HashSet<InformationObject<PlFormula>>(base);
        allInformation.addAll(formulas);
        CredibilityComparer comparer = new CredibilityComparer(allInformation, ((CrMasBeliefSet)((Object)base)).getCredibilityOrder());
        HashSet<PlFormula> allProps = new HashSet<PlFormula>();
        for (InformationObject informationObject : allInformation) {
            allProps.add((PlFormula)informationObject.getFormula());
        }
        HashSet credFormulas = new HashSet();
        for (InformationObject<PlFormula> informationObject : formulas) {
            SimplePlReasoner kernelProvider = new SimplePlReasoner();
            Collection kernels = kernelProvider.getKernels(allProps, (Formula)new Negation(informationObject.getFormula()));
            boolean formulaIsPlausible = true;
            for (Collection kernel : kernels) {
                if (comparer.isFormerAtLeastAsPreferredAsLatter(informationObject.getFormula(), kernel)) continue;
                formulaIsPlausible = false;
                break;
            }
            if (!formulaIsPlausible) continue;
            credFormulas.add(informationObject);
        }
        CrMasRevisionWrapper<PlFormula> crMasRevisionWrapper = new CrMasRevisionWrapper<PlFormula>(new LeviMultipleBaseRevisionOperator<PlFormula>(new RandomKernelContractionOperator(), new DefaultMultipleBaseExpansionOperator()));
        return crMasRevisionWrapper.revise(base, credFormulas);
    }

    private class CredibilityComparer
    extends AbstractCredibilityComparer {
        public CredibilityComparer(Collection<InformationObject<PlFormula>> formulas, Order<Agent> credOrder) {
            super(formulas, credOrder);
        }

        public boolean isFormerAtLeastAsPreferredAsLatter(PlFormula f, Collection<PlFormula> formulas) {
            return this.isAtLeastAsPreferredAs(f, formulas);
        }
    }
}

