/*
 * Decompiled with CFR 0.152.
 */
package org.tweetyproject.beliefdynamics.selectiverevision.argumentative;

import java.util.Collection;
import java.util.HashSet;
import org.tweetyproject.arg.deductive.accumulator.Accumulator;
import org.tweetyproject.arg.deductive.categorizer.Categorizer;
import org.tweetyproject.arg.deductive.reasoner.CompilationReasoner;
import org.tweetyproject.arg.deductive.syntax.DeductiveKnowledgeBase;
import org.tweetyproject.beliefdynamics.selectiverevision.MultipleTransformationFunction;
import org.tweetyproject.logics.pl.syntax.PlBeliefSet;
import org.tweetyproject.logics.pl.syntax.PlFormula;

public class ArgumentativeTransformationFunction
implements MultipleTransformationFunction<PlFormula> {
    private Categorizer categorizer;
    private Accumulator accumulator;
    private boolean isSkeptical;
    private PlBeliefSet beliefSet;

    public ArgumentativeTransformationFunction(Categorizer categorizer, Accumulator accumulator, PlBeliefSet beliefSet, boolean isSkeptical) {
        this.categorizer = categorizer;
        this.accumulator = accumulator;
        this.beliefSet = beliefSet;
        this.isSkeptical = isSkeptical;
    }

    @Override
    public Collection<PlFormula> transform(Collection<PlFormula> formulas) {
        HashSet<PlFormula> transformedSet = new HashSet<PlFormula>();
        DeductiveKnowledgeBase joinedBeliefSet = new DeductiveKnowledgeBase((Collection)this.beliefSet);
        joinedBeliefSet.addAll(formulas);
        CompilationReasoner reasoner = new CompilationReasoner(this.categorizer, this.accumulator);
        for (PlFormula f : formulas) {
            Double result = reasoner.query(joinedBeliefSet, f);
            if (this.isSkeptical) {
                if (!(result > 0.0)) continue;
                transformedSet.add(f);
                continue;
            }
            if (!(result >= 0.0)) continue;
            transformedSet.add(f);
        }
        return transformedSet;
    }
}

