/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.dsc.tws.tsched.spi.common;

import edu.iu.dsc.tws.api.config.Config;
import edu.iu.dsc.tws.api.config.Context;

public class TaskSchedulerContext
extends Context {
    private static final String TWISTER2_TASK_SCHEDULER_MODE_STREAMING = "twister2.taskscheduler.streaming";
    private static final String TWISTER2_TASK_SCHEDULER_MODE_STREAMING_DEFAULT = "roundrobin";
    private static final String TWISTER2_TASK_SCHEDULER_MODE_BATCH = "twister2.taskscheduler.batch";
    private static final String TWISTER2_TASK_SCHEDULER_MODE_BATCH_DEFAULT = "roundrobin";
    private static final String TWISTER2_TASK_SCHEDULER_CLASS_STREAMING = "twister2.taskscheduler.streaming.class";
    private static final String TWISTER2_TASK_SCHEDULER_CLASS_STREAMING_DEFAULT = "edu.iu.dsc.tws.tsched.streaming.roundrobin.RoundRobinTaskScheduler";
    private static final String TWISTER2_TASK_SCHEDULER_CLASS_BATCH = "twister2.taskscheduler.batch.class";
    private static final String TWISTER2_TASK_SCHEDULER_CLASS_BATCH_DEFAULT = "edu.iu.dsc.tws.tsched.batch.roundrobin.RoundRobinBatchTaskScheduler";
    private static final String TWISTER2_TASK_SCHEDULER_TASK_TYPE = "twister2.taskscheduler.task.type";
    private static final String TWISTER2_TASK_SCHEDULING_TASK_TYPE_DEFAULT = "streaming";
    private static final String TWISTER2_TASK_SCHEDULER_TASK_INSTANCE_RAM = "twister2.taskscheduler.task.instance.ram";
    private static final double TWISTER2_TASK_SCHEDULER_TASK_INSTANCE_RAM_DEFAULT = 512.0;
    private static final String TWISTER2_TASK_SCHEDULER_TASK_INSTANCE_DISK = "twister2.taskscheduler.task.instance.disk";
    private static final double TWISTER2_TASK_SCHEDULER_TASK_INSTANCE_DISK_DEFAULT = 500.0;
    private static final String TWISTER2_TASK_SCHEDULER_TASK_INSTANCE_CPU = "twister2.taskscheduler.task.instance.cpu";
    private static final double TWISTER2_TASK_SCHEDULER_TASK_INSTANCE_CPU_DEFAULT = 2.0;
    private static final String TWISTER2_TASK_SCHEDULER_TASK_INSTANCE_NETWORK = "twister2.taskscheduler.task.instance.network";
    private static final double TWISTER2_TASK_SCHEDULER_TASK_INSTANCE_NETWORK_DEFAULT = 512.0;
    private static final String TWISTER2_TASK_SCHEDULER_CONTAINER_INSTANCE_RAM = "twister2.taskscheduler.container.instance.ram";
    private static final double TWISTER2_TASK_SCHEDULER_CONTAINER_INSTANCE_RAM_DEFAULT = 1024.0;
    private static final String TWISTER2_TASK_SCHEDULER_CONTAINER_INSTANCE_DISK = "twister2.taskscheduler.container.instance.disk";
    private static final double TWISTER2_TASK_SCHEDULER_CONTAINER_INSTANCE_DISK_DEFAULT = 1000.0;
    private static final String TWISTER2_TASK_SCHEDULER_CONTAINER_INSTANCE_CPU = "twister2.taskscheduler.container.instance.cpu";
    private static final double TWISTER2_TASK_SCHEDULER_CONTAINER_INSTANCE_CPU_DEFAULT = 2.0;
    private static final String TWISTER2_TASK_SCHEDULER_CONTAINER_INSTANCE_NETWORK = "twister2.taskscheduler.container.instance.network";
    private static final double TWISTER2_TASK_SCHEDULER_CONTAINER_INSTANCE_NETWORK_DEFAULT = 1024.0;
    private static final String TWISTER2_TASK_SCHEDULER_TASK_PARALLELISM = "twister2.taskscheduler.task.parallelism";
    private static final int TWISTER2_TASK_SCHEDULER_TASK_PARALLELISM_DEFAULT = 2;
    private static final String TWISTER2_TASK_SCHEDULER_NO_OF_INSTANCES_PER_CONTAINER = "twister2.taskscheduler.task.instances";
    private static final int TWISTER2_TASK_SCHEDULER_NO_OF_INSTANCES_PER_CONTAINER_DEFAULT = 2;
    private static final String TWISTER2_TASK_SCHEDULER_RAM_PADDING_PER_CONTAINER = "twister2.taskscheduler.ram.padding.container";
    private static final double TWISTER2_TASK_SCHEDULER_RAM_PADDING_PER_CONTAINER_DEFAULT = 2.0;
    private static final String TWISTER2_TASK_SCHEDULER_DISK_PADDING_PER_CONTAINER = "twister2.taskscheduler.disk.padding.container";
    private static final double TWISTER2_TASK_SCHEDULER_DISK_PADDING_PER_CONTAINER_DEFAULT = 12.0;
    private static final String TWISTER2_TASK_SCHEDULER_CPU_PADDING_PER_CONTAINER = "twister2.taskscheduler.cpu.padding.container";
    private static final double TWISTER2_TASK_SCHEDULER_CPU_PADDING_PER_CONTAINER_DEFAULT = 1.0;
    private static final String TWISTER2_TASK_SCHEDULER_CONTAINER_PADDING_PERCENTAGE = "twister2.taskscheduler.container.padding.percentage";
    private static final int TWISTER2_TASK_SCHEDULER_CONTAINER_PADDING_PERCENTAGE_DEFAULT = 1;
    private static final String TWISTER2_TASK_SCHEDULER_CONTAINER_INSTANCE_BANDWIDTH = "twister2.taskscheduler.container.instance.bandwidth";
    private static final double TWISTER2_TASK_SCHEDULER_CONTAINER_INSTANCE_BANDWIDTH_DEFAULT = 100.0;
    public static final String TWISTER2_TASK_SCHEDULER_CONTAINER_INSTANCE_LATENCY = "twister2.taskscheduler.container.instance.latency";
    private static final double TWISTER2_TASK_SCHEDULER_CONTAINER_INSTANCE_LATENCY_DEFAULT = 0.02;
    private static final String TWISTER2_TASK_SCHEDULER_DATANODE_INSTANCE_BANDWIDTH = "twister2.taskscheduler.datanode.instance.bandwidth";
    private static final double TWISTER2_TASK_SCHEDULER_DATANODE_INSTANCE_BANDWIDTH_DEFAULT = 200.0;
    private static final String TWISTER2_TASK_SCHEDULER_DATANODE_INSTANCE_LATENCY = "twister2.taskscheduler.datanode.instance.latency";
    private static final double TWISTER2_TASK_SCHEDULER_DATANODE_INSTANCE_LATENCY_DEFAULT = 0.01;

    public static String streamingTaskSchedulingMode(Config cfg) {
        return cfg.getStringValue(TWISTER2_TASK_SCHEDULER_MODE_STREAMING, "roundrobin");
    }

    public static String batchTaskSchedulingMode(Config cfg) {
        return cfg.getStringValue(TWISTER2_TASK_SCHEDULER_MODE_BATCH, "roundrobin");
    }

    public static String streamingTaskSchedulingClass(Config cfg) {
        return cfg.getStringValue(TWISTER2_TASK_SCHEDULER_CLASS_STREAMING, TWISTER2_TASK_SCHEDULER_CLASS_STREAMING_DEFAULT);
    }

    public static String batchTaskSchedulingClass(Config cfg) {
        return cfg.getStringValue(TWISTER2_TASK_SCHEDULER_CLASS_BATCH, TWISTER2_TASK_SCHEDULER_CLASS_BATCH_DEFAULT);
    }

    public static String taskType(Config cfg) {
        return cfg.getStringValue(TWISTER2_TASK_SCHEDULER_TASK_TYPE, TWISTER2_TASK_SCHEDULING_TASK_TYPE_DEFAULT);
    }

    public static double taskInstanceRam(Config cfg) {
        return cfg.getDoubleValue(TWISTER2_TASK_SCHEDULER_TASK_INSTANCE_RAM, 512.0);
    }

    public static double taskInstanceDisk(Config cfg) {
        return cfg.getDoubleValue(TWISTER2_TASK_SCHEDULER_TASK_INSTANCE_DISK, 500.0);
    }

    public static double taskInstanceCpu(Config cfg) {
        return cfg.getDoubleValue(TWISTER2_TASK_SCHEDULER_TASK_INSTANCE_CPU, 2.0);
    }

    public static double taskInstanceNetwork(Config cfg) {
        return cfg.getDoubleValue(TWISTER2_TASK_SCHEDULER_TASK_INSTANCE_NETWORK, 512.0);
    }

    public static double containerInstanceRam(Config cfg) {
        return cfg.getDoubleValue(TWISTER2_TASK_SCHEDULER_CONTAINER_INSTANCE_RAM, 1024.0);
    }

    public static double containerInstanceDisk(Config cfg) {
        return cfg.getDoubleValue(TWISTER2_TASK_SCHEDULER_CONTAINER_INSTANCE_DISK, 1000.0);
    }

    public static double containerInstanceCpu(Config cfg) {
        return cfg.getDoubleValue(TWISTER2_TASK_SCHEDULER_CONTAINER_INSTANCE_CPU, 2.0);
    }

    public static double containerInstanceNetwork(Config cfg) {
        return cfg.getDoubleValue(TWISTER2_TASK_SCHEDULER_CONTAINER_INSTANCE_NETWORK, 1024.0);
    }

    public static double containerInstanceBandwidth(Config cfg) {
        return cfg.getDoubleValue(TWISTER2_TASK_SCHEDULER_CONTAINER_INSTANCE_BANDWIDTH, 100.0);
    }

    public static double containerInstanceLatency(Config cfg) {
        return cfg.getDoubleValue(TWISTER2_TASK_SCHEDULER_CONTAINER_INSTANCE_LATENCY, 0.02);
    }

    public static int taskParallelism(Config cfg) {
        return cfg.getIntegerValue(TWISTER2_TASK_SCHEDULER_TASK_PARALLELISM, 2);
    }

    public static int defaultTaskInstancesPerContainer(Config cfg) {
        return cfg.getIntegerValue(TWISTER2_TASK_SCHEDULER_NO_OF_INSTANCES_PER_CONTAINER, 2);
    }

    public static double containerRamPadding(Config cfg) {
        return cfg.getDoubleValue(TWISTER2_TASK_SCHEDULER_RAM_PADDING_PER_CONTAINER, 2.0);
    }

    public static double containerDiskPadding(Config cfg) {
        return cfg.getDoubleValue(TWISTER2_TASK_SCHEDULER_DISK_PADDING_PER_CONTAINER, 12.0);
    }

    public static double containerCpuPadding(Config cfg) {
        return cfg.getDoubleValue(TWISTER2_TASK_SCHEDULER_CPU_PADDING_PER_CONTAINER, 1.0);
    }

    public static int containerPaddingPercentage(Config cfg) {
        return cfg.getIntegerValue(TWISTER2_TASK_SCHEDULER_CONTAINER_PADDING_PERCENTAGE, 1);
    }

    public static double datanodeInstanceBandwidth(Config cfg) {
        return cfg.getDoubleValue(TWISTER2_TASK_SCHEDULER_DATANODE_INSTANCE_BANDWIDTH, 200.0);
    }

    public static double datanodeInstanceLatency(Config cfg) {
        return cfg.getDoubleValue(TWISTER2_TASK_SCHEDULER_DATANODE_INSTANCE_LATENCY, 0.01);
    }
}

