/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.dsc.tws.tsched.utils;

import edu.iu.dsc.tws.api.compute.graph.Vertex;
import edu.iu.dsc.tws.api.config.Config;
import edu.iu.dsc.tws.tsched.spi.common.TaskSchedulerContext;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;

public class TaskAttributes {
    private static final Logger LOG = Logger.getLogger(TaskAttributes.class.getName());

    public int getInstancesPerWorker(Vertex taskVertex, Map<String, String> vertexConstraintsMap) {
        Config config = taskVertex.getConfig();
        int instancesPerWorker = vertexConstraintsMap != null ? (vertexConstraintsMap.containsKey("twister2.max.task.instances.per.worker") ? Integer.valueOf(String.valueOf(vertexConstraintsMap.get("twister2.max.task.instances.per.worker"))) : TaskSchedulerContext.defaultTaskInstancesPerContainer(config)) : TaskSchedulerContext.defaultTaskInstancesPerContainer(config);
        return instancesPerWorker;
    }

    public int getInstancesPerWorker(Map<String, String> graphConstraintsMap) {
        int instancesPerWorker = 0;
        if (graphConstraintsMap.containsKey("twister2.max.task.instances.per.worker")) {
            instancesPerWorker = Integer.valueOf(String.valueOf(graphConstraintsMap.get("twister2.max.task.instances.per.worker")));
        }
        return instancesPerWorker;
    }

    public int getTotalNumberOfInstances(Set<Vertex> iTaskSet) {
        Map<String, Integer> parallelTaskMap = this.getParallelTaskMap(iTaskSet);
        int totalNumberOfInstances = 0;
        for (int instances : parallelTaskMap.values()) {
            totalNumberOfInstances += instances;
        }
        return totalNumberOfInstances;
    }

    public int getTotalNumberOfInstances(Vertex taskVertex) {
        Map<String, Integer> parallelTaskMap = this.getParallelTaskMap(taskVertex);
        int totalNumberOfInstances = 0;
        for (int instances : parallelTaskMap.values()) {
            totalNumberOfInstances += instances;
        }
        return totalNumberOfInstances;
    }

    public int getTotalNumberOfInstances(Set<Vertex> iTaskSet, Map<String, Map<String, String>> nodeConstraintsMap) {
        Map<String, Integer> parallelTaskMap = this.getParallelTaskMap(iTaskSet, nodeConstraintsMap);
        int totalNumberOfInstances = 0;
        for (int instances : parallelTaskMap.values()) {
            totalNumberOfInstances += instances;
        }
        return totalNumberOfInstances;
    }

    public int getTotalNumberOfInstances(Vertex taskVertex, Map<String, Map<String, String>> nodeConstraintsMap) {
        Map<String, Integer> parallelTaskMap = this.getParallelTaskMap(taskVertex, nodeConstraintsMap);
        int totalNumberOfInstances = 0;
        for (int instances : parallelTaskMap.values()) {
            totalNumberOfInstances += instances;
        }
        return totalNumberOfInstances;
    }

    public Map<String, Integer> getParallelTaskMap(Set<Vertex> iTaskSet, Map<String, Map<String, String>> nodeConstraintsMap) {
        LinkedHashMap<String, Integer> parallelTaskMap = new LinkedHashMap<String, Integer>();
        for (Vertex taskVertex : iTaskSet) {
            Map<String, String> vertexMap;
            Config config = taskVertex.getConfig();
            String taskName = taskVertex.getName();
            int parallelTaskCount = !nodeConstraintsMap.get(taskName).isEmpty() ? ((vertexMap = nodeConstraintsMap.get(taskName)).containsKey("twister2.task.instance.odd.parallelism") ? Integer.valueOf(String.valueOf(vertexMap.get("twister2.task.instance.odd.parallelism"))).intValue() : taskVertex.getParallelism()) : (taskVertex.getParallelism() >= 1 ? taskVertex.getParallelism() : TaskSchedulerContext.taskParallelism(config));
            parallelTaskMap.put(taskName, parallelTaskCount);
        }
        return parallelTaskMap;
    }

    public Map<String, Integer> getParallelTaskMap(Vertex taskVertex, Map<String, Map<String, String>> nodeConstraintsMap) {
        LinkedHashMap<String, Integer> parallelTaskMap = new LinkedHashMap<String, Integer>();
        Config config = taskVertex.getConfig();
        String taskName = taskVertex.getName();
        int parallelTaskCount = 0;
        if (nodeConstraintsMap.get(taskName) != null) {
            Map<String, String> vertexConstraintMap = nodeConstraintsMap.get(taskName);
            parallelTaskCount = vertexConstraintMap.containsKey("twister2.task.instance.odd.parallelism") ? Integer.valueOf(String.valueOf(vertexConstraintMap.get("twister2.task.instance.odd.parallelism"))) : TaskSchedulerContext.taskParallelism(config);
        }
        parallelTaskMap.put(taskName, parallelTaskCount);
        return parallelTaskMap;
    }

    public Map<String, Integer> getParallelTaskMap(Set<Vertex> iTaskSet) {
        LinkedHashMap<String, Integer> parallelTaskMap = new LinkedHashMap<String, Integer>();
        for (Vertex taskVertex : iTaskSet) {
            Config config = taskVertex.getConfig();
            String taskName = taskVertex.getName();
            int parallelTaskCount = taskVertex.getParallelism() >= 1 ? taskVertex.getParallelism() : TaskSchedulerContext.taskParallelism(config);
            parallelTaskMap.put(taskName, parallelTaskCount);
        }
        return parallelTaskMap;
    }

    public Map<String, Integer> getParallelTaskMap(Vertex taskVertex) {
        LinkedHashMap<String, Integer> parallelTaskMap = new LinkedHashMap<String, Integer>();
        Config config = taskVertex.getConfig();
        String taskName = taskVertex.getName();
        int parallelTaskCount = taskVertex.getParallelism() >= 1 ? taskVertex.getParallelism() : TaskSchedulerContext.taskParallelism(config);
        parallelTaskMap.put(taskName, parallelTaskCount);
        return parallelTaskMap;
    }

    public Map<String, Double> getTaskRamMap(Set<Vertex> taskVertices) {
        HashMap<String, Double> taskRamMap = new HashMap<String, Double>();
        for (Vertex task : taskVertices) {
            double requiredRam;
            Config config = task.getConfig();
            if (config.get("Ram") != null) {
                Object ram = config.get("Ram");
                requiredRam = ((Integer)ram).intValue();
            } else {
                requiredRam = TaskSchedulerContext.taskInstanceRam(config);
            }
            taskRamMap.put(task.getName(), requiredRam);
        }
        return taskRamMap;
    }

    public Map<String, Double> getTaskDiskMap(Set<Vertex> taskVertices) {
        LinkedHashMap<String, Double> taskDiskMap = new LinkedHashMap<String, Double>();
        for (Vertex task : taskVertices) {
            double requiredDisk;
            Config config = task.getConfig();
            if (config.get("Disk") != null) {
                Object disk = config.get("Disk");
                requiredDisk = ((Integer)disk).intValue();
            } else {
                requiredDisk = TaskSchedulerContext.taskInstanceDisk(config);
            }
            taskDiskMap.put(task.getName(), requiredDisk);
        }
        return taskDiskMap;
    }

    public Map<String, Double> getTaskCPUMap(Set<Vertex> taskVertices) {
        LinkedHashMap<String, Double> taskCPUMap = new LinkedHashMap<String, Double>();
        for (Vertex task : taskVertices) {
            double requiredCpu;
            Config config = task.getConfig();
            if (config.get("Cpu") != null) {
                Object cpu = config.get("Cpu");
                requiredCpu = ((Integer)cpu).intValue();
            } else {
                requiredCpu = TaskSchedulerContext.taskInstanceCpu(config);
            }
            taskCPUMap.put(task.getName(), requiredCpu);
        }
        return taskCPUMap;
    }

    public Map<String, Double> getTaskNetworkMap(Set<Vertex> taskVertices) {
        LinkedHashMap<String, Double> taskNetworkMap = new LinkedHashMap<String, Double>();
        for (Vertex task : taskVertices) {
            double requiredNetwork;
            Config config = task.getConfig();
            if (config.get("Network") != null) {
                Object network = config.get("Network");
                requiredNetwork = ((Integer)network).intValue();
            } else {
                requiredNetwork = TaskSchedulerContext.taskInstanceNetwork(config);
            }
            taskNetworkMap.put(task.getName(), requiredNetwork);
        }
        return taskNetworkMap;
    }
}

