/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.dsc.tws.tsched.utils;

import edu.iu.dsc.tws.api.compute.exceptions.TaskSchedulerException;
import edu.iu.dsc.tws.api.compute.schedule.elements.Resource;
import edu.iu.dsc.tws.api.config.Config;
import edu.iu.dsc.tws.tsched.spi.common.TaskSchedulerContext;
import java.util.Map;

public final class TaskScheduleUtils {
    private Config config;
    private static double minRamPerInstance;

    private TaskScheduleUtils(Config cfg) {
        this.config = cfg;
        minRamPerInstance = TaskSchedulerContext.taskInstanceRam(this.config);
    }

    public static Resource getResourceRequirement(String taskName, Map<String, Double> taskRamMap, Resource defaultInstanceResource, Resource maxContainerResource, int paddingPercentage) {
        double instanceRam = defaultInstanceResource.getRam();
        if (taskRamMap.containsKey(taskName)) {
            instanceRam = taskRamMap.get(taskName);
        }
        TaskScheduleUtils.assertIsValidInstance(defaultInstanceResource.cloneWithRam(instanceRam), maxContainerResource, paddingPercentage);
        return defaultInstanceResource.cloneWithRam(instanceRam);
    }

    private static void assertIsValidInstance(Resource instanceResources, Resource maxContainerResources, int paddingPercentage) throws TaskSchedulerException {
        if (instanceResources.getRam() < minRamPerInstance) {
            throw new TaskSchedulerException(String.format("Instance requires ram %s which is less than the minimum ram per instance of %s", instanceResources.getRam(), minRamPerInstance));
        }
        double instanceRam = Math.round(TaskScheduleUtils.increaseBy(instanceResources.getRam(), paddingPercentage));
        if (instanceRam > maxContainerResources.getRam()) {
            throw new TaskSchedulerException(String.format("This instance requires containers of at least %s ram. The current max container size is %s", instanceRam, maxContainerResources.getRam()));
        }
        double instanceDisk = Math.round(TaskScheduleUtils.increaseBy(instanceResources.getDisk(), paddingPercentage));
        if (instanceDisk > maxContainerResources.getDisk()) {
            throw new TaskSchedulerException(String.format("This instance requires containers of at least %s disk. The current max containersize is %s", instanceDisk, maxContainerResources.getDisk()));
        }
        double instanceCpu = Math.round(TaskScheduleUtils.increaseBy(instanceResources.getCpu(), paddingPercentage));
        if (instanceCpu > maxContainerResources.getCpu()) {
            throw new TaskSchedulerException(String.format("This instance requires containers with at least %s cpu cores. The current max containersize is %s cores", instanceCpu > maxContainerResources.getCpu(), maxContainerResources.getCpu()));
        }
    }

    public static long increaseBy(long value, int paddingPercentage) {
        return value + (long)paddingPercentage * value / 100L;
    }

    public static double increaseBy(double value, int paddingPercentage) {
        return value + (double)paddingPercentage * value / 100.0;
    }
}

