import { Component as CoreComponent } from "../core";
import { Element } from "../core";
/**
 * Base AppFormer.js component. It contains the default life-cycle methods that are common to all components.
 *
 */
export declare abstract class Component extends CoreComponent {
    readonly af_componentId: string;
    af_subscriptions: Map<string, ((event: any) => void)>;
    protected constructor(args: {
        type: string;
        af_componentId: string;
    });
    af_onStartup(): void;
    af_onOpen(): void;
    af_onFocus(): void;
    af_onLostFocus(): void;
    af_onMayClose(): boolean;
    af_onClose(): void;
    af_onShutdown(): void;
    core_componentRoot(children?: any): Element;
    abstract af_componentRoot(children?: any): Element;
}
