/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.commons.cluster.events;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.concurrent.CompletionStage;
import javax.enterprise.event.Event;
import javax.enterprise.event.NotificationOptions;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.EventMetadata;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.util.TypeLiteral;
import org.jboss.errai.common.client.api.annotations.Portable;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.uberfire.commons.cluster.ClusterJMSService;
import org.uberfire.commons.cluster.ClusterService;
import org.uberfire.commons.cluster.events.ClusterEventObserver;
import org.uberfire.commons.cluster.events.ClusterSerializedCDIMessageWrapper;
import org.uberfire.commons.clusterapi.Clustered;

@RunWith(value=MockitoJUnitRunner.class)
public class ClusterEventObserverTest {
    ClusterJMSService clusterService;
    ClusterEventObserver observer;
    @Mock
    private EventSourceMock<Object> eventBus;

    @Before
    public void setup() {
        this.clusterService = (ClusterJMSService)Mockito.mock(ClusterJMSService.class);
        this.observer = this.setupMock();
    }

    @Test
    public void consumeTestOtherSenderNode() {
        this.observer.consumeMessage(this.eventBus, new ClusterSerializedCDIMessageWrapper("wrongNode", "json", "fqcn"));
        ((EventSourceMock)Mockito.verify(this.eventBus)).fire(Mockito.any());
    }

    @Test
    public void consumeTestMyMessages() {
        this.observer.consumeMessage(this.eventBus, new ClusterSerializedCDIMessageWrapper(this.observer.getNodeId(), "json", "fqcn"));
        ((EventSourceMock)Mockito.verify(this.eventBus, (VerificationMode)Mockito.never())).fire(Mockito.any());
    }

    @Test
    public void shouldBroadCastMessagesOnlyOnCluster() {
        Mockito.when((Object)this.clusterService.isAppFormerClustered()).thenReturn((Object)false);
        this.observer.broadcast(new Object());
        ((ClusterJMSService)Mockito.verify((Object)this.clusterService, (VerificationMode)Mockito.never())).broadcast((ClusterService.DestinationType)Mockito.any(), (String)Mockito.any(), (Serializable)Mockito.any());
    }

    @Test
    public void shouldBroadCastMessages() {
        Mockito.when((Object)this.clusterService.isAppFormerClustered()).thenReturn((Object)true);
        this.observer.broadcast((Object)new EventTest());
        ((ClusterJMSService)Mockito.verify((Object)this.clusterService)).broadcast((ClusterService.DestinationType)Mockito.any(), (String)Mockito.any(), (Serializable)Mockito.any());
    }

    @Test
    public void shouldObserveThisEventTest() {
        EventMetadata eventMetadataMock = (EventMetadata)Mockito.mock(EventMetadata.class);
        InjectionPoint injectionPointMock = (InjectionPoint)Mockito.mock(InjectionPoint.class);
        Bean beanMock = (Bean)Mockito.mock(Bean.class);
        Mockito.when((Object)eventMetadataMock.getInjectionPoint()).thenReturn((Object)injectionPointMock);
        Mockito.when((Object)injectionPointMock.getBean()).thenReturn((Object)beanMock);
        Assert.assertFalse((boolean)this.observer.shouldObserveThisEvent(new Object(), null));
        Assert.assertTrue((boolean)this.observer.shouldObserveThisEvent((Object)new EventTest(), null));
        Mockito.when((Object)beanMock.getBeanClass()).thenReturn(Object.class);
        Assert.assertTrue((boolean)this.observer.shouldObserveThisEvent((Object)new EventTest(), eventMetadataMock));
        Mockito.when((Object)beanMock.getBeanClass()).thenReturn(this.observer.getClass());
        Assert.assertFalse((boolean)this.observer.shouldObserveThisEvent((Object)new EventTest(), eventMetadataMock));
        Mockito.when((Object)eventMetadataMock.getInjectionPoint()).thenReturn(null);
        Assert.assertTrue((boolean)this.observer.shouldObserveThisEvent((Object)new EventTest(), eventMetadataMock));
    }

    private ClusterEventObserver setupMock() {
        return new ClusterEventObserver(){

            ClusterJMSService getClusterService() {
                return ClusterEventObserverTest.this.clusterService;
            }

            Object fromJSON(ClusterSerializedCDIMessageWrapper message) {
                return new Object();
            }

            String toJSON(Object event) {
                return "Dora";
            }
        };
    }

    public class EventSourceMock<T>
    implements Event<T> {
        public void fire(T event) {
            throw new UnsupportedOperationException("mocking testing class");
        }

        public <U extends T> CompletionStage<U> fireAsync(U u) {
            return null;
        }

        public <U extends T> CompletionStage<U> fireAsync(U u, NotificationOptions notificationOptions) {
            return null;
        }

        public Event<T> select(Annotation ... qualifiers) {
            throw new UnsupportedOperationException("mocking testing class");
        }

        public <U extends T> Event<U> select(Class<U> subtype, Annotation ... qualifiers) {
            throw new UnsupportedOperationException("mocking testing class");
        }

        public <U extends T> Event<U> select(TypeLiteral<U> subtype, Annotation ... qualifiers) {
            return null;
        }
    }

    @Portable
    @Clustered
    public static class EventTest {
    }
}

