/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client;

import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.safehtml.shared.SafeHtmlBuilder;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.ui.HTML;
import java.util.Collection;
import java.util.Collections;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.jboss.errai.bus.client.api.RemoteCallback;
import org.jboss.errai.ioc.client.api.Caller;
import org.uberfire.backend.plugin.RuntimePluginsService;
import org.uberfire.mvp.PlaceRequest;

@Dependent
public class JSNativePlugin {
    @Inject
    private Caller<RuntimePluginsService> runtimePluginsService;
    private JavaScriptObject obj;
    private Element element = null;
    private static final Collection<String> ROLES = Collections.emptyList();
    private static final Collection<String> TRAITS = Collections.emptyList();

    public void build(JavaScriptObject obj) {
        if (this.obj != null) {
            throw new RuntimeException("Can't build more than once.");
        }
        this.obj = obj;
        this.buildElement();
    }

    public native String getId();

    public Element getElement() {
        return this.element;
    }

    public String getTitle() {
        String title = null;
        if (JSNativePlugin.hasMethod(this.obj, "title")) {
            title = JSNativePlugin.getTitleFunctionResult(this.obj);
        } else if (JSNativePlugin.hasStringProperty(this.obj, "title")) {
            title = JSNativePlugin.getTitle(this.obj);
        }
        if (title == null) {
            title = this.getId();
        }
        return title;
    }

    public String getType() {
        String type = null;
        if (JSNativePlugin.hasMethod(this.obj, "type")) {
            type = JSNativePlugin.getTypeFunctionResult(this.obj);
        } else if (JSNativePlugin.hasStringProperty(this.obj, "type")) {
            type = JSNativePlugin.getType(this.obj);
        }
        if (type == null) {
            type = "";
        }
        return type;
    }

    public void onReveal() {
        if (JSNativePlugin.hasMethod(this.obj, "on_reveal")) {
            JSNativePlugin.executeOnReveal(this.obj);
        }
    }

    public void onClose() {
        if (JSNativePlugin.hasMethod(this.obj, "on_close")) {
            JSNativePlugin.executeOnClose(this.obj);
        }
    }

    public void onFocus() {
        if (JSNativePlugin.hasMethod(this.obj, "on_focus")) {
            JSNativePlugin.executeOnFocus(this.obj);
        }
    }

    public void onLostFocus() {
        if (JSNativePlugin.hasMethod(this.obj, "on_lost_focus")) {
            JSNativePlugin.executeOnLostFocus(this.obj);
        }
    }

    public boolean onMayClose() {
        if (JSNativePlugin.hasMethod(this.obj, "on_may_close")) {
            return JSNativePlugin.executeOnMayClose(this.obj);
        }
        return true;
    }

    public Collection<String> getRoles() {
        return ROLES;
    }

    public Collection<String> getTraits() {
        return TRAITS;
    }

    private void buildElement() {
        String content;
        String contentUrl;
        if (JSNativePlugin.hasMethod(this.obj, "templateUrl")) {
            contentUrl = JSNativePlugin.getTemplateUrlFunctionResult(this.obj);
            content = null;
        } else if (JSNativePlugin.hasMethod(this.obj, "template")) {
            content = JSNativePlugin.getTemplateFunctionResult(this.obj);
            contentUrl = null;
        } else if (JSNativePlugin.hasStringProperty(this.obj, "templateUrl")) {
            contentUrl = JSNativePlugin.getTemplateUrl(this.obj);
            content = null;
        } else if (JSNativePlugin.hasStringProperty(this.obj, "template")) {
            content = JSNativePlugin.getTemplate(this.obj);
            contentUrl = null;
        } else {
            content = null;
            contentUrl = null;
        }
        if (content != null) {
            this.element = new HTML(new SafeHtmlBuilder().appendHtmlConstant(content).toSafeHtml()).getElement();
        } else if (contentUrl != null) {
            ((RuntimePluginsService)this.runtimePluginsService.call((RemoteCallback)new RemoteCallback<String>(){

                public void callback(String content) {
                    JSNativePlugin.this.element = new HTML(new SafeHtmlBuilder().appendHtmlConstant(content).toSafeHtml()).getElement();
                }
            })).getTemplateContent(contentUrl);
        } else {
            this.element = null;
        }
    }

    static boolean hasTemplate(JavaScriptObject obj) {
        if (JSNativePlugin.hasMethod(obj, "template") || JSNativePlugin.hasMethod(obj, "templateUrl")) {
            return true;
        }
        return JSNativePlugin.hasStringProperty(obj, "template") || JSNativePlugin.hasStringProperty(obj, "templateUrl");
    }

    static native boolean hasMethod(JavaScriptObject var0, String var1);

    static native boolean hasStringProperty(JavaScriptObject var0, String var1);

    private static native String getTemplateUrlFunctionResult(JavaScriptObject var0);

    private static native String getTemplateFunctionResult(JavaScriptObject var0);

    private static native String getTitleFunctionResult(JavaScriptObject var0);

    private static native String getTypeFunctionResult(JavaScriptObject var0);

    private static native void executeOnReveal(JavaScriptObject var0);

    private static native void executeOnClose(JavaScriptObject var0);

    private static native void executeOnFocus(JavaScriptObject var0);

    private static native void executeOnLostFocus(JavaScriptObject var0);

    private static native boolean executeOnMayClose(JavaScriptObject var0);

    private static native String getType(JavaScriptObject var0);

    private static native String getTitle(JavaScriptObject var0);

    private static native String getTemplate(JavaScriptObject var0);

    private static native String getTemplateUrl(JavaScriptObject var0);

    public void onStart() {
    }

    public void onStart(PlaceRequest place) {
    }
}

