/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.jboss.errai.bus.client.api.RemoteCallback;
import org.uberfire.client.JSNativePerspective;
import org.uberfire.client.mvp.PerspectiveActivity;
import org.uberfire.mvp.Command;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.workbench.model.PanelDefinition;
import org.uberfire.workbench.model.PartDefinition;
import org.uberfire.workbench.model.PerspectiveDefinition;
import org.uberfire.workbench.model.menu.Menus;
import org.uberfire.workbench.model.toolbar.ToolBar;
import org.uberfire.workbench.services.WorkbenchServices;

public class JSWorkbenchPerspectiveActivity
implements PerspectiveActivity {
    private PlaceRequest place;
    private Command callback;
    private JSNativePerspective nativePerspective;

    public JSWorkbenchPerspectiveActivity(JSNativePerspective nativePerspective) {
        this.nativePerspective = nativePerspective;
    }

    public void launch(PlaceRequest place, Command callback) {
        this.place = place;
        this.callback = callback;
        this.saveState();
    }

    public void onStart() {
        this.nativePerspective.onStart();
    }

    public void onStart(PlaceRequest place) {
        this.nativePerspective.onStart(place);
    }

    public void onClose() {
        this.nativePerspective.onClose();
    }

    public PerspectiveDefinition getPerspective() {
        return this.nativePerspective.buildPerspective();
    }

    public String getIdentifier() {
        return this.nativePerspective.getId();
    }

    public boolean isDefault() {
        return this.nativePerspective.isDefault();
    }

    public Menus getMenus() {
        return null;
    }

    public ToolBar getToolBar() {
        return null;
    }

    public void onReveal() {
        this.nativePerspective.onReveal();
    }

    public String getSignatureId() {
        return this.nativePerspective.getId();
    }

    public Collection<String> getRoles() {
        return this.nativePerspective.getRoles();
    }

    public Collection<String> getTraits() {
        return this.nativePerspective.getTraits();
    }

    private void saveState() {
        this.onClose();
        PerspectiveDefinition perspective = this.nativePerspective.getPanelManager().getPerspective();
        if (perspective == null) {
            this.loadState();
        } else if (perspective.isTransient()) {
            this.nativePerspective.getPlaceManager().closeAllPlaces();
            this.loadState();
        } else {
            ((WorkbenchServices)this.nativePerspective.getWbServices().call((RemoteCallback)new RemoteCallback<Void>(){

                public void callback(Void response) {
                    JSWorkbenchPerspectiveActivity.this.nativePerspective.getPlaceManager().closeAllPlaces();
                    JSWorkbenchPerspectiveActivity.this.loadState();
                }
            })).save(perspective);
        }
    }

    private void loadState() {
        final PerspectiveDefinition perspective = this.getPerspective();
        if (perspective.isTransient()) {
            this.initialisePerspective(perspective);
        } else {
            ((WorkbenchServices)this.nativePerspective.getWbServices().call((RemoteCallback)new RemoteCallback<PerspectiveDefinition>(){

                public void callback(PerspectiveDefinition response) {
                    if (response == null) {
                        JSWorkbenchPerspectiveActivity.this.initialisePerspective(perspective);
                    } else {
                        JSWorkbenchPerspectiveActivity.this.initialisePerspective(response);
                    }
                }
            })).load(perspective.getName());
        }
    }

    private void initialisePerspective(PerspectiveDefinition perspective) {
        this.onStart(this.place);
        this.nativePerspective.getPanelManager().setPerspective(perspective);
        Set parts = this.nativePerspective.getPanelManager().getRoot().getParts();
        for (PartDefinition part : parts) {
            PlaceRequest place = this.clonePlaceAndMergeParameters(part.getPlace());
            part.setPlace(place);
            this.nativePerspective.getPlaceManager().goTo(part, this.nativePerspective.getPanelManager().getRoot());
        }
        this.buildPerspective(this.nativePerspective.getPanelManager().getRoot());
        this.onReveal();
    }

    private void buildPerspective(PanelDefinition panel) {
        for (PanelDefinition child : panel.getChildren()) {
            PanelDefinition target = this.nativePerspective.getPanelManager().addWorkbenchPanel(panel, child, child.getPosition());
            this.addChildren(target);
        }
    }

    private void addChildren(PanelDefinition panel) {
        Set parts = panel.getParts();
        for (PartDefinition part : parts) {
            PlaceRequest place = this.clonePlaceAndMergeParameters(part.getPlace());
            part.setPlace(place);
            this.nativePerspective.getPlaceManager().goTo(part, panel);
        }
        this.buildPerspective(panel);
    }

    private PlaceRequest clonePlaceAndMergeParameters(PlaceRequest _place) {
        PlaceRequest clone = _place.clone();
        for (Map.Entry parameter : this.place.getParameters().entrySet()) {
            clone.addParameter((String)parameter.getKey(), (String)parameter.getValue());
        }
        return clone;
    }
}

