/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.metadata.event;

import org.uberfire.ext.metadata.model.KObject;
import org.uberfire.ext.metadata.model.KObjectKey;

public abstract class IndexEvent {
    private final Kind kind;

    private IndexEvent(Kind kind) {
        this.kind = kind;
    }

    public Kind getKind() {
        return this.kind;
    }

    public static class DeletedEvent
    extends IndexEvent {
        private final KObjectKey deleted;

        public DeletedEvent(KObjectKey deleted) {
            super(Kind.Deleted);
            this.deleted = deleted;
        }

        public KObjectKey getDeleted() {
            return this.deleted;
        }
    }

    public static class RenamedEvent
    extends IndexEvent {
        private final KObjectKey source;
        private final KObject target;

        public RenamedEvent(KObjectKey source, KObject target) {
            super(Kind.Renamed);
            this.source = source;
            this.target = target;
        }

        public KObjectKey getSource() {
            return this.source;
        }

        public KObject getTarget() {
            return this.target;
        }
    }

    public static class NewlyIndexedEvent
    extends IndexEvent {
        private final KObject kObject;

        public NewlyIndexedEvent(KObject kObject) {
            super(Kind.NewlyIndexed);
            this.kObject = kObject;
        }

        public KObject getKObject() {
            return this.kObject;
        }
    }

    public static enum Kind {
        NewlyIndexed,
        Renamed,
        Deleted;

    }
}

