/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.metadata.io;

import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.commons.async.DescriptiveRunnable;
import org.uberfire.commons.async.SimpleAsyncExecutorService;
import org.uberfire.commons.validation.PortablePreconditions;
import org.uberfire.ext.metadata.engine.Indexer;
import org.uberfire.ext.metadata.engine.MetaIndexEngine;
import org.uberfire.ext.metadata.engine.Observer;
import org.uberfire.ext.metadata.io.IndexersFactory;
import org.uberfire.ext.metadata.io.KObjectUtil;
import org.uberfire.ext.metadata.model.KCluster;
import org.uberfire.ext.metadata.model.KObject;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.IOException;
import org.uberfire.java.nio.base.FileSystemId;
import org.uberfire.java.nio.file.FileSystem;
import org.uberfire.java.nio.file.FileVisitResult;
import org.uberfire.java.nio.file.FileVisitor;
import org.uberfire.java.nio.file.Files;
import org.uberfire.java.nio.file.Path;
import org.uberfire.java.nio.file.SimpleFileVisitor;
import org.uberfire.java.nio.file.attribute.BasicFileAttributes;
import org.uberfire.java.nio.file.attribute.FileAttribute;
import org.uberfire.java.nio.file.attribute.FileAttributeView;

public final class BatchIndex {
    private static final Logger LOG = LoggerFactory.getLogger(BatchIndex.class);
    private final MetaIndexEngine indexEngine;
    private final IOService ioService;
    private final Class<? extends FileAttributeView>[] views;
    private final AtomicBoolean indexDisposed = new AtomicBoolean(false);
    private final Observer observer;

    public BatchIndex(MetaIndexEngine indexEngine, IOService ioService, Observer observer, Class<? extends FileAttributeView> ... views) {
        this.indexEngine = (MetaIndexEngine)PortablePreconditions.checkNotNull((String)"indexEngine", (Object)indexEngine);
        this.ioService = (IOService)PortablePreconditions.checkNotNull((String)"ioService", (Object)ioService);
        this.observer = (Observer)PortablePreconditions.checkNotNull((String)"observer", (Object)observer);
        this.views = views;
    }

    public void runAsync(final FileSystem fs) {
        if (fs != null && fs.getRootDirectories().iterator().hasNext()) {
            SimpleAsyncExecutorService.getDefaultInstance().execute((Runnable)new DescriptiveRunnable(){

                public String getDescription() {
                    return "FS BatchIndex [" + ((FileSystemId)fs).id() + "]";
                }

                public void run() {
                    block3: {
                        final AtomicBoolean indexFinished = new AtomicBoolean(false);
                        BatchIndex.this.indexEngine.beforeDispose(new Runnable(){

                            @Override
                            public void run() {
                                BatchIndex.this.indexDisposed.set(true);
                                if (!indexFinished.get()) {
                                    BatchIndex.this.indexEngine.delete(KObjectUtil.toKCluster(fs));
                                }
                            }
                        });
                        try {
                            for (Path root : fs.getRootDirectories()) {
                                BatchIndex.this.run(root);
                            }
                            indexFinished.set(true);
                        }
                        catch (Exception ex) {
                            if (BatchIndex.this.indexDisposed.get()) break block3;
                            LOG.error("FileSystem Index fails. [@" + fs.toString() + "]", (Throwable)ex);
                        }
                    }
                }
            });
        }
    }

    public void runAsync(final Path root) {
        SimpleAsyncExecutorService.getDefaultInstance().execute((Runnable)new DescriptiveRunnable(){

            public String getDescription() {
                return "Path BatchIndex [" + root.toString() + "]";
            }

            public void run() {
                BatchIndex.this.run(root);
            }
        });
    }

    public void run(Path root) {
        this.run(root, null);
    }

    public void run(final Path root, Runnable callback) {
        try {
            if (root == null) {
                return;
            }
            KCluster cluster = KObjectUtil.toKCluster(root.getFileSystem());
            this.indexEngine.startBatch(cluster);
            this.observer.information("Starting indexing of " + root.toUri() + " ...");
            Files.walkFileTree((Path)((Path)PortablePreconditions.checkNotNull((String)"root", (Object)root)), (FileVisitor)new SimpleFileVisitor<Path>(){

                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    if (BatchIndex.this.indexDisposed.get()) {
                        return FileVisitResult.TERMINATE;
                    }
                    try {
                        PortablePreconditions.checkNotNull((String)"file", (Object)file);
                        PortablePreconditions.checkNotNull((String)"attrs", (Object)attrs);
                        if (!file.getFileName().toString().startsWith(".")) {
                            for (Class view : BatchIndex.this.views) {
                                BatchIndex.this.ioService.getFileAttributeView(file, view);
                            }
                            FileAttribute[] allAttrs = BatchIndex.this.ioService.convert(BatchIndex.this.ioService.readAttributes(file));
                            if (BatchIndex.this.indexDisposed.get()) {
                                return FileVisitResult.TERMINATE;
                            }
                            BatchIndex.this.indexEngine.index(KObjectUtil.toKObject(file, allAttrs));
                            for (Indexer indexer : IndexersFactory.getIndexers()) {
                                KObject kObject;
                                if (!indexer.supportsPath(file) || (kObject = indexer.toKObject(file)) == null) continue;
                                if (!BatchIndex.this.indexDisposed.get()) {
                                    BatchIndex.this.indexEngine.index(kObject);
                                    continue;
                                }
                                return FileVisitResult.TERMINATE;
                            }
                        }
                    }
                    catch (Exception ex) {
                        if (BatchIndex.this.indexDisposed.get()) {
                            String msg = "Batch index couldn't finish. [@" + root.toUri().toString() + "]";
                            BatchIndex.this.observer.warning(msg);
                            LOG.warn(msg);
                            return FileVisitResult.TERMINATE;
                        }
                        String msg = "Index fails. [@" + file.toString() + "]";
                        BatchIndex.this.observer.error(msg);
                        LOG.error(msg, (Throwable)ex);
                    }
                    if (BatchIndex.this.indexDisposed.get()) {
                        return FileVisitResult.TERMINATE;
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
            if (!this.indexDisposed.get()) {
                this.indexEngine.commit(cluster);
                this.observer.information("Completed indexing of " + root.toUri());
                if (callback != null) {
                    callback.run();
                }
            } else {
                String msg = "Batch index couldn't finish. [@" + root.toUri().toString() + "]";
                this.observer.warning(msg);
                LOG.warn(msg);
            }
        }
        catch (IllegalStateException ex) {
            if (this.indexDisposed.get()) {
                String msg = "Batch index couldn't finish. [@" + root.toUri().toString() + "]";
                this.observer.warning(msg);
                LOG.warn(msg);
            } else {
                String msg = "Index fails - Index has an invalid state. [@" + root.toUri().toString() + "]";
                this.observer.error(msg);
                LOG.error(msg, (Throwable)ex);
            }
        }
        catch (Exception ex) {
            if (this.indexDisposed.get()) {
                String msg = "Batch index couldn't finish. [@" + root.toUri().toString() + "]";
                this.observer.warning(msg);
                LOG.warn(msg);
            }
            String msg = "Index fails. [@" + root.toUri().toString() + "]";
            this.observer.error(msg);
            LOG.error(msg, (Throwable)ex);
        }
    }

    public void dispose() {
        this.indexEngine.dispose();
    }
}

