/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.java.nio.fs.jgit;

import java.net.URI;
import java.util.Collections;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;
import org.uberfire.java.nio.fs.jgit.AbstractTestInfra;
import org.uberfire.java.nio.fs.jgit.JGitFileSystem;
import org.uberfire.java.nio.fs.jgit.JGitFileSystemImpl;
import org.uberfire.java.nio.fs.jgit.JGitFileSystemProxy;

public class JGitFileSystemProxyTest
extends AbstractTestInfra {
    private int gitDaemonPort;

    @Override
    public Map<String, String> getGitPreferences() {
        Map<String, String> gitPrefs = super.getGitPreferences();
        gitPrefs.put("org.uberfire.nio.git.daemon.enabled", "true");
        this.gitDaemonPort = JGitFileSystemProxyTest.findFreePort();
        gitPrefs.put("org.uberfire.nio.git.daemon.port", String.valueOf(this.gitDaemonPort));
        return gitPrefs;
    }

    @Test
    public void proxyTest() {
        URI originRepo = URI.create("git://encoding-origin-name");
        JGitFileSystem origin = (JGitFileSystem)this.provider.newFileSystem(originRepo, Collections.emptyMap());
        Assert.assertTrue((boolean)(origin instanceof JGitFileSystemProxy));
        JGitFileSystemProxy proxy = (JGitFileSystemProxy)origin;
        JGitFileSystem realJGitFileSystem = proxy.getRealJGitFileSystem();
        Assert.assertTrue((boolean)(realJGitFileSystem instanceof JGitFileSystemImpl));
        Assert.assertTrue((boolean)proxy.equals((Object)realJGitFileSystem));
        Assert.assertTrue((boolean)realJGitFileSystem.equals(proxy));
    }
}

