/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.java.nio.fs.jgit.ws;

import java.util.Arrays;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.uberfire.commons.cluster.ClusterJMSService;
import org.uberfire.commons.cluster.ClusterService;
import org.uberfire.java.nio.file.Path;
import org.uberfire.java.nio.file.WatchEvent;
import org.uberfire.java.nio.file.WatchService;
import org.uberfire.java.nio.fs.jgit.ws.JGitFileSystemWatchServices;
import org.uberfire.java.nio.fs.jgit.ws.JGitFileSystemsEventsManager;
import org.uberfire.java.nio.fs.jgit.ws.cluster.JGitEventsBroadcast;

@RunWith(value=MockitoJUnitRunner.class)
public class JGitFileSystemsEventsManagerTest {
    JGitFileSystemsEventsManager manager;
    JGitEventsBroadcast jGitEventsBroadcastMock = (JGitEventsBroadcast)Mockito.mock(JGitEventsBroadcast.class);

    @Before
    public void setup() {
        this.setupClusterParameters();
        this.manager = new JGitFileSystemsEventsManager(){

            void setupJGitEventsBroadcast() {
                this.jGitEventsBroadcast = JGitFileSystemsEventsManagerTest.this.jGitEventsBroadcastMock;
            }

            JGitFileSystemWatchServices createFSWatchServicesManager() {
                return (JGitFileSystemWatchServices)Mockito.mock(JGitFileSystemWatchServices.class);
            }
        };
    }

    @Test
    public void doNotSetupClusterTest() {
        JGitFileSystemsEventsManager another = new JGitFileSystemsEventsManager(){

            ClusterService createClusterJMSService() {
                return (ClusterService)Mockito.mock(ClusterJMSService.class);
            }
        };
        Assert.assertNull((Object)another.getjGitEventsBroadcast());
    }

    @Test
    public void setupClusterTest() {
        Assert.assertNotNull((Object)this.manager.getjGitEventsBroadcast());
    }

    @Test
    public void createWatchService() {
        this.manager = new JGitFileSystemsEventsManager(){

            void setupJGitEventsBroadcast() {
                this.jGitEventsBroadcast = JGitFileSystemsEventsManagerTest.this.jGitEventsBroadcastMock;
            }
        };
        WatchService fs = this.manager.newWatchService("fs");
        Assert.assertNotNull((Object)fs);
        Assert.assertTrue((boolean)this.manager.getFsWatchServices().containsKey("fs"));
        ((JGitEventsBroadcast)Mockito.verify((Object)this.jGitEventsBroadcastMock)).createWatchServiceJMS("fs");
    }

    @Test
    public void shouldNotPublishEventsForANotWatchedFS() {
        WatchService fsDora = this.manager.newWatchService("fsDora");
        WatchService fsBento = this.manager.newWatchService("fsBento");
        List<WatchEvent> elist = Arrays.asList((WatchEvent)Mockito.mock(WatchEvent.class), (WatchEvent)Mockito.mock(WatchEvent.class));
        this.manager.publishEvents("another", (Path)Mockito.mock(Path.class), elist);
        ((JGitEventsBroadcast)Mockito.verify((Object)this.jGitEventsBroadcastMock, (VerificationMode)Mockito.never())).broadcast((String)Mockito.any(), (Path)Mockito.any(), (List)Mockito.any());
    }

    @Test
    public void publishEventsShouldBeWatched() {
        WatchService fsDoraWS = this.manager.newWatchService("fsDora");
        WatchService fsBento = this.manager.newWatchService("fsBento");
        JGitFileSystemWatchServices fsDoraWServices = (JGitFileSystemWatchServices)this.manager.getFsWatchServices().get("fsDora");
        JGitFileSystemWatchServices fsBentoWServices = (JGitFileSystemWatchServices)this.manager.getFsWatchServices().get("fsBento");
        List<WatchEvent> elist = Arrays.asList((WatchEvent)Mockito.mock(WatchEvent.class), (WatchEvent)Mockito.mock(WatchEvent.class));
        this.manager.publishEvents("fsDora", (Path)Mockito.mock(Path.class), elist);
        ((JGitFileSystemWatchServices)Mockito.verify((Object)fsDoraWServices)).publishEvents((Path)Mockito.any(), (List)Mockito.eq(elist));
        ((JGitEventsBroadcast)Mockito.verify((Object)this.jGitEventsBroadcastMock)).broadcast((String)Mockito.eq((Object)"fsDora"), (Path)Mockito.any(), (List)Mockito.eq(elist));
        ((JGitFileSystemWatchServices)Mockito.verify((Object)fsBentoWServices, (VerificationMode)Mockito.never())).publishEvents((Path)Mockito.any(), (List)Mockito.eq(elist));
    }

    @Test
    public void publishEventsWithoutBroadcast() {
        this.manager.newWatchService("fsDora");
        this.manager.newWatchService("fsBento");
        JGitFileSystemWatchServices fsDoraWServices = (JGitFileSystemWatchServices)this.manager.getFsWatchServices().get("fsDora");
        JGitFileSystemWatchServices fsBentoWServices = (JGitFileSystemWatchServices)this.manager.getFsWatchServices().get("fsBento");
        List<WatchEvent> elist = Arrays.asList((WatchEvent)Mockito.mock(WatchEvent.class), (WatchEvent)Mockito.mock(WatchEvent.class));
        this.manager.publishEvents("fsDora", (Path)Mockito.mock(Path.class), elist, false);
        ((JGitFileSystemWatchServices)Mockito.verify((Object)fsDoraWServices)).publishEvents((Path)Mockito.any(), (List)Mockito.eq(elist));
        ((JGitEventsBroadcast)Mockito.verify((Object)this.jGitEventsBroadcastMock, (VerificationMode)Mockito.never())).broadcast((String)Mockito.eq((Object)"fsDora"), (Path)Mockito.any(), (List)Mockito.eq(elist));
        ((JGitFileSystemWatchServices)Mockito.verify((Object)fsBentoWServices, (VerificationMode)Mockito.never())).publishEvents((Path)Mockito.any(), (List)Mockito.eq(elist));
    }

    @Test
    public void watchServicesEvents() {
        this.manager = new JGitFileSystemsEventsManager(){

            void setupJGitEventsBroadcast() {
                this.jGitEventsBroadcast = JGitFileSystemsEventsManagerTest.this.jGitEventsBroadcastMock;
            }
        };
        WatchService fsDora1 = this.manager.newWatchService("fsDora");
        WatchService fsDora2 = this.manager.newWatchService("fsDora");
        List<WatchEvent> list3events = Arrays.asList((WatchEvent)Mockito.mock(WatchEvent.class), (WatchEvent)Mockito.mock(WatchEvent.class), (WatchEvent)Mockito.mock(WatchEvent.class));
        List<WatchEvent> list2events = Arrays.asList((WatchEvent)Mockito.mock(WatchEvent.class), (WatchEvent)Mockito.mock(WatchEvent.class));
        this.manager.publishEvents("fsDora", (Path)Mockito.mock(Path.class), list3events, false);
        List watchEvents = fsDora1.poll().pollEvents();
        Assert.assertEquals((long)3L, (long)watchEvents.size());
        watchEvents = fsDora2.poll().pollEvents();
        Assert.assertEquals((long)3L, (long)watchEvents.size());
        this.manager.publishEvents("fsDora", (Path)Mockito.mock(Path.class), list3events, false);
        this.manager.publishEvents("fsDora", (Path)Mockito.mock(Path.class), list2events, false);
        watchEvents = fsDora2.poll().pollEvents();
        Assert.assertEquals((long)3L, (long)watchEvents.size());
        watchEvents = fsDora2.poll().pollEvents();
        Assert.assertEquals((long)2L, (long)watchEvents.size());
        watchEvents = fsDora1.poll().pollEvents();
        Assert.assertEquals((long)3L, (long)watchEvents.size());
        watchEvents = fsDora1.poll().pollEvents();
        Assert.assertEquals((long)2L, (long)watchEvents.size());
    }

    @Test
    public void closeTest() {
        this.manager.newWatchService("fsDora");
        this.manager.newWatchService("fsBento");
        JGitFileSystemWatchServices fsDoraWServices = (JGitFileSystemWatchServices)this.manager.getFsWatchServices().get("fsDora");
        JGitFileSystemWatchServices fsBentoWServices = (JGitFileSystemWatchServices)this.manager.getFsWatchServices().get("fsBento");
        this.manager.close("fsDora");
        ((JGitFileSystemWatchServices)Mockito.verify((Object)fsDoraWServices)).close();
        ((JGitFileSystemWatchServices)Mockito.verify((Object)fsBentoWServices, (VerificationMode)Mockito.never())).close();
    }

    private void setupClusterParameters() {
        System.setProperty("appformer-cluster", "true");
        System.setProperty("appformer-default-cluster-configs", "true");
    }
}

