/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.preferences.client.central.form;

import java.util.Map;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.jboss.errai.ui.client.local.api.IsElement;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.uberfire.client.annotations.WorkbenchPartTitle;
import org.uberfire.client.annotations.WorkbenchPartView;
import org.uberfire.client.annotations.WorkbenchScreen;
import org.uberfire.client.mvp.UberElement;
import org.uberfire.ext.preferences.client.event.HierarchyItemFormInitializationEvent;
import org.uberfire.ext.preferences.client.event.PreferencesCentralSaveEvent;
import org.uberfire.ext.preferences.client.event.PreferencesCentralUndoChangesEvent;
import org.uberfire.ext.properties.editor.model.PropertyEditorCategory;
import org.uberfire.ext.properties.editor.model.PropertyEditorChangeEvent;
import org.uberfire.ext.properties.editor.model.PropertyEditorEvent;
import org.uberfire.ext.properties.editor.model.PropertyEditorFieldInfo;
import org.uberfire.ext.properties.editor.model.PropertyEditorType;
import org.uberfire.lifecycle.OnStartup;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.preferences.shared.PropertyFormType;
import org.uberfire.preferences.shared.bean.BasePreferencePortable;
import org.uberfire.preferences.shared.bean.PreferenceHierarchyElement;

@WorkbenchScreen(identifier="org.uberfire.ext.preferences.client.central.form.DefaultPreferenceForm")
public class DefaultPreferenceForm {
    public static final String IDENTIFIER = "org.uberfire.ext.preferences.client.central.form.DefaultPreferenceForm";
    private final View view;
    private TranslationService translationService;
    private String id;
    private String title;
    private BasePreferencePortable<?> preference;
    private PropertyEditorCategory category;
    private PreferenceHierarchyElement<?> hierarchyElement;

    @Inject
    public DefaultPreferenceForm(View view, TranslationService translationService) {
        this.view = view;
        this.translationService = translationService;
    }

    @OnStartup
    public void onStartup(PlaceRequest placeRequest) {
        this.id = placeRequest.getParameter("id", null);
        this.title = placeRequest.getParameter("title", null);
    }

    @WorkbenchPartTitle
    public String getTitle() {
        return this.title;
    }

    @WorkbenchPartView
    public IsElement getView() {
        return this.view;
    }

    public void hierarchyItemFormInitializationEvent(@Observes HierarchyItemFormInitializationEvent event) {
        if (this.preference == null && event.getItemId().equals(this.id)) {
            this.preference = event.getPreference();
            this.hierarchyElement = event.getHierarchyElement();
            this.view.init(this);
        }
    }

    public PropertyEditorEvent generatePropertyEditorEvent() {
        if (this.category == null) {
            this.createPropertiesEditorCategory();
        }
        PropertyEditorEvent event = new PropertyEditorEvent(this.id, this.category);
        return event;
    }

    private void createPropertiesEditorCategory() {
        this.category = new PropertyEditorCategory("Properties");
        this.category.setIdEvent(this.id);
        for (Map.Entry property : this.preference.getPropertiesTypes().entrySet()) {
            String propertyName = (String)property.getKey();
            PropertyEditorType propertyType = this.getPropertyEditorType((PropertyFormType)property.getValue());
            Object propertyValue = this.preference.get(propertyName);
            PropertyEditorFieldInfo fieldInfo = new PropertyEditorFieldInfo(this.translationService.format((String)this.hierarchyElement.getBundleKeyByProperty().get(property.getKey()), new Object[0]), propertyValue != null ? propertyValue.toString() : "", propertyType);
            this.category.withField(fieldInfo.withKey(propertyName));
        }
    }

    public void propertyChanged(@Observes PropertyEditorChangeEvent event) {
        if (event.getProperty().getEventId().equals(this.id)) {
            String propertyName = event.getProperty().getKey();
            PropertyFormType propertyType = this.preference.getPropertyType(propertyName);
            Object newValue = propertyType.fromString(event.getNewValue());
            this.preference.set(propertyName, newValue);
        }
    }

    public void saveEvent(@Observes PreferencesCentralSaveEvent event) {
        this.createPropertiesEditorCategory();
        this.view.init(this);
    }

    public void undoEvent(@Observes PreferencesCentralUndoChangesEvent event) {
        this.category.undo();
        this.view.init(this);
    }

    public BasePreferencePortable<?> getPreference() {
        return this.preference;
    }

    public PropertyEditorType getPropertyEditorType(PropertyFormType propertyFormType) {
        return PropertyEditorType.valueOf((String)propertyFormType.name());
    }

    public static interface View
    extends UberElement<DefaultPreferenceForm>,
    IsElement {
    }
}

