/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.security.impl.authz;

import org.jboss.errai.security.shared.api.identity.User;
import org.uberfire.mvp.Command;
import org.uberfire.security.Resource;
import org.uberfire.security.ResourceAction;
import org.uberfire.security.ResourceType;
import org.uberfire.security.authz.AuthorizationManager;
import org.uberfire.security.authz.ResourceCheck;
import org.uberfire.security.authz.VotingStrategy;

public class ResourceCheckImpl<C extends ResourceCheckImpl>
implements ResourceCheck<C> {
    protected AuthorizationManager authorizationManager;
    protected Resource resource;
    protected ResourceAction resourceAction = ResourceAction.READ;
    protected ResourceType resourceType;
    protected User user;
    protected VotingStrategy votingStrategy;
    protected Boolean result = null;

    public ResourceCheckImpl(AuthorizationManager authorizationManager, Resource resource, User user) {
        this.authorizationManager = authorizationManager;
        this.resource = resource;
        this.user = user;
    }

    public ResourceCheckImpl(AuthorizationManager authorizationManager, ResourceType resourceType, User user) {
        this.authorizationManager = authorizationManager;
        this.resourceType = resourceType;
        this.user = user;
    }

    public ResourceCheckImpl(AuthorizationManager authorizationManager, Resource resource, User user, VotingStrategy votingStrategy) {
        this.authorizationManager = authorizationManager;
        this.resource = resource;
        this.user = user;
        this.votingStrategy = votingStrategy;
    }

    public ResourceCheckImpl(AuthorizationManager authorizationManager, ResourceType resourceType, User user, VotingStrategy votingStrategy) {
        this.authorizationManager = authorizationManager;
        this.resourceType = resourceType;
        this.user = user;
        this.votingStrategy = votingStrategy;
    }

    protected void check(ResourceAction action) {
        this.result = this.votingStrategy == null ? (this.resource == null ? Boolean.valueOf(this.authorizationManager.authorize(this.resourceType, action, this.user)) : Boolean.valueOf(this.authorizationManager.authorize(this.resource, action, this.user))) : (this.resource == null ? Boolean.valueOf(this.authorizationManager.authorize(this.resourceType, action, this.user, this.votingStrategy)) : Boolean.valueOf(this.authorizationManager.authorize(this.resource, action, this.user, this.votingStrategy)));
    }

    @Override
    public C action(ResourceAction action) {
        this.resourceAction = action;
        return (C)this;
    }

    @Override
    public C granted(Command onGranted) {
        if (this.result()) {
            onGranted.execute();
        }
        return (C)this;
    }

    @Override
    public C denied(Command onDenied) {
        if (!this.result()) {
            onDenied.execute();
        }
        return (C)this;
    }

    @Override
    public boolean result() {
        if (this.result == null) {
            this.check(this.resourceAction);
        }
        return this.result;
    }
}

