/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.security.impl.authz;

import org.junit.Assert;
import org.junit.Test;
import org.uberfire.security.authz.Permission;
import org.uberfire.security.impl.authz.DotNamedPermission;

public class PermissionTest {
    @Test
    public void testChildGranted() {
        DotNamedPermission p1 = new DotNamedPermission("resource.read", Boolean.valueOf(true));
        DotNamedPermission p2 = new DotNamedPermission("resource.read.id1", Boolean.valueOf(true));
        Assert.assertTrue((boolean)p1.implies((Permission)p2));
    }

    @Test
    public void testChildAbstain() {
        DotNamedPermission p1 = new DotNamedPermission("resource.read", Boolean.valueOf(true));
        DotNamedPermission p2 = new DotNamedPermission("resource.read.id1");
        Assert.assertTrue((boolean)p1.implies((Permission)p2));
    }

    @Test
    public void testChildDenied() {
        DotNamedPermission p1 = new DotNamedPermission("resource.read", Boolean.valueOf(true));
        DotNamedPermission p2 = new DotNamedPermission("resource.read.id1", Boolean.valueOf(false));
        Assert.assertFalse((boolean)p1.implies((Permission)p2));
    }

    @Test
    public void testEqualsGranted() {
        DotNamedPermission p1 = new DotNamedPermission("resource.read", Boolean.valueOf(true));
        DotNamedPermission p2 = new DotNamedPermission("resource.read", Boolean.valueOf(true));
        Assert.assertTrue((boolean)p1.implies((Permission)p2));
    }

    @Test
    public void testEqualsAbstain() {
        DotNamedPermission p1 = new DotNamedPermission("resource.read", Boolean.valueOf(true));
        DotNamedPermission p2 = new DotNamedPermission("resource.read");
        Assert.assertTrue((boolean)p1.implies((Permission)p2));
    }

    @Test
    public void testEqualsDenied() {
        DotNamedPermission p1 = new DotNamedPermission("resource.read", Boolean.valueOf(true));
        DotNamedPermission p2 = new DotNamedPermission("resource.read", Boolean.valueOf(false));
        Assert.assertFalse((boolean)p1.implies((Permission)p2));
    }

    @Test
    public void testParentDenied() {
        DotNamedPermission p1 = new DotNamedPermission("resource.read", Boolean.valueOf(false));
        DotNamedPermission p2 = new DotNamedPermission("resource.read", Boolean.valueOf(false));
        DotNamedPermission p3 = new DotNamedPermission("resource.read", Boolean.valueOf(true));
        DotNamedPermission p4 = new DotNamedPermission("resource.read");
        Assert.assertTrue((boolean)p1.implies((Permission)p2));
        Assert.assertFalse((boolean)p1.implies((Permission)p3));
        Assert.assertFalse((boolean)p1.implies((Permission)p4));
    }

    @Test
    public void testParentAbstain() {
        DotNamedPermission p1 = new DotNamedPermission("resource.read");
        DotNamedPermission p2 = new DotNamedPermission("resource.read", Boolean.valueOf(false));
        DotNamedPermission p3 = new DotNamedPermission("resource.read", Boolean.valueOf(true));
        DotNamedPermission p4 = new DotNamedPermission("resource.read");
        Assert.assertFalse((boolean)p1.implies((Permission)p2));
        Assert.assertFalse((boolean)p1.implies((Permission)p3));
        Assert.assertTrue((boolean)p1.implies((Permission)p4));
    }

    @Test
    public void testParentGranted() {
        DotNamedPermission p1 = new DotNamedPermission("resource.read", Boolean.valueOf(true));
        DotNamedPermission p2 = new DotNamedPermission("resource.read", Boolean.valueOf(false));
        DotNamedPermission p3 = new DotNamedPermission("resource.read", Boolean.valueOf(true));
        DotNamedPermission p4 = new DotNamedPermission("resource.read");
        Assert.assertFalse((boolean)p1.implies((Permission)p2));
        Assert.assertTrue((boolean)p1.implies((Permission)p3));
        Assert.assertTrue((boolean)p1.implies((Permission)p4));
    }

    @Test
    public void testPrefixNotImply() {
        DotNamedPermission p1 = new DotNamedPermission("resource.read.r", Boolean.valueOf(true));
        DotNamedPermission p2 = new DotNamedPermission("resource.read.r2", Boolean.valueOf(true));
        Assert.assertFalse((boolean)p1.implies((Permission)p2));
    }

    @Test
    public void testEmptyNotImply() {
        DotNamedPermission p1 = new DotNamedPermission("resource.read.", Boolean.valueOf(true));
        DotNamedPermission p2 = new DotNamedPermission("resource.read.r2", Boolean.valueOf(true));
        Assert.assertFalse((boolean)p1.implies((Permission)p2));
    }

    @Test
    public void testLengthNotImply() {
        DotNamedPermission p1 = new DotNamedPermission("resource.read.r1", Boolean.valueOf(true));
        DotNamedPermission p2 = new DotNamedPermission("perspective.read.r2", Boolean.valueOf(true));
        Assert.assertFalse((boolean)p1.implies((Permission)p2));
    }

    @Test
    public void testNull() {
        DotNamedPermission p1 = new DotNamedPermission("resource.read.r1", Boolean.valueOf(true));
        DotNamedPermission p2 = new DotNamedPermission(null, Boolean.valueOf(true));
        Assert.assertFalse((boolean)p1.implies((Permission)p2));
    }

    @Test
    public void testImplyNameWithDots() {
        DotNamedPermission p1 = new DotNamedPermission("resource.read", Boolean.valueOf(true));
        DotNamedPermission p2 = new DotNamedPermission("resource.read.r1.dot", Boolean.valueOf(true));
        Assert.assertTrue((boolean)p1.impliesName((Permission)p2));
    }
}

