/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.security.impl.authz;

import java.util.Collection;
import java.util.Collections;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jboss.errai.security.shared.api.RoleImpl;
import org.jboss.errai.security.shared.api.identity.User;
import org.jboss.errai.security.shared.api.identity.UserImpl;
import org.junit.Assert;
import org.junit.Test;
import org.uberfire.security.authz.AuthorizationResult;
import org.uberfire.security.authz.Permission;
import org.uberfire.security.impl.authz.DefaultAuthzResultCache;
import org.uberfire.security.impl.authz.DotNamedPermission;

public class DefaultAuthzResultCacheTest {
    protected User createUserMock(String ... roles) {
        return new UserImpl("username", (Collection)Stream.of(roles).map(RoleImpl::new).collect(Collectors.toSet()), Collections.emptyList());
    }

    @Test
    public void testInvalidate() {
        User user = this.createUserMock("admin");
        DotNamedPermission viewAll = new DotNamedPermission("resource.read", Boolean.valueOf(true));
        DefaultAuthzResultCache cache = new DefaultAuthzResultCache();
        cache.put(user, (Permission)viewAll, AuthorizationResult.ACCESS_GRANTED);
        Assert.assertEquals((Object)AuthorizationResult.ACCESS_GRANTED, (Object)cache.get(user, (Permission)viewAll));
        cache.invalidate(user);
        Assert.assertNull((Object)cache.get(user, (Permission)viewAll));
    }
}

