/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client.util;

import com.google.gwt.dom.client.Style;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HasWidgets;
import com.google.gwt.user.client.ui.ProvidesResize;
import com.google.gwt.user.client.ui.RequiresResize;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.user.client.ui.Widget;
import org.uberfire.client.workbench.panels.SplitPanel;
import org.uberfire.debug.Debug;
import org.uberfire.plugin.PluginUtil;
import org.uberfire.workbench.model.CompassPosition;
import org.uberfire.workbench.model.PanelDefinition;

public class Layouts {
    public static final int DEFAULT_CHILD_SIZE = 100;

    public static void setToFillParent(Widget w) {
        Element e = w.getElement();
        Style s = e.getStyle();
        s.setPosition(Style.Position.RELATIVE);
        s.setTop(0.0, Style.Unit.PX);
        s.setLeft(0.0, Style.Unit.PX);
        s.setWidth(100.0, Style.Unit.PCT);
        s.setHeight(100.0, Style.Unit.PCT);
        s.setOutlineStyle(Style.OutlineStyle.NONE);
    }

    public static String getContainmentHierarchy(Widget w) {
        return Layouts.getContainmentHierarchy(w, false);
    }

    public static String getContainmentHierarchy(Widget w, boolean setDebugIds) {
        StringBuilder sb = new StringBuilder();
        int depth = 0;
        while (w != null) {
            if (setDebugIds) {
                w.getElement().setId("containment-parent-" + depth);
            }
            sb.append("  " + depth + " - " + Layouts.widgetInfo(w));
            w = w.getParent();
            ++depth;
        }
        return sb.toString();
    }

    private static String widgetInfo(Widget w) {
        String widgetInfo;
        try {
            String id = w.getElement().getId();
            widgetInfo = w.getOffsetWidth() + "x" + w.getOffsetHeight() + " - " + Debug.objectId((Object)w) + (id != null && id.length() > 0 ? " id=" + id : "") + (w instanceof SplitPanel ? " divider at " + ((SplitPanel)w).getFixedWidgetSize() : "") + (w instanceof RequiresResize ? " RequiresResize" : "") + (w instanceof ProvidesResize ? " ProvidesResize" : "") + " position: " + w.getElement().getStyle().getPosition() + "\n";
        }
        catch (Throwable t) {
            widgetInfo = "?x? - " + Debug.objectId((Object)w) + ": " + t.toString() + "\n";
        }
        return widgetInfo;
    }

    public static String getContainedHierarchy(Widget startAt) {
        IndentedLineAccumulator result = new IndentedLineAccumulator();
        Layouts.getContainedHierarchyRecursively(startAt, 0, result);
        return result.toString();
    }

    private static void getContainedHierarchyRecursively(Widget startAt, int depth, IndentedLineAccumulator result) {
        if (startAt == null) {
            result.append(depth, "(null)");
            return;
        }
        result.append(depth, Layouts.widgetInfo(startAt));
        if (startAt instanceof HasWidgets) {
            for (Widget child : (HasWidgets)startAt) {
                Layouts.getContainedHierarchyRecursively(child, depth + 1, result);
            }
        } else if (startAt instanceof Composite) {
            Layouts.getContainedHierarchyRecursively(Layouts.extractWidget((Composite)startAt), depth + 1, result);
        }
    }

    private static native Widget extractWidget(Composite var0);

    public static int widthOrHeight(CompassPosition position, PanelDefinition definition) {
        switch (position) {
            case NORTH: 
            case SOUTH: {
                return Layouts.heightOrDefault(definition);
            }
            case EAST: 
            case WEST: {
                return Layouts.widthOrDefault(definition);
            }
        }
        throw new IllegalArgumentException("Position " + position + " has no horizontal or vertial aspect.");
    }

    public static int heightOrDefault(PanelDefinition def) {
        Integer height = PluginUtil.toInteger((int)def.getHeightAsInt());
        return height == null ? 100 : height;
    }

    public static int widthOrDefault(PanelDefinition def) {
        Integer width = PluginUtil.toInteger((int)def.getWidthAsInt());
        return width == null ? 100 : width;
    }

    public static boolean disableNearestScrollPanel(Widget w) {
        while (w != null) {
            if (w instanceof ScrollPanel) {
                w.getElement().getStyle().clearOverflow();
                w.getElement().getParentElement().getStyle().clearOverflow();
                return true;
            }
            w = w.getParent();
        }
        return false;
    }

    private static class IndentedLineAccumulator {
        final StringBuilder sb = new StringBuilder();

        private IndentedLineAccumulator() {
        }

        private void append(int depth, String s) {
            for (int i = 0; i < depth; ++i) {
                this.sb.append(" ");
            }
            this.sb.append(s);
        }

        public String toString() {
            return this.sb.toString();
        }
    }
}

