/*
 * Decompiled with CFR 0.152.
 */
package org.uimafit.examples.tutorial.ex2;

import org.apache.uima.UIMAException;
import org.apache.uima.analysis_engine.AnalysisEngine;
import org.apache.uima.jcas.JCas;
import org.apache.uima.resource.metadata.TypeSystemDescription;
import org.uimafit.examples.tutorial.ex2.RoomNumberAnnotator;
import org.uimafit.examples.tutorial.type.RoomNumber;
import org.uimafit.factory.AnalysisEngineFactory;
import org.uimafit.factory.JCasFactory;
import org.uimafit.factory.TypeSystemDescriptionFactory;
import org.uimafit.util.JCasUtil;

public class RoomNumberAnnotatorPipeline {
    public static void main(String[] args) throws UIMAException {
        String text = "The meeting was moved from Yorktown 01-144 to Hawthorne 1S-W33.";
        TypeSystemDescription tsd = TypeSystemDescriptionFactory.createTypeSystemDescription((Class[])new Class[]{RoomNumber.class});
        JCas jCas = JCasFactory.createJCas((TypeSystemDescription)tsd);
        jCas.setDocumentText(text);
        AnalysisEngine analysisEngine = AnalysisEngineFactory.createPrimitive(RoomNumberAnnotator.class, (TypeSystemDescription)tsd, (Object[])new Object[]{"Patterns", new String[]{"\\b[0-4]\\d-[0-2]\\d\\d\\b", "\\b[G1-4][NS]-[A-Z]\\d\\d\\b"}, "Locations", new String[]{"Downtown", "Uptown"}});
        analysisEngine.process(jCas);
        for (RoomNumber roomNumber : JCasUtil.iterate((JCas)jCas, RoomNumber.class)) {
            System.out.println(roomNumber.getCoveredText() + "\tbuilding = " + roomNumber.getBuilding());
        }
    }
}

