/*
 * Decompiled with CFR 0.152.
 */
package org.uimafit.examples.tutorial.ex6;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.StringTokenizer;
import org.apache.uima.analysis_engine.AnalysisEngineDescription;
import org.apache.uima.jcas.JCas;
import org.apache.uima.resource.ExternalResourceDescription;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.resource.ResourceSpecifier;
import org.apache.uima.resource.metadata.TypeSystemDescription;
import org.apache.uima.util.InvalidXMLException;
import org.uimafit.component.JCasAnnotator_ImplBase;
import org.uimafit.descriptor.ExternalResource;
import org.uimafit.descriptor.TypeCapability;
import org.uimafit.examples.tutorial.ex6.StringMapResource;
import org.uimafit.examples.tutorial.ex6.StringMapResource_impl;
import org.uimafit.examples.tutorial.type.UimaAcronym;
import org.uimafit.factory.AnalysisEngineFactory;
import org.uimafit.factory.ExternalResourceFactory;
import org.uimafit.factory.TypeSystemDescriptionFactory;

@TypeCapability(outputs={"org.apache.uima.examples.tutorial.UimaAcronym", "org.apache.uima.examples.tutorial.UimaAcronym:expandedForm"})
public class UimaAcronymAnnotator
extends JCasAnnotator_ImplBase {
    static final String RESOURCE_ACRONYM_TABLE = "AcronymTable";
    @ExternalResource(key="AcronymTable")
    private StringMapResource mMap;

    public void process(JCas aJCas) {
        String text = aJCas.getDocumentText();
        int pos = 0;
        StringTokenizer tokenizer = new StringTokenizer(text, " \t\n\r.<.>/?\";:[{]}\\|=+()!", true);
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            String expandedForm = this.mMap.get(token);
            if (expandedForm != null) {
                UimaAcronym annot = new UimaAcronym(aJCas, pos, pos + token.length());
                annot.setExpandedForm(expandedForm);
                annot.addToIndexes();
            }
            pos += token.length();
        }
    }

    public static AnalysisEngineDescription createDescription() throws InvalidXMLException, ResourceInitializationException {
        TypeSystemDescription tsd = TypeSystemDescriptionFactory.createTypeSystemDescription((String[])new String[]{"org.uimafit.examples.tutorial.type.TypeSystem"});
        AnalysisEngineDescription aed = AnalysisEngineFactory.createPrimitiveDescription(UimaAcronymAnnotator.class, (TypeSystemDescription)tsd, (Object[])new Object[0]);
        ExternalResourceDescription erd = ExternalResourceFactory.createExternalResourceDescription((String)"UimaAcronymTableFile", StringMapResource_impl.class, (String)"file:org/uimafit/tutorial/ex6/uimaAcronyms.txt", (Object[])new Object[0]);
        ExternalResourceFactory.bindResource((ResourceSpecifier)aed, (String)RESOURCE_ACRONYM_TABLE, (ExternalResourceDescription)erd);
        return aed;
    }

    public static void main(String[] args) throws Exception {
        File outputDirectory = new File("src/main/resources/org/uimafit/examples/tutorial/ex6/");
        outputDirectory.mkdirs();
        AnalysisEngineDescription aed = UimaAcronymAnnotator.createDescription();
        aed.toXML((OutputStream)new FileOutputStream(new File(outputDirectory, "UimaAcronymAnnotator.xml")));
    }
}

