/*
 * Decompiled with CFR 0.152.
 */
package org.uimafit.examples.tutorial.ex6;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_engine.AnalysisEngineDescription;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.jcas.JCas;
import org.apache.uima.resource.ExternalResourceDescription;
import org.apache.uima.resource.ResourceAccessException;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.resource.ResourceSpecifier;
import org.apache.uima.resource.metadata.TypeSystemDescription;
import org.uimafit.component.JCasAnnotator_ImplBase;
import org.uimafit.descriptor.ExternalResource;
import org.uimafit.descriptor.TypeCapability;
import org.uimafit.examples.tutorial.ex6.StringMapResource;
import org.uimafit.examples.tutorial.ex6.StringMapResource_impl;
import org.uimafit.examples.tutorial.type.Meeting;
import org.uimafit.examples.tutorial.type.UimaMeeting;
import org.uimafit.factory.AggregateBuilder;
import org.uimafit.factory.AnalysisEngineFactory;
import org.uimafit.factory.ExternalResourceFactory;
import org.uimafit.factory.TypeSystemDescriptionFactory;
import org.uimafit.util.JCasUtil;

@TypeCapability(inputs={"org.apache.uima.tutorial.Meeting"}, outputs={"org.apache.uima.tutorial.UimaMeeting"})
public class UimaMeetingAnnotator
extends JCasAnnotator_ImplBase {
    static final String RESOURCE_UIMA_TERM_TABLE = "UimaTermTable";
    @ExternalResource(key="UimaTermTable")
    private StringMapResource mMap;

    public void initialize(UimaContext aContext) throws ResourceInitializationException {
        super.initialize(aContext);
        try {
            this.mMap = (StringMapResource)this.getContext().getResourceObject(RESOURCE_UIMA_TERM_TABLE);
        }
        catch (ResourceAccessException e) {
            throw new ResourceInitializationException((Throwable)e);
        }
    }

    public void process(JCas aJCas) throws AnalysisEngineProcessException {
        String text = aJCas.getDocumentText();
        ArrayList<UimaMeeting> uimaMeetings = new ArrayList<UimaMeeting>();
        block0: for (Meeting meeting : JCasUtil.iterate((JCas)aJCas, Meeting.class)) {
            int begin = meeting.getBegin() - 50;
            int end = meeting.getEnd() + 50;
            if (begin < 0) {
                begin = 0;
            }
            if (end > text.length()) {
                end = text.length();
            }
            String window = text.substring(begin, end);
            StringTokenizer tokenizer = new StringTokenizer(window, " \t\n\r.<.>/?\";:[{]}\\|=+()!");
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                if (this.mMap.get(token) == null) continue;
                UimaMeeting annot = new UimaMeeting(aJCas, meeting.getBegin(), meeting.getEnd());
                annot.setRoom(meeting.getRoom());
                annot.setDate(meeting.getDate());
                annot.setStartTime(meeting.getStartTime());
                annot.setEndTime(meeting.getEndTime());
                uimaMeetings.add(annot);
                continue block0;
            }
        }
        for (UimaMeeting uimaMeeting : uimaMeetings) {
            uimaMeeting.addToIndexes();
        }
    }

    public static void main(String[] args) throws Exception {
        File outputDirectory = new File("src/main/resources/org/uimafit/tutorial/ex6/");
        outputDirectory.mkdirs();
        TypeSystemDescription tsd = TypeSystemDescriptionFactory.createTypeSystemDescription((String[])new String[]{"org.uimafit.tutorial.type.TypeSystem"});
        AnalysisEngineDescription aed = AnalysisEngineFactory.createPrimitiveDescription(UimaMeetingAnnotator.class, (TypeSystemDescription)tsd, (Object[])new Object[0]);
        aed.toXML((OutputStream)new FileOutputStream(new File(outputDirectory, "UimaMeetingAnnotator.xml")));
        AggregateBuilder builder = new AggregateBuilder();
        builder.add(AnalysisEngineFactory.createAnalysisEngineDescription((String)"org.uimafit.tutorial.ex6.UimaAcronymAnnotator", (Object[])new Object[0]), new String[0]);
        builder.add(AnalysisEngineFactory.createAnalysisEngineDescription((String)"org.uimafit.tutorial.ex6.UimaMeetingAnnotator", (Object[])new Object[0]), new String[0]);
        AnalysisEngineDescription aggregate = builder.createAggregateDescription();
        ExternalResourceDescription erd = ExternalResourceFactory.createExternalResourceDescription((String)"UimaAcronymTableFile", StringMapResource_impl.class, (String)"file:org/uimafit/tutorial/ex6/uimaAcronyms.txt", (Object[])new Object[0]);
        ExternalResourceFactory.bindResource((ResourceSpecifier)aggregate, (String)RESOURCE_UIMA_TERM_TABLE, (ExternalResourceDescription)erd);
        aggregate.toXML((OutputStream)new FileOutputStream(new File(outputDirectory, "UimaMeetingDetectorTAE.xml")));
    }
}

