/*
 * Decompiled with CFR 0.152.
 */
package org.ujorm.core;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.NoSuchElementException;
import org.ujorm.core.UjoIterator;
import org.ujorm.orm.OrmUjo;
import org.ujorm.orm.Query;
import org.ujorm.orm.TypeService;
import org.ujorm.orm.metaModel.MetaColumn;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ResultSetIterator<T extends OrmUjo>
extends UjoIterator<T> {
    private final Query query;
    private final ResultSet rs;
    private final TypeService typeService;
    private PreparedStatement statement;
    private final boolean view;
    private long count = -1L;
    private boolean initState = true;
    private boolean cursorReady = false;
    private boolean hasNext = true;

    public ResultSetIterator(Query query) throws IllegalStateException {
        try {
            this.query = query;
            this.statement = query.getStatement();
            this.rs = this.statement.executeQuery();
            this.view = query.getTableModel().isSelectModel();
            this.typeService = query.getSession().getParameters().getTypeService();
        }
        catch (SQLException e) {
            this.close();
            throw new IllegalStateException("ILLEGAL SQL: " + query, e);
        }
    }

    @Override
    public boolean hasNext() throws IllegalStateException {
        if (!this.cursorReady) {
            try {
                this.cursorReady = true;
                this.hasNext = this.rs.next();
                if (!this.hasNext) {
                    this.close();
                }
            }
            catch (SQLException e) {
                throw new IllegalStateException("A hasNext() reading exception", e);
            }
        }
        return this.hasNext;
    }

    @Override
    public void close() {
        if (this.statement != null) {
            try {
                this.statement.close();
                this.statement = null;
            }
            catch (SQLException e) {
                throw new IllegalStateException("Can't close statement: " + this.statement, e);
            }
        }
    }

    @Override
    public T next() throws NoSuchElementException {
        if (!this.hasNext()) {
            throw new NoSuchElementException("Query: " + this.query.toString());
        }
        try {
            this.cursorReady = false;
            OrmUjo row = this.query.getTableModel().createBO();
            int colCount = this.query.getColumns().size();
            for (int i = 0; i < colCount; ++i) {
                MetaColumn column = this.query.getColumn(i);
                Object value = this.view ? this.typeService.getValue(column, this.rs) : this.typeService.getValue(column, this.rs, i + 1);
                column.setValue(row, value);
            }
            row.writeSession(this.query.getSession());
            if (this.initState) {
                this.initState = false;
            }
            return (T)row;
        }
        catch (Throwable e) {
            throw new UnsupportedOperationException("Query: " + this.query, e);
        }
    }

    @Override
    public long count() {
        if (this.count < 0L) {
            this.count = !this.hasNext() && this.initState ? 0L : this.query.getCount();
        }
        return this.count;
    }

    @Override
    public boolean skip(int count) {
        while (count > 0 && this.hasNext()) {
            this.cursorReady = false;
            --count;
        }
        return count == 0;
    }
}

