/*
 * Decompiled with CFR 0.152.
 */
package org.ujorm.orm;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.ujorm.CompositeProperty;
import org.ujorm.Ujo;
import org.ujorm.UjoProperty;
import org.ujorm.criterion.BinaryCriterion;
import org.ujorm.criterion.Criterion;
import org.ujorm.criterion.Operator;
import org.ujorm.criterion.ValueCriterion;
import org.ujorm.orm.OrmHandler;
import org.ujorm.orm.SqlDialect;
import org.ujorm.orm.metaModel.MetaColumn;
import org.ujorm.orm.metaModel.MetaDatabase;
import org.ujorm.orm.metaModel.MetaTable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CriterionDecoder {
    private final OrmHandler handler;
    private final SqlDialect dialect;
    private final Criterion criterion;
    private final List<UjoProperty> orderBy;
    private final StringBuilder sql;
    private final List<ValueCriterion> values;
    private final Set<MetaTable> tables;

    public CriterionDecoder(Criterion e, MetaTable ormTable) {
        this(e, ormTable.getDatabase(), null);
    }

    public CriterionDecoder(Criterion criterion, MetaDatabase database, List<UjoProperty> orderByItems) {
        this.criterion = criterion;
        this.dialect = database.getDialect();
        this.orderBy = orderByItems;
        this.handler = database.getOrmHandler();
        this.sql = new StringBuilder(64);
        this.values = new ArrayList<ValueCriterion>();
        this.tables = new HashSet<MetaTable>();
        if (criterion != null) {
            this.unpack(criterion);
            this.writeRelations();
        }
    }

    protected final void unpack(Criterion c) {
        if (c.isBinary()) {
            this.unpackBinary((BinaryCriterion)c);
        } else {
            try {
                ValueCriterion value = this.dialect.printCriterion((ValueCriterion)c, this.sql);
                if (value != null) {
                    this.values.add(value);
                }
            }
            catch (IOException ex) {
                throw new IllegalStateException(ex);
            }
        }
    }

    private void unpackBinary(BinaryCriterion eb) {
        boolean or = false;
        switch (eb.getOperator()) {
            case OR: {
                or = true;
            }
            case AND: {
                if (or) {
                    this.sql.append(" (");
                }
                this.unpack(eb.getLeftNode());
                this.sql.append(" ");
                this.sql.append(eb.getOperator().name());
                this.sql.append(" ");
                this.unpack(eb.getRightNode());
                if (!or) break;
                this.sql.append(") ");
                break;
            }
            default: {
                String message = "Operator is not supported in the SQL statement: " + eb.getOperator();
                throw new UnsupportedOperationException(message);
            }
        }
    }

    public int getColumnCount() {
        return this.values.size();
    }

    public MetaColumn getColumn(int i) {
        UjoProperty p = this.values.get(i).getLeftNode();
        MetaColumn ormColumn = (MetaColumn)this.handler.findColumnModel(p);
        return ormColumn;
    }

    public Operator getOperator(int i) {
        Operator result = this.values.get(i).getOperator();
        return result;
    }

    public Object getValue(int i) {
        Object result = this.values.get(i).getRightNode();
        return result;
    }

    public Object getValueExtended(int i) {
        ValueCriterion crit = this.values.get(i);
        Object value = crit.getRightNode();
        if (value == null) {
            return value;
        }
        if (crit.isInsensitive()) {
            value = value.toString().toUpperCase();
        }
        switch (crit.getOperator()) {
            case CONTAINS: 
            case CONTAINS_CASE_INSENSITIVE: {
                return "%" + value + "%";
            }
            case STARTS: 
            case STARTS_CASE_INSENSITIVE: {
                return value + "%";
            }
            case ENDS: 
            case ENDS_CASE_INSENSITIVE: {
                return "%" + value;
            }
        }
        return value;
    }

    public Criterion getCriterion() {
        return this.criterion;
    }

    public String getWhere() {
        return this.sql.toString();
    }

    public boolean isEmpty() {
        return this.sql.length() == 0;
    }

    public UjoProperty getBaseProperty() {
        UjoProperty result = null;
        for (ValueCriterion eval : this.values) {
            if (eval.getLeftNode() == null) continue;
            result = eval.getLeftNode();
            break;
        }
        while (result != null && !result.isDirect()) {
            result = ((CompositeProperty)result).getFirstProperty();
        }
        return result;
    }

    protected final void writeRelations() {
        boolean parenthesis;
        UjoProperty[] relations = this.getPropertyRelations();
        boolean bl = parenthesis = this.sql.length() > 0 && relations.length > 0;
        if (parenthesis) {
            this.sql.append(" AND (");
        }
        boolean andOperator = false;
        for (UjoProperty property : relations) {
            try {
                MetaColumn fk1 = (MetaColumn)this.handler.findColumnModel(property);
                List<MetaColumn> pk2 = fk1.getForeignColumns();
                MetaTable tab2 = pk2.get(0).getTable();
                this.tables.add((MetaTable)((Object)MetaColumn.TABLE.of((Ujo)fk1)));
                this.tables.add(tab2);
                for (int i = fk1.getForeignColumns().size() - 1; i >= 0; --i) {
                    if (andOperator) {
                        this.sql.append(" AND ");
                    } else {
                        andOperator = true;
                    }
                    fk1.printForeignColumnFullName(i, this.sql);
                    this.sql.append(" = ");
                    this.dialect.printColumnAlias(pk2.get(i), this.sql);
                }
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
        if (parenthesis) {
            this.sql.append(")");
        }
    }

    protected UjoProperty[] getPropertyRelations() {
        HashSet result = new HashSet();
        ArrayList dirs = new ArrayList();
        for (ValueCriterion value : this.values) {
            UjoProperty p1 = value.getLeftNode();
            Object p2 = value.getRightNode();
            if (!p1.isDirect()) {
                ((CompositeProperty)p1).exportProperties(dirs);
                dirs.remove(dirs.size() - 1);
            }
            if (!(p2 instanceof CompositeProperty)) continue;
            ((CompositeProperty)p2).exportProperties(dirs);
            dirs.remove(dirs.size() - 1);
        }
        if (this.orderBy != null) {
            for (UjoProperty p1 : this.orderBy) {
                if (p1.isDirect()) continue;
                ((CompositeProperty)p1).exportProperties(dirs);
                dirs.remove(dirs.size() - 1);
            }
        }
        result.addAll(dirs);
        return result.toArray(new UjoProperty[result.size()]);
    }

    public MetaTable[] getTables(MetaTable baseTable) {
        this.tables.add(baseTable);
        return this.tables.toArray(new MetaTable[this.tables.size()]);
    }

    public MetaTable[] getTablesSorted(final MetaTable baseTable) {
        MetaTable[] result = this.getTables(baseTable);
        if (result.length > 1 && result[0] != baseTable) {
            Arrays.sort(result, new Comparator<MetaTable>(){

                @Override
                public int compare(MetaTable o1, MetaTable o2) {
                    return o1 == baseTable ? -1 : (o2 == baseTable ? 1 : 0);
                }
            });
        }
        return result;
    }

    public OrmHandler getHandler() {
        return this.handler;
    }

    public String toString() {
        return this.criterion != null ? this.criterion.toString() : null;
    }
}

