/*
 * Decompiled with CFR 0.152.
 */
package org.ujorm.orm;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.ujorm.Ujo;
import org.ujorm.UjoAction;
import org.ujorm.UjoProperty;
import org.ujorm.core.UjoManager;
import org.ujorm.orm.CriterionDecoder;
import org.ujorm.orm.DbProcedure;
import org.ujorm.orm.DbType;
import org.ujorm.orm.OrmHandler;
import org.ujorm.orm.OrmUjo;
import org.ujorm.orm.TypeService;
import org.ujorm.orm.metaModel.MetaColumn;
import org.ujorm.orm.metaModel.MetaProcedure;
import org.ujorm.orm.metaModel.MetaTable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JdbcStatement {
    private static final Logger LOGGER = Logger.getLogger(JdbcStatement.class.getName());
    private final PreparedStatement ps;
    private final TypeService typeService;
    private int parameterPointer = 0;
    private StringBuilder values;
    private boolean logValues;

    public JdbcStatement(Connection conn, CharSequence sql, OrmHandler handler) throws SQLException {
        this(conn.prepareStatement(((Object)sql).toString()), handler);
    }

    public JdbcStatement(PreparedStatement ps, OrmHandler handler) {
        this.ps = ps;
        this.typeService = handler.getParameters().getTypeService();
        this.logValues = LOGGER.isLoggable(Level.INFO);
        if (this.logValues) {
            this.values = new StringBuilder();
        }
    }

    public String getAssignedValues() {
        if (this.values != null && this.values.length() > 0) {
            return this.values.toString() + "]";
        }
        return "NONE";
    }

    public void close() throws SQLException {
        this.ps.close();
    }

    public void execute() throws SQLException {
        this.ps.execute();
    }

    public int executeUpdate() throws SQLException {
        return this.ps.executeUpdate();
    }

    public ResultSet executeQuery() throws SQLException {
        return this.ps.executeQuery();
    }

    public void assignValues(OrmUjo bo) throws SQLException {
        MetaTable dbTable = bo.readSession().getHandler().findTableModel(bo.getClass());
        List columns = MetaTable.COLUMNS.getList((Ujo)dbTable);
        this.assignValues(bo, columns);
    }

    public void assignValues(List<? extends OrmUjo> bos, int idxFrom, int idxTo) throws SQLException {
        OrmUjo bo = bos.get(idxFrom);
        MetaTable dbTable = bo.readSession().getHandler().findTableModel(bo.getClass());
        List columns = MetaTable.COLUMNS.getList((Ujo)dbTable);
        for (int i = idxFrom; i < idxTo; ++i) {
            this.assignValues(bos.get(i), columns);
        }
    }

    public void assignValues(OrmUjo table, List<MetaColumn> columns) throws SQLException {
        for (MetaColumn column : columns) {
            if (column.isForeignKey()) {
                UjoProperty property = column.getProperty();
                Object value = table != null ? property.of((Ujo)table) : null;
                this.assignValues((OrmUjo)value, column.getForeignColumns());
                continue;
            }
            if (!column.isColumn()) continue;
            this.assignValue(table, column);
        }
    }

    public void assignValues(CriterionDecoder decoder) throws SQLException {
        int columnCount = decoder.getColumnCount();
        for (int i = 0; i < columnCount; ++i) {
            MetaColumn column = decoder.getColumn(i);
            Object value = decoder.getValueExtended(i);
            if (column.isForeignKey()) {
                List<MetaColumn> fc = column.getForeignColumns();
                if (value instanceof OrmUjo[]) {
                    OrmUjo[] ujoValues = (OrmUjo[])value;
                    Object[] rValues = new Object[ujoValues.length];
                    MetaColumn rColumn = fc.get(0);
                    for (int j = 0; j < ujoValues.length; ++j) {
                        Object rValue;
                        OrmUjo bo = ujoValues[j];
                        rValues[j] = rValue = rColumn.getValue(bo);
                    }
                    this.assignValue(rColumn, rValues, null);
                    continue;
                }
                OrmUjo bo = (OrmUjo)value;
                for (MetaColumn rColumn : fc) {
                    Object rValue = rColumn.getValue(bo);
                    this.assignValue(rColumn, rValue, bo);
                }
                continue;
            }
            this.assignValue(column, value, null);
        }
    }

    public void assignValue(OrmUjo table, MetaColumn column) throws SQLException {
        UjoProperty property = column.getProperty();
        Object value = table != null ? property.of((Ujo)table) : null;
        this.assignValue(column, value, table);
    }

    public void assignValue(MetaColumn column, Object value, OrmUjo bo) throws SQLException {
        UjoProperty property = column.getProperty();
        if (bo != null) {
            this.logValue(bo, property);
        } else if (this.logValues) {
            String textValue = UjoManager.getInstance().encodeValue(value, false);
            this.logValue(textValue, property);
        }
        try {
            if (value instanceof Object[]) {
                for (Object v : (Object[])value) {
                    ++this.parameterPointer;
                    this.typeService.setValue(column, this.ps, v, this.parameterPointer);
                }
            } else {
                ++this.parameterPointer;
                this.typeService.setValue(column, this.ps, value, this.parameterPointer);
            }
        }
        catch (Throwable e) {
            String textValue = bo != null ? UjoManager.getInstance().getText((Ujo)bo, property, UjoAction.DUMMY) : UjoManager.getInstance().encodeValue(value, false);
            String msg = String.format("table: %s, column %s, columnOffset: %d, value: %s", new Object[]{bo != null ? bo.getClass().getSimpleName() : "null", column, this.parameterPointer, textValue});
            throw new IllegalStateException(msg, e);
        }
    }

    public void assignValues(DbProcedure bo) {
        CallableStatement ps = (CallableStatement)this.ps;
        MetaProcedure procedure = bo.metaProcedure();
        Object value = null;
        for (MetaColumn metaParam : MetaProcedure.PARAMETERS.getList((Ujo)procedure)) {
            String textValue;
            UjoProperty property = metaParam.getProperty();
            if (property.isTypeOf(Void.class)) continue;
            try {
                ++this.parameterPointer;
                int sqlType = ((DbType)((Object)MetaColumn.DB_TYPE.of((Ujo)metaParam))).getSqlType();
                if (procedure.isInput(metaParam)) {
                    value = property.of((Ujo)bo);
                    this.typeService.setValue(metaParam, ps, value, this.parameterPointer);
                    if (this.logValues) {
                        textValue = UjoManager.getInstance().encodeValue(value, false);
                        this.logValue(textValue, property);
                    }
                }
                if (!procedure.isOutput(metaParam)) continue;
                ps.registerOutParameter(this.parameterPointer, sqlType);
            }
            catch (Throwable e) {
                textValue = bo != null ? UjoManager.getInstance().getText((Ujo)bo, property, UjoAction.DUMMY) : UjoManager.getInstance().encodeValue(value, false);
                String msg = String.format("table: %s, column %s, columnOffset: %d, value: %s", bo != null ? ((Object)((Object)bo)).getClass().getSimpleName() : "null", property, this.parameterPointer, textValue);
                throw new IllegalStateException(msg, e);
            }
        }
    }

    public void loadValues(DbProcedure bo) {
        CallableStatement ps = (CallableStatement)this.ps;
        MetaProcedure procedure = bo.metaProcedure();
        int i = 0;
        try {
            for (MetaColumn c : MetaProcedure.PARAMETERS.getList((Ujo)procedure)) {
                if (procedure.isOutput(c)) {
                    Object value = this.typeService.getValue(c, ps, ++i);
                    c.setValue((Ujo)bo, value);
                    continue;
                }
                if (!procedure.isInput(c)) continue;
                ++i;
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("Procedure: " + (Object)((Object)bo), e);
        }
    }

    protected void logValue(Ujo bo, UjoProperty property) {
        if (this.logValues) {
            String textValue = UjoManager.getInstance().getText(bo, property, UjoAction.DUMMY);
            this.logValue(textValue, property);
        }
    }

    protected void logValue(String textValue, UjoProperty property) {
        if (this.logValues) {
            String textSeparator = property.isTypeOf(CharSequence.class) ? "\"" : "";
            this.values.append(this.parameterPointer == 0 ? "[" : ", ");
            this.values.append(textSeparator);
            this.values.append(textValue);
            this.values.append(textSeparator);
        }
    }

    PreparedStatement getPreparedStatement() {
        return this.ps;
    }

    public String toString() {
        if (this.ps != null) {
            return this.ps.toString();
        }
        return super.toString();
    }
}

