/*
 * Decompiled with CFR 0.152.
 */
package org.ujorm.orm;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.ujorm.CompositeProperty;
import org.ujorm.Ujo;
import org.ujorm.UjoProperty;
import org.ujorm.core.UjoManager;
import org.ujorm.core.UjoManagerXML;
import org.ujorm.orm.DbProcedure;
import org.ujorm.orm.OrmUjo;
import org.ujorm.orm.Session;
import org.ujorm.orm.ao.Orm2ddlPolicy;
import org.ujorm.orm.metaModel.MetaColumn;
import org.ujorm.orm.metaModel.MetaDatabase;
import org.ujorm.orm.metaModel.MetaParams;
import org.ujorm.orm.metaModel.MetaProcedure;
import org.ujorm.orm.metaModel.MetaRelation2Many;
import org.ujorm.orm.metaModel.MetaRoot;
import org.ujorm.orm.metaModel.MetaTable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OrmHandler {
    private static final Logger LOGGER = Logger.getLogger(OrmHandler.class.getName());
    private static OrmHandler handler = new OrmHandler();
    private MetaRoot databases = new MetaRoot();
    private MetaRoot configuration;
    private Session session;
    private final HashMap<UjoProperty, MetaRelation2Many> propertyMap = new HashMap();
    private final HashMap<Class, MetaTable> entityMap = new HashMap();
    private final HashMap<Class, MetaProcedure> procedureMap = new HashMap();

    public OrmHandler() {
    }

    public <UJO extends OrmUjo> OrmHandler(Class<UJO> databaseModel) {
        this();
        this.loadDatabase(databaseModel);
    }

    public <UJO extends OrmUjo> OrmHandler(Class<UJO> ... databaseModels) {
        this();
        this.loadDatabase(databaseModels);
    }

    public static OrmHandler getInstance() {
        return handler;
    }

    public Session getSession() {
        if (this.session == null) {
            this.session = this.createSession();
        }
        return this.session;
    }

    public Session createSession() {
        return new Session(this);
    }

    public boolean config(String url) throws IllegalArgumentException {
        try {
            if (url.startsWith("~")) {
                String file = System.getProperty("user.home") + url.substring(1);
                return this.config(new File(file).toURI().toURL(), true);
            }
            return this.config(new URL(url), true);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Configuration file is not valid " + url, e);
        }
    }

    public void config(MetaParams params) throws IllegalArgumentException {
        MetaRoot.PARAMETERS.setValue((Ujo)this.databases, (Object)params);
    }

    public void config(MetaRoot config) throws IllegalArgumentException {
        this.configuration = config;
        MetaParams params = (MetaParams)((Object)MetaRoot.PARAMETERS.of((Ujo)this.configuration));
        if (params != null) {
            this.config(params);
        }
    }

    public boolean config(URL url, boolean throwsException) throws IllegalArgumentException {
        try {
            MetaRoot conf = (MetaRoot)UjoManagerXML.getInstance().parseXML((InputStream)new BufferedInputStream(url.openStream()), MetaRoot.class, (Object)this);
            this.config(conf);
            return true;
        }
        catch (Exception e) {
            if (throwsException) {
                throw new IllegalArgumentException("Configuration file is not valid ", e);
            }
            return false;
        }
    }

    public boolean isPersistent(UjoProperty property) {
        boolean resultFalse = property.isTypeOf(List.class) || UjoManager.getInstance().isTransientProperty(property);
        return !resultFalse;
    }

    private <UJO extends OrmUjo> MetaDatabase loadDatabaseInternal(Class<UJO> databaseModel) {
        String databaseId = databaseModel.getSimpleName();
        MetaDatabase paramDb = this.configuration != null ? this.configuration.removeDb(databaseId) : null;
        UJO root = this.getInstance(databaseModel);
        MetaDatabase dbModel = new MetaDatabase(this, (OrmUjo)root, paramDb, this.databases.getDatabaseCount());
        this.databases.add(dbModel);
        if (LOGGER.isLoggable(Level.INFO)) {
            LOGGER.info("DATABASE META-MODEL:\n" + this.getConfig());
        }
        return dbModel;
    }

    public final <UJO extends OrmUjo> void loadDatabase(Class<UJO> databaseModel) {
        this.loadDatabase(new Class[]{databaseModel});
    }

    public synchronized <UJO extends OrmUjo> void loadDatabase(Class<UJO> ... databaseModel) {
        File outConfigFile;
        if (this.isReadOnly()) {
            throw new IllegalArgumentException("The meta-model is locked and can\u00b4t be changed.");
        }
        for (Class<UJO> db : databaseModel) {
            this.loadDatabaseInternal(db);
        }
        MetaParams params = this.getParameters();
        for (MetaRelation2Many r : this.propertyMap.values()) {
            if (!r.isColumn()) continue;
            ((MetaColumn)r).initTypeCode(params);
        }
        this.databases.setReadOnly(true);
        if (LOGGER.isLoggable(Level.INFO)) {
            String msg = "DATABASE META-MODEL:\n" + this.getConfig();
            LOGGER.info(msg);
        }
        if ((outConfigFile = (File)MetaParams.SAVE_CONFIG_TO_FILE.of((Ujo)this.getParameters())) != null) {
            try {
                this.databases.print(outConfigFile);
            }
            catch (IOException e) {
                throw new IllegalStateException("Can't create configuration " + outConfigFile, e);
            }
        }
        for (MetaDatabase dbModel : this.getDatabases()) {
            switch ((Orm2ddlPolicy)((Object)MetaDatabase.ORM2DLL_POLICY.of((Ujo)dbModel))) {
                case CREATE_DDL: 
                case CREATE_OR_UPDATE_DDL: 
                case VALIDATE: {
                    dbModel.create(this.getSession());
                }
            }
        }
    }

    private <UJO extends OrmUjo> UJO getInstance(Class<UJO> databaseModel) {
        try {
            return (UJO)((OrmUjo)databaseModel.newInstance());
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Can't create instance of " + databaseModel, e);
        }
    }

    public boolean isReadOnly() {
        List<MetaDatabase> dbs = this.getDatabases();
        boolean result = dbs == null || dbs.isEmpty() ? false : dbs.get(0).readOnly();
        return result;
    }

    public void addProcedureModel(MetaProcedure metaProcedure) {
        this.procedureMap.put(((UjoProperty)MetaProcedure.DB_PROPERTY.of((Ujo)metaProcedure)).getType(), metaProcedure);
    }

    public void addTableModel(MetaTable metaTable) {
        this.entityMap.put(metaTable.getType(), metaTable);
    }

    public void addColumnModel(MetaRelation2Many column) {
        UjoProperty property = column.getProperty();
        MetaRelation2Many oldColumn = this.findColumnModel(property);
        if (oldColumn == null) {
            this.propertyMap.put(property, column);
        } else {
            Class<OrmUjo> oldType = oldColumn.getTableClass();
            Class<OrmUjo> newType = column.getTableClass();
            if (newType.isAssignableFrom(oldType)) {
                this.propertyMap.put(property, column);
            }
        }
    }

    public <T extends Annotation> T findAnnotation(UjoProperty property, Class<T> annotationClass) {
        if (!property.isDirect()) {
            property = ((CompositeProperty)property).getFirstProperty();
        }
        try {
            for (Field field : this.findColumnModel(property).getTableClass().getFields()) {
                if (field.getModifiers() != 25 || field.get(null) != property) continue;
                return field.getAnnotation(annotationClass);
            }
        }
        catch (Throwable e) {
            throw new IllegalStateException("Illegal state for: " + property, e);
        }
        return null;
    }

    public MetaRelation2Many findColumnModel(UjoProperty pathProperty) {
        if (pathProperty != null && !pathProperty.isDirect()) {
            pathProperty = ((CompositeProperty)pathProperty).getLastProperty();
        }
        MetaRelation2Many result = this.propertyMap.get(pathProperty);
        return result;
    }

    public MetaTable findTableModel(Class<? extends OrmUjo> dbClass) throws IllegalStateException {
        MetaTable result = this.entityMap.get(dbClass);
        if (result == null) {
            String msg = "An entity mapping bug: the " + dbClass + " is not mapped to the Database.";
            throw new IllegalStateException(msg);
        }
        return result;
    }

    public MetaProcedure findProcedureModel(Class<? extends DbProcedure> procedureClass) throws IllegalStateException {
        MetaProcedure result = this.procedureMap.get(procedureClass);
        if (result == null) {
            String msg = "An procedure mapping bug: the " + procedureClass + " is not mapped to the Database.";
            throw new IllegalStateException(msg);
        }
        return result;
    }

    public MetaParams getParameters() {
        return (MetaParams)((Object)MetaRoot.PARAMETERS.of((Ujo)this.databases));
    }

    public boolean isDatabaseLoaded() {
        int itemCount = MetaRoot.DATABASES.getItemCount((Ujo)this.databases);
        return itemCount > 0;
    }

    public List<MetaDatabase> getDatabases() {
        return (List)MetaRoot.DATABASES.of((Ujo)this.databases);
    }

    public List<UjoProperty> findPropertiesByType(Class type) {
        ArrayList<UjoProperty> result = new ArrayList<UjoProperty>();
        for (UjoProperty p : this.propertyMap.keySet()) {
            if (!p.isTypeOf(type)) continue;
            result.add(p);
        }
        return result;
    }

    public String getConfig() {
        return this.databases.toString();
    }
}

