/*
 * Decompiled with CFR 0.152.
 */
package org.ujorm.orm;

import java.sql.PreparedStatement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.ujorm.CompositeProperty;
import org.ujorm.Ujo;
import org.ujorm.UjoProperty;
import org.ujorm.core.UjoIterator;
import org.ujorm.criterion.Criterion;
import org.ujorm.orm.CriterionDecoder;
import org.ujorm.orm.OrmHandler;
import org.ujorm.orm.OrmUjo;
import org.ujorm.orm.Session;
import org.ujorm.orm.metaModel.MetaColumn;
import org.ujorm.orm.metaModel.MetaRelation2Many;
import org.ujorm.orm.metaModel.MetaTable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Query<UJO extends OrmUjo>
implements Iterable<UJO> {
    private final MetaTable table;
    private List<MetaColumn> columns;
    private Session session;
    private Criterion<UJO> criterion;
    private boolean distinct;
    private CriterionDecoder decoder;
    private String statementInfo;
    private List<UjoProperty<UJO, ?>> orderBy;
    private int offset = 0;
    private int limit = -1;
    private int fetchSize = -1;
    private boolean lockRequest;

    public Query(MetaTable table, Criterion<UJO> criterion, Session session) {
        this.table = table;
        this.columns = MetaTable.COLUMNS.getList((Ujo)table);
        this.criterion = criterion;
        this.session = session;
        this.orderByMany(new UjoProperty[0]);
    }

    public Query(MetaTable table, Criterion<UJO> criterion) {
        this(table, criterion, null);
    }

    private OrmHandler getHandler() {
        OrmHandler handler = null;
        if (this.table != null) {
            handler = this.table.getDatabase().getOrmHandler();
        } else if (this.session != null) {
            handler = this.session.getHandler();
        }
        if (handler == null) {
            throw new IllegalStateException("The base class must be assigned first!");
        }
        return handler;
    }

    public Query<UJO> setSession(Session session) {
        this.session = session;
        return this;
    }

    public long getLimitedCount() {
        long result = this.getCount();
        if (this.isOffset() && (result -= (long)this.offset) < 0L) {
            result = 0L;
        }
        if (this.limit >= 0 && (long)this.limit < result) {
            result = this.limit;
        }
        return result;
    }

    public long getCount() {
        long result = this.session.getRowCount(this);
        return result;
    }

    public <ITEM> void setParameter(UjoProperty<UJO, ITEM> property, ITEM value) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public void addCriterion(Criterion<UJO> criterion) throws IllegalArgumentException {
        if (criterion == null) {
            throw new IllegalArgumentException("Argument must not be null");
        }
        this.criterion = this.criterion != null ? this.criterion.and(criterion) : criterion;
        this.clearDecoder();
    }

    public Query<UJO> setCriterion(Criterion<UJO> criterion) {
        this.criterion = criterion;
        this.clearDecoder();
        return this;
    }

    public Criterion<UJO> getCriterion() {
        return this.criterion;
    }

    public final CriterionDecoder getDecoder() {
        if (this.decoder == null) {
            this.decoder = new CriterionDecoder(this.criterion, this.table.getDatabase(), this.orderBy);
        }
        return this.decoder;
    }

    private void clearDecoder() {
        this.decoder = null;
        this.statementInfo = null;
    }

    public Session getSession() {
        return this.session;
    }

    public MetaTable getTableModel() {
        return this.table;
    }

    public List<MetaColumn> getColumns() {
        return this.columns;
    }

    public MetaColumn getColumn(int index) {
        return this.columns.get(index);
    }

    @Override
    public UjoIterator<UJO> iterator() {
        UjoIterator result = UjoIterator.getInstance(this);
        return result;
    }

    @Deprecated
    public final UjoIterator<UJO> iterate() {
        return this.iterator();
    }

    public List<UJO> list() {
        return ((UjoIterator)this.iterator()).toList();
    }

    public UJO uniqueResult() throws NoSuchElementException {
        Iterator iterator = this.iterator();
        if (!((UjoIterator)iterator).hasNext()) {
            return null;
        }
        OrmUjo result = (OrmUjo)((UjoIterator)iterator).next();
        if (((UjoIterator)iterator).hasNext()) {
            ((UjoIterator)iterator).close();
            throw new NoSuchElementException("Result is not unique for: " + this.criterion);
        }
        return (UJO)result;
    }

    public boolean exists() {
        int $limit = this.limit;
        this.limit = 1;
        Iterator iterator = this.iterator();
        boolean result = ((UjoIterator)iterator).hasNext();
        ((UjoIterator)iterator).close();
        this.limit = $limit;
        return result;
    }

    public final List<UjoProperty<UJO, ?>> getOrderBy() {
        return this.orderBy;
    }

    public final UjoProperty<UJO, ?>[] getOrderAsArray() {
        return this.orderBy.toArray(new UjoProperty[this.orderBy.size()]);
    }

    @Deprecated
    public Query<UJO> setOrder(UjoProperty ... order) {
        return this.orderByMany(order);
    }

    public Query<UJO> orderBy(UjoProperty<UJO, ?> orderItem) {
        return this.orderByMany(orderItem);
    }

    public Query<UJO> orderBy(UjoProperty<UJO, ?> orderItem1, UjoProperty<UJO, ?> orderItem2) {
        return this.orderByMany(orderItem1, orderItem2);
    }

    public Query<UJO> orderBy(UjoProperty<UJO, ?> orderItem1, UjoProperty<UJO, ?> orderItem2, UjoProperty<UJO, ?> orderItem3) {
        return this.orderByMany(orderItem1, orderItem2, orderItem3);
    }

    public final Query<UJO> orderByMany(UjoProperty ... orderItems) {
        this.clearDecoder();
        this.orderBy = new ArrayList(Math.max(orderItems.length, 4));
        for (UjoProperty p : orderItems) {
            this.orderBy.add(p);
        }
        return this;
    }

    public Query<UJO> addColumn(UjoProperty<UJO, ?> column) throws IllegalArgumentException {
        MetaColumn mc = (MetaColumn)this.getHandler().findColumnModel(this.getDirectProperty(column));
        if (mc == null) {
            throw new IllegalArgumentException("Column " + column + " was not foud in the meta-model");
        }
        if (!this.columns.contains((Object)mc)) {
            this.columns.add(mc);
        }
        return this;
    }

    public Query<UJO> setColumn(UjoProperty<UJO, ?> column) throws IllegalArgumentException {
        this.columns = new ArrayList<MetaColumn>();
        return this.addColumn(this.getDirectProperty(column));
    }

    public final Query<UJO> setColumns(boolean addPrimaryKey, UjoProperty ... columns) throws IllegalArgumentException {
        this.columns = new ArrayList<MetaColumn>(columns.length);
        OrmHandler handler = this.getHandler();
        for (UjoProperty column : columns) {
            MetaColumn mc = (MetaColumn)handler.findColumnModel(this.getDirectProperty(column));
            if (mc.getTable() != this.table) {
                throw new IllegalArgumentException("Base class doesn't contains the column: " + column);
            }
            this.columns.add(mc);
        }
        if (addPrimaryKey && !this.columns.contains((Object)this.table.getFirstPK())) {
            this.columns.add(this.table.getFirstPK());
        }
        return this;
    }

    private UjoProperty getDirectProperty(UjoProperty p) {
        return p.isDirect() ? p : ((CompositeProperty)p).getFirstProperty();
    }

    public Query<UJO> orderBy(Collection<UjoProperty> orderItems) {
        this.clearDecoder();
        if (orderItems == null) {
            return this.orderByMany(new UjoProperty[0]);
        }
        this.orderBy.clear();
        this.orderBy.addAll(orderItems);
        return this;
    }

    public Query<UJO> addOrderBy(UjoProperty<UJO, ?> property) {
        this.clearDecoder();
        this.orderBy.add(property);
        return this;
    }

    public MetaColumn readOrderColumn(int i) throws IllegalStateException {
        UjoProperty<UJO, ?> property = this.orderBy.get(i);
        MetaRelation2Many result = this.session.getHandler().findColumnModel(property);
        if (result instanceof MetaColumn) {
            return (MetaColumn)result;
        }
        String msg = "Property '" + this.table.getType().getSimpleName() + "." + property + "' is not a persistent table column";
        throw new IllegalStateException(msg);
    }

    public boolean isOffset() {
        return this.offset > 0;
    }

    public final int getOffset() {
        return this.offset;
    }

    public Query<UJO> setOffset(int offset) {
        this.offset = offset;
        return this;
    }

    public final boolean isLimit() {
        return this.limit > 0;
    }

    public final int getLimit() {
        return this.limit;
    }

    public Query<UJO> setLimit(int limit) {
        this.limit = limit;
        return this;
    }

    public Query<UJO> setLimit(int limit, int offset) {
        this.limit = limit;
        this.offset = offset;
        return this;
    }

    @Deprecated
    public final Query<UJO> setMaxRows(int limit) {
        return this.setLimit(limit);
    }

    public int getFetchSize() {
        return this.fetchSize;
    }

    public Query<UJO> setFetchSize(int fetchSize) {
        this.fetchSize = fetchSize;
        return this;
    }

    public PreparedStatement getStatement() {
        return this.session.getStatement(this).getPreparedStatement();
    }

    public String getStatementInfo() {
        return this.statementInfo;
    }

    void setStatementInfo(String statementInfo) {
        this.statementInfo = statementInfo;
    }

    public boolean isLockRequest() {
        return this.lockRequest;
    }

    public Query<UJO> setLockRequest(boolean lockRequest) {
        this.lockRequest = lockRequest;
        return this;
    }

    public Query<UJO> setLockRequest() {
        return this.setLockRequest(true);
    }

    public String toString() {
        if (this.statementInfo != null) {
            return this.statementInfo;
        }
        StringBuilder result = new StringBuilder(64);
        if (this.table != null) {
            result.append('(').append(this.table.getType().getSimpleName()).append(") ");
        }
        if (this.criterion != null) {
            result.append(this.criterion);
        }
        return result.length() > 0 ? result.toString() : super.toString();
    }

    public boolean isDistinct() {
        return this.distinct;
    }

    public Query<UJO> setDistinct(boolean distinct) {
        this.distinct = distinct;
        return this;
    }

    public Query<UJO> setDistinct() {
        return this.setDistinct(true);
    }
}

