/*
 * Decompiled with CFR 0.152.
 */
package org.ujorm.orm;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.ujorm.CompositeProperty;
import org.ujorm.Ujo;
import org.ujorm.UjoProperty;
import org.ujorm.core.UjoIterator;
import org.ujorm.core.UjoManager;
import org.ujorm.criterion.BinaryCriterion;
import org.ujorm.criterion.Criterion;
import org.ujorm.criterion.ValueCriterion;
import org.ujorm.implementation.orm.RelationToMany;
import org.ujorm.orm.CriterionDecoder;
import org.ujorm.orm.DbProcedure;
import org.ujorm.orm.ExtendedOrmUjo;
import org.ujorm.orm.ForeignKey;
import org.ujorm.orm.JdbcStatement;
import org.ujorm.orm.OrmHandler;
import org.ujorm.orm.OrmUjo;
import org.ujorm.orm.Query;
import org.ujorm.orm.ao.CacheKey;
import org.ujorm.orm.ao.CachePolicy;
import org.ujorm.orm.metaModel.MetaColumn;
import org.ujorm.orm.metaModel.MetaDatabase;
import org.ujorm.orm.metaModel.MetaPKey;
import org.ujorm.orm.metaModel.MetaParams;
import org.ujorm.orm.metaModel.MetaProcedure;
import org.ujorm.orm.metaModel.MetaRelation2Many;
import org.ujorm.orm.metaModel.MetaTable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Session {
    private static final String SQL_VALUES = "\n-- SQL VALUES: ";
    public static final String SQL_ILLEGAL = "ILLEGAL SQL: ";
    private static final Logger LOGGER = Logger.getLogger(Session.class.getName());
    private final OrmHandler handler;
    private final MetaParams params;
    private final HashMap<MetaDatabase, Connection>[] connections = new HashMap[]{new HashMap(2), new HashMap(2)};
    private Map<CacheKey, OrmUjo> cache;
    private boolean rollbackOnly = false;
    private boolean closed = false;

    Session(OrmHandler handler) {
        this.handler = handler;
        this.params = handler.getParameters();
        this.clearCache((CachePolicy)((Object)MetaParams.CACHE_POLICY.of((Ujo)this.params)));
    }

    public final OrmHandler getHandler() {
        return this.handler;
    }

    public void commit() {
        this.commit(true);
    }

    public void rollback() {
        this.commit(false);
    }

    public void commit(boolean commit) {
        if (commit && this.rollbackOnly) {
            this.commit(false);
            throw new IllegalStateException("The Ujorm session has got the 'rollbackOnly' state.");
        }
        String errMessage = "Can't make commit of DB ";
        Object database = null;
        try {
            Object[] databases = this.connections[0].keySet().toArray(new MetaDatabase[this.connections[0].size()]);
            if (databases.length > 1) {
                Arrays.sort(databases);
            }
            for (int i = 0; i < databases.length; ++i) {
                database = databases[i];
                Connection conn = this.connections[0].get(database);
                if (commit) {
                    conn.commit();
                    if (!LOGGER.isLoggable(Level.FINE)) continue;
                    LOGGER.log(Level.FINE, "Commit of the " + ((MetaDatabase)database).getId());
                    continue;
                }
                conn.rollback();
                if (!LOGGER.isLoggable(Level.FINE)) continue;
                LOGGER.log(Level.FINE, "Rolback of the " + ((MetaDatabase)database).getId());
            }
        }
        catch (Throwable e) {
            LOGGER.log(Level.SEVERE, "Can't make commit of DB " + database, e);
            throw new IllegalStateException("Can't make commit of DB " + database, e);
        }
        this.rollbackOnly = false;
    }

    public <UJO extends OrmUjo> Query<UJO> createQuery(Class<UJO> aClass) {
        Criterion criterion = Criterion.where((boolean)true);
        return this.createQuery(aClass, criterion);
    }

    public <UJO extends OrmUjo> Query<UJO> createQuery(Class<UJO> aClass, Criterion<UJO> criterion) {
        MetaTable metaTable = this.handler.findTableModel(aClass);
        return new Query<UJO>(metaTable, criterion, this);
    }

    public <UJO extends OrmUjo> Query<UJO> createQuery(Criterion<UJO> criterion) {
        MetaRelation2Many column = this.getBasicColumn(criterion);
        MetaTable table = (MetaTable)((Object)MetaRelation2Many.TABLE.of((Ujo)column));
        return new Query<UJO>(table, criterion, this);
    }

    public MetaRelation2Many getBasicColumn(Criterion criterion) {
        while (criterion.isBinary()) {
            criterion = ((BinaryCriterion)criterion).getLeftNode();
        }
        ValueCriterion exprValue = (ValueCriterion)criterion;
        if (exprValue.getLeftNode() == null) {
            return null;
        }
        UjoProperty property = exprValue.getLeftNode();
        while (!property.isDirect()) {
            property = ((CompositeProperty)property).getFirstProperty();
        }
        MetaRelation2Many result = this.handler.findColumnModel(property);
        return result;
    }

    public final <DB extends OrmUjo> DB getFirstDatabase() {
        return this.getDatabase(null);
    }

    public <DB extends OrmUjo> DB getDatabase(Class<DB> dbType) {
        try {
            OrmUjo result = dbType != null ? (OrmUjo)dbType.newInstance() : (OrmUjo)MetaDatabase.ROOT.of((Ujo)this.handler.getDatabases().get(0));
            result.writeSession(this);
            return (DB)result;
        }
        catch (Exception e) {
            throw new RuntimeException("Can't create database from: " + dbType);
        }
    }

    public void saveOrUpdate(OrmUjo bo) throws IllegalStateException {
        if (bo.readSession() == null) {
            this.save(bo);
        } else {
            this.update(bo);
        }
    }

    private MetaTable modifyParent(OrmUjo bo) {
        OrmUjo parent;
        MetaTable table = this.handler.findTableModel(bo.getClass());
        if (((Boolean)MetaParams.INHERITANCE_MODE.of((Ujo)this.params)).booleanValue() && (parent = table.getParent(bo)) != null) {
            this.saveOrUpdate(parent);
        }
        return table;
    }

    public void save(List<? extends OrmUjo> bos) throws IllegalStateException {
        int multiLimit = this.params.get(MetaParams.INSERT_MULTIROW_ITEM_LIMIT);
        this.save(bos, multiLimit);
    }

    /*
     * WARNING - void declaration
     */
    public void save(List<? extends OrmUjo> bos, int multiLimit) throws IllegalStateException {
        if (bos == null || bos.isEmpty()) {
            LOGGER.log(Level.INFO, "The multi insert list is empty");
            return;
        }
        MetaTable table = this.handler.findTableModel(bos.get(0).getClass());
        MetaDatabase db = (MetaDatabase)MetaTable.DATABASE.of((Ujo)table);
        int bosCount = bos.size();
        table.assertChangeAllowed();
        if (!db.getDialect().isMultiRowInsertSupported()) {
            for (OrmUjo ormUjo : bos) {
                this.save(ormUjo);
            }
            return;
        }
        boolean ihneritanceMode = (Boolean)MetaParams.INHERITANCE_MODE.of((Ujo)this.params);
        for (OrmUjo ormUjo : bos) {
            OrmUjo parent;
            if (ihneritanceMode && (parent = table.getParent(ormUjo)) != null) {
                this.saveOrUpdate(parent);
            }
            table.assignPrimaryKey(ormUjo, this);
            ormUjo.writeSession(this);
        }
        multiLimit = this.between(multiLimit, 1, bosCount);
        boolean bl = false;
        int n = multiLimit;
        JdbcStatement statement = null;
        String sql = "";
        StringBuilder out = new StringBuilder(256);
        try {
            int n2;
            void var7_11;
            while (var7_11 < n2) {
                out.setLength(0);
                sql = db.getDialect().printInsert(bos, (int)var7_11, n2, out).toString();
                LOGGER.log(Level.INFO, sql);
                statement = this.getStatement(db, sql);
                statement.assignValues(bos, (int)var7_11, n2);
                LOGGER.log(Level.FINE, SQL_VALUES + statement.getAssignedValues());
                statement.executeUpdate();
                MetaDatabase.close(null, statement, null, true);
                statement = null;
                var7_11 = n2;
                n2 = this.between((int)(var7_11 + multiLimit), (int)var7_11, bosCount);
            }
        }
        catch (Throwable e) {
            this.rollbackOnly = true;
            throw new IllegalStateException(SQL_ILLEGAL + sql, e);
        }
        finally {
            MetaDatabase.close(null, statement, null, true);
        }
    }

    private int between(int value, int min, int max) {
        if (value < min) {
            value = min;
        } else if (value > max) {
            value = max;
        }
        return value;
    }

    public void save(OrmUjo bo) throws IllegalStateException {
        JdbcStatement statement = null;
        String sql = "";
        try {
            MetaTable table = this.modifyParent(bo);
            table.assertChangeAllowed();
            table.assignPrimaryKey(bo, this);
            bo.writeSession(this);
            MetaDatabase db = (MetaDatabase)MetaTable.DATABASE.of((Ujo)table);
            sql = db.getDialect().printInsert(bo, this.out(128)).toString();
            LOGGER.log(Level.INFO, sql);
            statement = this.getStatement(db, sql);
            statement.assignValues(bo);
            LOGGER.log(Level.INFO, SQL_VALUES + statement.getAssignedValues());
            statement.executeUpdate();
        }
        catch (Throwable e) {
            try {
                this.rollbackOnly = true;
                throw new IllegalStateException(SQL_ILLEGAL + sql, e);
            }
            catch (Throwable throwable) {
                MetaDatabase.close(null, statement, null, true);
                throw throwable;
            }
        }
        MetaDatabase.close(null, statement, null, true);
    }

    public int update(OrmUjo bo) throws IllegalStateException {
        return this.update(bo, this.createPkCriterion(bo), true);
    }

    public int update(OrmUjo bo, Criterion criterion) {
        return this.update(bo, criterion, false);
    }

    private int update(OrmUjo bo, Criterion criterion, boolean singleObject) {
        List<MetaColumn> changedColumns;
        MetaDatabase db;
        String sql;
        JdbcStatement statement;
        int result;
        block6: {
            result = 0;
            statement = null;
            sql = null;
            MetaTable table = singleObject ? this.modifyParent(bo) : this.handler.findTableModel(bo.getClass());
            table.assertChangeAllowed();
            db = (MetaDatabase)MetaTable.DATABASE.of((Ujo)table);
            changedColumns = this.getOrmColumns(bo.readChangedProperties(true));
            if (!changedColumns.isEmpty()) break block6;
            LOGGER.warning("No changes to update in the object: " + bo);
            int n = result;
            MetaDatabase.close(null, statement, null, true);
            return n;
        }
        try {
            MetaTable ormTable = this.handler.findTableModel(bo.getClass());
            CriterionDecoder decoder = new CriterionDecoder(criterion, ormTable);
            sql = db.getDialect().printUpdate(ormTable, changedColumns, decoder, this.out(64)).toString();
            statement = this.getStatement(db, sql);
            statement.assignValues(bo, changedColumns);
            statement.assignValues(decoder);
            if (LOGGER.isLoggable(Level.INFO)) {
                LOGGER.log(Level.INFO, sql + SQL_VALUES + statement.getAssignedValues());
            }
            result = statement.executeUpdate();
            bo.writeSession(this);
        }
        catch (Throwable e) {
            try {
                this.rollbackOnly = true;
                MetaDatabase.close(null, statement, null, false);
                throw new IllegalStateException(SQL_ILLEGAL + sql, e);
            }
            catch (Throwable throwable) {
                MetaDatabase.close(null, statement, null, true);
                throw throwable;
            }
        }
        MetaDatabase.close(null, statement, null, true);
        return result;
    }

    public <UJO extends OrmUjo> int delete(Criterion<UJO> criterion) {
        MetaRelation2Many column = this.getBasicColumn(criterion);
        MetaTable table = (MetaTable)((Object)MetaRelation2Many.TABLE.of((Ujo)column));
        return this.delete(table, criterion);
    }

    public int delete(OrmUjo bo) {
        OrmUjo parent;
        MetaTable table = this.handler.findTableModel(bo.getClass());
        table.assertChangeAllowed();
        MetaColumn PK = table.getFirstPK();
        Criterion crn = Criterion.where((UjoProperty)PK.getProperty(), (Object)PK.getValue(bo));
        int result = this.delete(table, crn);
        this.removeCache(bo, (MetaPKey)((Object)MetaTable.PK.of((Ujo)table)));
        if (((Boolean)MetaParams.INHERITANCE_MODE.of((Ujo)this.params)).booleanValue() && (parent = table.getParent(bo)) != null) {
            this.delete(parent);
        }
        return result;
    }

    public <UJO extends OrmUjo> int delete(Class<UJO> tableClass, Criterion<UJO> criterion) {
        MetaTable tableModel = this.handler.findTableModel(tableClass);
        return this.delete(tableModel, criterion);
    }

    protected <UJO extends OrmUjo> int delete(MetaTable tableModel, Criterion<UJO> criterion) {
        tableModel.assertChangeAllowed();
        int result = 0;
        JdbcStatement statement = null;
        String sql = "";
        try {
            MetaDatabase db = (MetaDatabase)MetaTable.DATABASE.of((Ujo)tableModel);
            CriterionDecoder decoder = new CriterionDecoder(criterion, tableModel);
            sql = db.getDialect().printDelete(tableModel, decoder, this.out(64)).toString();
            statement = this.getStatement(db, sql);
            statement.assignValues(decoder);
            if (LOGGER.isLoggable(Level.INFO)) {
                LOGGER.log(Level.INFO, sql + SQL_VALUES + statement.getAssignedValues());
            }
            result = statement.executeUpdate();
        }
        catch (Throwable e) {
            try {
                this.rollbackOnly = true;
                MetaDatabase.close(null, statement, null, false);
                throw new IllegalStateException(SQL_ILLEGAL + sql, e);
            }
            catch (Throwable throwable) {
                MetaDatabase.close(null, statement, null, true);
                throw throwable;
            }
        }
        MetaDatabase.close(null, statement, null, true);
        return result;
    }

    protected void call(DbProcedure procedure) {
        JdbcStatement statement = null;
        String sql = "";
        MetaDatabase db = procedure.metaProcedure.getDatabase();
        MetaProcedure mProcedure = procedure.metaProcedure();
        try {
            sql = db.getDialect().printCall(mProcedure, this.out(64)).toString();
            statement = this.getStatementCallable(db, sql);
            statement.assignValues(procedure);
            if (LOGGER.isLoggable(Level.INFO)) {
                LOGGER.log(Level.INFO, sql + SQL_VALUES + statement.getAssignedValues());
            }
            statement.execute();
            statement.loadValues(procedure);
        }
        catch (Throwable e) {
            try {
                this.rollbackOnly = true;
                MetaDatabase.close(null, statement, null, false);
                throw new IllegalStateException(SQL_ILLEGAL + sql, e);
            }
            catch (Throwable throwable) {
                MetaDatabase.close(null, statement, null, true);
                throw throwable;
            }
        }
        MetaDatabase.close(null, statement, null, true);
    }

    protected List<MetaColumn> getOrmColumns(UjoProperty ... properties) {
        ArrayList<MetaColumn> result = new ArrayList<MetaColumn>(properties.length);
        for (UjoProperty property : properties) {
            MetaRelation2Many column = this.handler.findColumnModel(property);
            if (!(column instanceof MetaColumn)) continue;
            result.add((MetaColumn)column);
        }
        return result;
    }

    protected Criterion createPkCriterion(OrmUjo bo) {
        Criterion result = null;
        MetaTable ormTable = this.handler.findTableModel(bo.getClass());
        MetaPKey ormKey = (MetaPKey)((Object)MetaTable.PK.of((Ujo)ormTable));
        List keys = (List)MetaPKey.COLUMNS.of((Ujo)ormKey);
        for (MetaColumn ormColumn : keys) {
            Criterion crn = Criterion.where((UjoProperty)ormColumn.getProperty(), (Object)ormColumn.getValue(bo));
            result = result != null ? result.and(crn) : crn;
        }
        return result != null ? result : Criterion.where((boolean)false);
    }

    public <UJO extends OrmUjo> long getRowCount(Query<UJO> query) {
        long result = -1L;
        JdbcStatement statement = null;
        ResultSet rs = null;
        MetaTable table = query.getTableModel();
        MetaDatabase db = (MetaDatabase)MetaTable.DATABASE.of((Ujo)table);
        String sql = "";
        try {
            sql = db.getDialect().printSelect(table, query, true, this.out(128)).toString();
            LOGGER.log(Level.INFO, sql);
            statement = this.getStatement(db, sql);
            statement.assignValues(query.getDecoder());
            LOGGER.log(Level.INFO, SQL_VALUES + statement.getAssignedValues());
            rs = statement.executeQuery();
            result = rs.next() ? rs.getLong(1) : 0L;
        }
        catch (Exception e) {
            try {
                this.rollbackOnly = true;
                throw new RuntimeException(SQL_ILLEGAL + sql, e);
            }
            catch (Throwable throwable) {
                MetaDatabase.close(null, statement, rs, false);
                throw throwable;
            }
        }
        MetaDatabase.close(null, statement, rs, false);
        return result;
    }

    public JdbcStatement getStatement(Query query) {
        JdbcStatement result = null;
        String sql = "";
        try {
            MetaTable table = query.getTableModel();
            MetaDatabase db = (MetaDatabase)MetaTable.DATABASE.of((Ujo)table);
            sql = db.getDialect().printSelect(table, query, false, this.out(360)).toString();
            query.setStatementInfo(sql);
            result = this.getStatement(db, sql);
            if (query.getLimit() >= 0) {
                result.getPreparedStatement().setMaxRows(query.getLimit());
            }
            if (query.getFetchSize() >= 0) {
                result.getPreparedStatement().setFetchSize(query.getFetchSize());
            }
            result.assignValues(query.getDecoder());
            if (LOGGER.isLoggable(Level.INFO)) {
                LOGGER.log(Level.INFO, sql + SQL_VALUES + result.getAssignedValues());
            }
            return result;
        }
        catch (Throwable e) {
            this.rollbackOnly = true;
            throw new IllegalStateException(SQL_ILLEGAL + sql, e);
        }
    }

    private MetaColumn findOrmColumn(MetaTable table, Class tableType) {
        for (MetaColumn column : (List)MetaTable.COLUMNS.of((Ujo)table)) {
            if (!column.isForeignKey() || column.getProperty().getType() != tableType) continue;
            return column;
        }
        return null;
    }

    public <UJO extends OrmUjo> UjoIterator<UJO> iterateInternal(RelationToMany property, OrmUjo value) {
        MetaTable origTable;
        Class tableClass = property.getItemType();
        MetaTable table = this.handler.findTableModel(tableClass);
        MetaColumn fColumn = this.findOrmColumn(table, value.getClass());
        if (fColumn == null && (origTable = this.handler.findTableModel(value.getClass())).isPersistent()) {
            String msg = "Can't find a foreign key of " + (Object)((Object)table) + " to a " + value.getClass().getSimpleName();
            throw new IllegalStateException(msg);
        }
        Criterion crit = fColumn != null ? Criterion.where((UjoProperty)fColumn.getProperty(), (Object)value) : Criterion.constant((UjoProperty)table.getFirstPK().getProperty(), (boolean)true);
        Query<OrmUjo> query = this.createQuery(table.getType(), crit);
        UjoIterator<OrmUjo> result = UjoIterator.getInstance(query);
        return result;
    }

    private Connection getConnection_(MetaDatabase database, int index) throws IllegalStateException {
        Connection result = this.connections[index].get(database);
        if (result == null) {
            this.assertOpenSession();
            try {
                result = database.createConnection();
            }
            catch (Exception e) {
                throw new IllegalStateException("Can't create an connection for " + database, e);
            }
            this.connections[index].put(database, result);
        }
        return result;
    }

    public final Connection getFirstConnection() throws IllegalStateException {
        return this.getConnection(0);
    }

    public final Connection getConnection(int databaseIndex) throws IllegalStateException {
        return this.getConnection_(this.handler.getDatabases().get(databaseIndex), 0);
    }

    public final Connection getConnection(MetaDatabase database) throws IllegalStateException {
        return this.getConnection_(database, 0);
    }

    final Connection getSeqConnection(MetaDatabase database) throws IllegalStateException {
        return this.getConnection_(database, 1);
    }

    public JdbcStatement getStatement(MetaDatabase database, CharSequence sql) throws SQLException {
        JdbcStatement result = new JdbcStatement(this.getConnection(database), sql, this.handler);
        return result;
    }

    public JdbcStatement getStatementCallable(MetaDatabase database, String sql) throws SQLException {
        JdbcStatement result = new JdbcStatement(this.getConnection(database).prepareCall(sql), this.handler);
        return result;
    }

    public <UJO extends OrmUjo> UJO load(Class<UJO> tableType, Object id) throws NoSuchElementException {
        MetaTable table = this.handler.findTableModel(tableType);
        MetaColumn column = table.getFirstPK();
        UjoManager.getInstance().assertAssign((UjoProperty)MetaColumn.TABLE_PROPERTY.of((Ujo)column), id);
        Criterion crn = Criterion.where((UjoProperty)column.getProperty(), (Object)id);
        Query<UJO> query = this.createQuery(crn);
        UJO result = query.uniqueResult();
        return result;
    }

    public <UJO extends OrmUjo> UJO loadInternal(UjoProperty relatedProperty, Object id, boolean mandatory) throws NoSuchElementException {
        OrmUjo r;
        this.assertOpenSession();
        MetaColumn column = (MetaColumn)this.handler.findColumnModel(relatedProperty);
        List<MetaColumn> columns = column.getForeignColumns();
        if (columns.size() != 1) {
            throw new UnsupportedOperationException("There is supported only a one-column foreign key: " + (Object)((Object)column));
        }
        MetaTable tableModel = null;
        if (this.cache != null && (r = this.findCache((Class)(tableModel = (MetaTable)((Object)MetaColumn.TABLE.of((Ujo)columns.get(0)))).getType(), id)) != null) {
            return (UJO)r;
        }
        Criterion crn = Criterion.where((UjoProperty)columns.get(0).getProperty(), (Object)id);
        UJO result = this.createQuery(crn).uniqueResult();
        if (mandatory && result == null) {
            throw new RuntimeException("Deleted object for key " + id);
        }
        if (this.cache != null) {
            this.addCache((OrmUjo)result, (MetaPKey)((Object)MetaTable.PK.of((Ujo)tableModel)));
        }
        return result;
    }

    public void close() throws IllegalStateException {
        this.closed = true;
        this.cache = null;
        Throwable exception = null;
        MetaDatabase database = null;
        String errMessage = "Can't close connection for DB ";
        for (HashMap<MetaDatabase, Connection> cons : this.connections) {
            for (MetaDatabase db : cons.keySet()) {
                try {
                    Connection conn = cons.get(db);
                    if (conn == null) continue;
                    conn.rollback();
                    conn.close();
                }
                catch (Throwable e) {
                    LOGGER.log(Level.SEVERE, errMessage + db, e);
                    if (exception != null) continue;
                    exception = e;
                    database = db;
                }
            }
            cons.clear();
        }
        if (exception != null) {
            throw new IllegalStateException(errMessage + database, exception);
        }
    }

    public boolean isClosed() {
        return this.closed;
    }

    private void assertOpenSession() throws IllegalStateException {
        if (this.closed) {
            throw new IllegalStateException("The session is closed (" + this.hashCode() + ")");
        }
    }

    private StringBuilder out(int capacity) {
        return new StringBuilder(capacity);
    }

    private void addCache(OrmUjo bo, MetaPKey pkey) {
        CacheKey key = CacheKey.newInstance(bo, pkey);
        this.cache.put(key, bo);
    }

    private boolean removeCache(OrmUjo bo, MetaPKey pkey) {
        CacheKey key = CacheKey.newInstance(bo, pkey);
        OrmUjo result = this.cache.remove(key);
        return result != null;
    }

    public OrmUjo findCache(Class type, Object pkey) {
        this.assertOpenSession();
        CacheKey key = CacheKey.newInstance(type, pkey);
        return this.cache.get(key);
    }

    public OrmUjo findCache(Class type, Object ... pkeys) {
        this.assertOpenSession();
        CacheKey key = CacheKey.newInstance(type, pkeys);
        return this.cache.get(key);
    }

    public void clearCache() {
        if (this.cache != null) {
            this.cache.clear();
        }
    }

    public final void clearCache(CachePolicy policy) {
        this.assertOpenSession();
        switch (policy) {
            case PROTECTED_CACHE: {
                this.cache = new WeakHashMap<CacheKey, OrmUjo>();
                break;
            }
            case SOLID_CACHE: {
                this.cache = new HashMap<CacheKey, OrmUjo>();
                break;
            }
            case NO_CACHE: {
                this.cache = null;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported cache policy: " + (Object)((Object)policy));
            }
        }
    }

    public final MetaParams getParameters() {
        return this.params;
    }

    public boolean isRollbackOnly() {
        return this.rollbackOnly;
    }

    public void markForRolback() {
        this.rollbackOnly = true;
    }

    public ForeignKey readFK(OrmUjo ujo, UjoProperty<?, ? extends OrmUjo> property) throws IllegalStateException {
        MetaColumn column = (MetaColumn)this.handler.findColumnModel(property);
        if (column != null && column.isForeignKey()) {
            Object result = column.getForeignColumns().get(0).getProperty().of((Ujo)ujo);
            return new ForeignKey(result);
        }
        throw new IllegalStateException("The property '" + property + "' is not a foreign key");
    }

    public boolean reload(OrmUjo ujo) {
        if (ujo == null) {
            return false;
        }
        MetaTable metaTable = this.handler.findTableModel(ujo.getClass());
        MetaPKey pkeys = (MetaPKey)((Object)MetaTable.PK.getValue((Ujo)metaTable));
        boolean fk = ujo instanceof ExtendedOrmUjo;
        Criterion criterion = null;
        for (MetaColumn c : (List)MetaPKey.COLUMNS.of((Ujo)pkeys)) {
            Criterion crn = Criterion.where((UjoProperty)c.getProperty(), (Object)c.getValue(ujo));
            criterion = criterion != null ? criterion.and(crn) : crn;
        }
        Object result = this.createQuery(criterion).uniqueResult();
        if (result == null) {
            return false;
        }
        ujo.writeSession(null);
        for (MetaColumn c : (List)MetaTable.COLUMNS.of((Ujo)metaTable)) {
            if (fk && c.isForeignKey()) {
                UjoProperty p = c.getProperty();
                ujo.writeValue(p, ((ExtendedOrmUjo)result).readFK(p));
                continue;
            }
            if (!c.isColumn()) continue;
            c.getProperty().copy(result, (Ujo)ujo);
        }
        ujo.writeSession(this);
        ujo.readChangedProperties(true);
        return true;
    }

    public static Session newClosedSession(OrmHandler handler) {
        Session result = new Session(handler);
        result.close();
        return result;
    }
}

