/*
 * Decompiled with CFR 0.152.
 */
package org.ujorm.orm;

import java.io.BufferedReader;
import java.io.CharArrayReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.sql.Connection;
import java.sql.Date;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.ujorm.Ujo;
import org.ujorm.UjoProperty;
import org.ujorm.criterion.Operator;
import org.ujorm.criterion.ValueCriterion;
import org.ujorm.orm.CriterionDecoder;
import org.ujorm.orm.DbType;
import org.ujorm.orm.OrmHandler;
import org.ujorm.orm.OrmUjo;
import org.ujorm.orm.Query;
import org.ujorm.orm.SeqTableModel;
import org.ujorm.orm.UjoSequencer;
import org.ujorm.orm.metaModel.MetaColumn;
import org.ujorm.orm.metaModel.MetaDatabase;
import org.ujorm.orm.metaModel.MetaIndex;
import org.ujorm.orm.metaModel.MetaParams;
import org.ujorm.orm.metaModel.MetaProcedure;
import org.ujorm.orm.metaModel.MetaSelect;
import org.ujorm.orm.metaModel.MetaTable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SqlDialect {
    private static final Logger LOGGER = Logger.getLogger(SqlDialect.class.getName());
    private final SeqTableModel pkTableModel = new SeqTableModel();
    public static final String COMMON_SEQ_TABLE_KEY = "<ALL>";
    public static final String DEFAULT_SCHEMA_SYMBOL = "~";
    protected OrmHandler ormHandler;

    public void setHandler(OrmHandler ormHandler) {
        if (this.ormHandler != null) {
            throw new IllegalStateException("The OrmHandler is assigned yet.");
        }
        this.ormHandler = ormHandler;
    }

    public abstract String getJdbcUrl();

    public abstract String getJdbcDriver();

    public Connection createConnection(MetaDatabase db) throws Exception {
        return db.createInternalConnection();
    }

    public InitialContext createJndiInitialContext(MetaDatabase db) throws NamingException {
        return new InitialContext();
    }

    public Appendable printCreateSchema(String schema, Appendable out) throws IOException {
        out.append("CREATE SCHEMA IF NOT EXISTS ");
        out.append(schema);
        return out;
    }

    @Deprecated
    public Appendable printDefaultSchema(String schema, Appendable out) throws IOException {
        out.append("SET SCHEMA ");
        out.append(schema);
        return out;
    }

    public final Appendable printFullTableName(MetaTable table, Appendable out) throws IOException {
        return this.printFullTableName(table, false, out);
    }

    public Appendable printFullTableName(MetaTable table, boolean printSymbolSchema, Appendable out) throws IOException {
        String tableSchema = (String)MetaTable.SCHEMA.of((Ujo)table);
        String tableName = (String)MetaTable.NAME.of((Ujo)table);
        if (this.isUsable(tableSchema)) {
            out.append(printSymbolSchema && table.isDefaultSchema() ? DEFAULT_SCHEMA_SYMBOL : tableSchema);
            out.append('.');
        }
        out.append(tableName);
        return out;
    }

    public void printTableAliasDefinition(MetaTable table, Appendable out) throws IOException {
        this.printFullTableName(table, out);
        out.append(' ');
        out.append(table.getAlias());
    }

    public Appendable printColumnAlias(MetaColumn column, Appendable out) throws IOException {
        MetaTable table = (MetaTable)((Object)MetaColumn.TABLE.of((Ujo)column));
        out.append(table.getAlias());
        out.append('.');
        out.append((CharSequence)MetaColumn.NAME.of((Ujo)column));
        return out;
    }

    public Appendable printTable(MetaTable table, Appendable out) throws IOException {
        out.append("CREATE TABLE ");
        this.printFullTableName(table, out);
        String separator = "\n\t( ";
        for (MetaColumn column : MetaTable.COLUMNS.getList((Ujo)table)) {
            out.append(separator);
            separator = "\n\t, ";
            if (column.isForeignKey()) {
                this.printFKColumnsDeclaration(column, out);
                continue;
            }
            this.printColumnDeclaration(column, null, out);
        }
        out.append("\n\t)");
        return out;
    }

    public Appendable printAlterTable(MetaColumn column, Appendable out) throws IOException {
        out.append("ALTER TABLE ");
        this.printFullTableName(column.getTable(), out);
        out.append(" ADD COLUMN ");
        if (column.isForeignKey()) {
            this.printFKColumnsDeclaration(column, out);
        } else {
            this.printColumnDeclaration(column, null, out);
        }
        if (column.hasDefaultValue()) {
            this.printDefaultValue(column, out);
        }
        return out;
    }

    public Appendable printDefaultValue(MetaColumn column, Appendable out) throws IOException {
        Object value = column.getJdbcFriendlyDefaultValue();
        boolean isDefault = value != null;
        String quotMark = "";
        if (value instanceof String) {
            isDefault = ((String)value).length() > 0;
            quotMark = "'";
        } else if (value instanceof Date) {
            isDefault = true;
            quotMark = "'";
        }
        if (isDefault) {
            out.append(" DEFAULT ");
            out.append(quotMark);
            out.append(value.toString());
            out.append(quotMark);
        }
        return out;
    }

    public Appendable printForeignKey(MetaColumn column, MetaTable table, Appendable out) throws IOException {
        List<MetaColumn> fColumns = column.getForeignColumns();
        MetaTable foreignTable = fColumns.get(0).getTable();
        int columnsSize = fColumns.size();
        out.append("ALTER TABLE ");
        this.printFullTableName(table, out);
        out.append("\n\tADD FOREIGN KEY");
        for (int i = 0; i < columnsSize; ++i) {
            out.append(i == 0 ? "(" : ", ");
            String name = column.getForeignColumnName(i);
            out.append(name);
        }
        out.append(")\n\tREFERENCES ");
        this.printFullTableName(foreignTable, out);
        String separator = "(";
        for (MetaColumn fColumn : fColumns) {
            out.append(separator);
            separator = ", ";
            out.append((CharSequence)MetaColumn.NAME.of((Ujo)fColumn));
        }
        out.append(")");
        return out;
    }

    public Appendable printIndex(MetaIndex index, Appendable out) throws IOException {
        out.append("CREATE ");
        if (((Boolean)MetaIndex.UNIQUE.of((Ujo)index)).booleanValue()) {
            out.append("UNIQUE ");
        }
        out.append("INDEX ");
        out.append((CharSequence)MetaIndex.NAME.of((Ujo)index));
        out.append(" ON ");
        this.printFullTableName((MetaTable)((Object)MetaIndex.TABLE.of((Ujo)index)), out);
        String separator = " (";
        for (MetaColumn column : (List)MetaIndex.COLUMNS.of((Ujo)index)) {
            out.append(separator);
            out.append((CharSequence)MetaColumn.NAME.of((Ujo)column));
            separator = ", ";
        }
        out.append(')');
        return out;
    }

    protected boolean isColumnLengthAllowed(MetaColumn column) {
        switch ((DbType)((Object)MetaColumn.DB_TYPE.of((Ujo)column))) {
            case INT: 
            case SMALLINT: 
            case BIGINT: 
            case DATE: 
            case TIME: 
            case TIMESTAMP: {
                return false;
            }
        }
        return !MetaColumn.MAX_LENGTH.isDefault((Ujo)column);
    }

    public Appendable printColumnDeclaration(MetaColumn column, String aName, Appendable out) throws IOException {
        String name = aName != null ? aName : (String)MetaColumn.NAME.of((Ujo)column);
        out.append(name);
        out.append(' ');
        out.append(this.getColumnType(column));
        if (this.isColumnLengthAllowed(column)) {
            out.append("(" + MetaColumn.MAX_LENGTH.of((Ujo)column));
            if (!MetaColumn.PRECISION.isDefault((Ujo)column)) {
                out.append("," + MetaColumn.PRECISION.of((Ujo)column));
            }
            out.append(")");
        }
        if (((Boolean)MetaColumn.MANDATORY.of((Ujo)column)).booleanValue() && aName == null) {
            out.append(" NOT NULL");
        }
        if (((Boolean)MetaColumn.PRIMARY_KEY.of((Ujo)column)).booleanValue() && aName == null) {
            out.append(" PRIMARY KEY");
        }
        return out;
    }

    protected String getColumnType(MetaColumn column) {
        return ((DbType)((Object)MetaColumn.DB_TYPE.of((Ujo)column))).name();
    }

    public Appendable printFKColumnsDeclaration(MetaColumn column, Appendable out) throws IOException {
        List<MetaColumn> columns = column.getForeignColumns();
        for (int i = 0; i < columns.size(); ++i) {
            MetaColumn col = columns.get(i);
            out.append(i == 0 ? "" : "\n\t, ");
            String name = column.getForeignColumnName(i);
            this.printColumnDeclaration(col, name, out);
            if (!((Boolean)MetaColumn.MANDATORY.of((Ujo)column)).booleanValue()) continue;
            out.append(" NOT NULL");
        }
        return out;
    }

    public Appendable printInsert(OrmUjo bo, Appendable out) throws IOException {
        MetaTable table = this.ormHandler.findTableModel(bo.getClass());
        StringBuilder values = new StringBuilder();
        out.append("INSERT INTO ");
        this.printFullTableName(table, out);
        out.append(" (");
        this.printTableColumns(MetaTable.COLUMNS.getList((Ujo)table), values, out);
        out.append(") VALUES (").append(values).append(")");
        return out;
    }

    public Appendable printInsert(List<? extends OrmUjo> bos, int idxFrom, int idxTo, Appendable out) throws IOException {
        MetaTable table = this.ormHandler.findTableModel(bos.get(idxFrom).getClass());
        StringBuilder values = new StringBuilder(32);
        out.append("INSERT INTO ");
        this.printFullTableName(table, out);
        out.append(" (");
        this.printTableColumns(MetaTable.COLUMNS.getList((Ujo)table), values, out);
        for (int i = idxFrom; i < idxTo; ++i) {
            out.append(i == idxFrom ? ") VALUES \n(" : "),\n(").append(values);
        }
        out.append(")");
        return out;
    }

    public Appendable printInsertBySelect(List<? extends OrmUjo> bos, int idxFrom, int idxTo, String fromPhrase, Appendable out) throws IOException {
        MetaTable table = this.ormHandler.findTableModel(bos.get(idxFrom).getClass());
        StringBuilder values = new StringBuilder(32);
        out.append("INSERT INTO ");
        this.printFullTableName(table, out);
        out.append(" (");
        this.printTableColumns(MetaTable.COLUMNS.getList((Ujo)table), values, out);
        for (int i = idxFrom; i < idxTo; ++i) {
            out.append(i == idxFrom ? ")\nSELECT " : " UNION ALL\nSELECT ").append(values);
            if (!this.isUsable(fromPhrase)) continue;
            out.append(" ").append(fromPhrase);
        }
        return out;
    }

    public boolean isMultiRowInsertSupported() {
        return true;
    }

    public Appendable printUpdate(MetaTable table, List<MetaColumn> changedColumns, CriterionDecoder decoder, Appendable out) throws IOException {
        out.append("UPDATE ");
        this.printTableAliasDefinition(table, out);
        out.append("\n\tSET ");
        for (int i = 0; i < changedColumns.size(); ++i) {
            MetaColumn ormColumn = changedColumns.get(i);
            if (ormColumn.isPrimaryKey()) {
                throw new IllegalStateException("Primary key can not be changed: " + (Object)((Object)ormColumn));
            }
            out.append(i == 0 ? "" : ", ");
            out.append((CharSequence)MetaColumn.NAME.of((Ujo)ormColumn));
            out.append("=?");
        }
        out.append("\n\tWHERE ");
        out.append(decoder.getWhere());
        return out;
    }

    public Appendable printDelete(MetaTable table, CriterionDecoder decoder, Appendable out) throws IOException {
        out.append("DELETE FROM ");
        this.printTableAliasDefinition(table, out);
        out.append(" WHERE ");
        out.append(decoder.getWhere());
        return out;
    }

    public String getCriterionTemplate(ValueCriterion crit) {
        switch (crit.getOperator()) {
            case EQ: {
                return "{0}={1}";
            }
            case NOT_EQ: {
                return "{0}<>{1}";
            }
            case GT: {
                return "{0}>{1}";
            }
            case GE: {
                return "{0}>={1}";
            }
            case LT: {
                return "{0}<{1}";
            }
            case LE: {
                return "{0}<={1}";
            }
            case EQUALS_CASE_INSENSITIVE: {
                return "UPPER({0})={1}";
            }
            case STARTS_CASE_INSENSITIVE: 
            case ENDS_CASE_INSENSITIVE: 
            case CONTAINS_CASE_INSENSITIVE: {
                return "UPPER({0}) LIKE {1}";
            }
            case STARTS: 
            case ENDS: 
            case CONTAINS: {
                return "{0} LIKE {1}";
            }
            case IN: {
                return "{0} IN ({1})";
            }
            case NOT_IN: {
                return "NOT {0} IN ({1})";
            }
            case XFIXED: {
                return crit.evaluate(null) ? "1=1" : "1=0";
            }
            case XSQL: {
                return "(" + crit.getRightNode() + ')';
            }
        }
        throw new UnsupportedOperationException("Unsupported: " + crit.getOperator());
    }

    public void printTableColumns(List<MetaColumn> columns, Appendable values, Appendable out) throws IOException {
        String separator = "";
        boolean select = values == null;
        for (MetaColumn column : columns) {
            if (column.isForeignKey()) {
                for (int i = 0; i < column.getForeignColumns().size(); ++i) {
                    out.append(separator);
                    if (select) {
                        out.append(((MetaTable)((Object)MetaColumn.TABLE.of((Ujo)column))).getAlias());
                        out.append('.');
                    }
                    out.append(column.getForeignColumnName(i));
                    if (values != null) {
                        values.append(separator);
                        values.append("?");
                    }
                    separator = ", ";
                }
                continue;
            }
            if (!column.isColumn()) continue;
            out.append(separator);
            if (select) {
                this.printColumnAlias(column, out);
            } else {
                out.append((CharSequence)MetaColumn.NAME.of((Ujo)column));
            }
            if (values != null) {
                values.append(separator);
                values.append("?");
            }
            separator = ", ";
        }
    }

    public ValueCriterion printCriterion(ValueCriterion crit, Appendable out) throws IOException {
        Operator operator = crit.getOperator();
        UjoProperty property = crit.getLeftNode();
        Object right = crit.getRightNode();
        MetaColumn column = (MetaColumn)this.ormHandler.findColumnModel(property);
        if (right == null) {
            switch (operator) {
                case EQ: 
                case EQUALS_CASE_INSENSITIVE: {
                    this.printColumnAlias(column, out);
                    out.append(" IS NULL");
                    return null;
                }
                case NOT_EQ: {
                    this.printColumnAlias(column, out);
                    out.append(" IS NOT NULL");
                    return null;
                }
            }
            throw new UnsupportedOperationException("Comparation the NULL value is forbiden by a operator: " + operator);
        }
        String template = this.getCriterionTemplate(crit);
        if (template == null) {
            throw new UnsupportedOperationException("Unsupported SQL operator: " + operator);
        }
        if (crit.isConstant()) {
            out.append(template);
        } else if (right instanceof UjoProperty) {
            UjoProperty rightProperty = (UjoProperty)right;
            MetaColumn col2 = (MetaColumn)this.ormHandler.findColumnModel(rightProperty);
            if (!rightProperty.isDirect()) {
                throw new UnsupportedOperationException("Two tables is not supported yet");
            }
            if (col2.isForeignKey()) {
                throw new UnsupportedOperationException("Foreign key is not supported yet");
            }
            String f = MessageFormat.format(template, column.getAliasName(), col2.getAliasName());
            out.append(f);
        } else {
            if (right instanceof Object[]) {
                Object[] os = (Object[])right;
                StringBuilder sb = new StringBuilder(2 * os.length);
                for (Object o : os) {
                    sb.append(sb.length() > 0 ? ",?" : "?");
                }
                String f = MessageFormat.format(template, column.getAliasName(), sb.toString());
                out.append(f);
                return crit;
            }
            if (column.isForeignKey()) {
                this.printForeignKey(crit, column, template, out);
                return crit;
            }
            String f = MessageFormat.format(template, column.getAliasName(), "?");
            out.append(f);
            return crit;
        }
        return null;
    }

    public void printForeignKey(ValueCriterion crit, MetaColumn column, String template, Appendable out) throws IOException {
        int size = column.getForeignColumns().size();
        for (int i = 0; i < size; ++i) {
            if (i > 0) {
                out.append(' ');
                out.append(crit.getOperator().name());
                out.append(' ');
            }
            String alias = ((MetaTable)((Object)MetaColumn.TABLE.of((Ujo)column))).getAlias();
            String columnName = column.getForeignColumnName(i);
            if (this.isUsable(alias)) {
                columnName = alias + '.' + columnName;
            }
            String f = MessageFormat.format(template, columnName, "?");
            out.append(f);
        }
    }

    public final Appendable printSelect(MetaTable table, Query query, boolean count, Appendable out) throws IOException {
        return table.isView() ? this.printSelectView(table, query, count, out) : this.printSelectTable(query, count, out);
    }

    protected Appendable printSelectView(MetaTable table, Query query, boolean count, Appendable out) throws IOException {
        MetaSelect select = (MetaSelect)((Object)MetaTable.SELECT_MODEL.of((Ujo)table));
        String where = query.getDecoder().getWhere();
        List order = query.getOrderBy();
        for (UjoProperty p : select.readProperties()) {
            String value = (String)p.of((Ujo)select);
            if (p == MetaSelect.SELECT && count) {
                out.append(p.toString());
                out.append("COUNT(*)");
                continue;
            }
            if (p == MetaSelect.WHERE && value.length() + where.length() > 0) {
                out.append(p.toString());
                out.append(value);
                out.append(value.isEmpty() || where.isEmpty() ? "" : " AND ");
                out.append(where);
                continue;
            }
            if (p == MetaSelect.ORDER && !order.isEmpty()) {
                out.append(p.toString());
                out.append(value);
                out.append(value.isEmpty() || order.isEmpty() ? "" : " AND ");
                this.printSelectOrder(query, out);
                continue;
            }
            if (value.length() <= 0) continue;
            out.append(p.toString());
            out.append(value);
        }
        return out;
    }

    protected Appendable printSelectTable(Query query, boolean count, Appendable out) throws IOException {
        out.append("SELECT ");
        if (count) {
            out.append("COUNT(*)");
        } else {
            if (query.isDistinct()) {
                out.append("DISTINCT ");
            }
            this.printTableColumns(query.getColumns(), null, out);
        }
        out.append("\n\tFROM ");
        if (query.getCriterion() != null) {
            CriterionDecoder ed = query.getDecoder();
            MetaTable[] tables = ed.getTables(query.getTableModel());
            for (int i = 0; i < tables.length; ++i) {
                MetaTable table = tables[i];
                if (i > 0) {
                    out.append(", ");
                }
                this.printTableAliasDefinition(table, out);
            }
            String sql = ed.getWhere();
            if (!sql.isEmpty()) {
                out.append(" WHERE ");
                out.append(ed.getWhere());
            }
        } else {
            this.printTableAliasDefinition(query.getTableModel(), out);
        }
        if (!count) {
            if (!query.getOrderBy().isEmpty()) {
                this.printSelectOrder(query, out);
            }
            if (query.isOffset()) {
                this.printOffset(query, out);
            }
            if (query.isLockRequest()) {
                out.append(' ');
                this.printLockForSelect(query, out);
            }
        }
        return out;
    }

    protected Appendable printLockForSelect(Query query, Appendable out) throws IOException, UnsupportedOperationException {
        out.append("FOR UPDATE");
        return out;
    }

    public void printSelectOrder(Query query, Appendable out) throws IOException {
        out.append(" ORDER BY ");
        List props = query.getOrderBy();
        for (int i = 0; i < props.size(); ++i) {
            MetaColumn column = query.readOrderColumn(i);
            boolean ascending = props.get(i).isAscending();
            if (i > 0) {
                out.append(", ");
            }
            this.printColumnAlias(column, out);
            if (ascending) continue;
            out.append(" DESC");
        }
    }

    public Appendable printCall(MetaProcedure procedure, Appendable out) throws IOException {
        List propList = (List)MetaProcedure.PARAMETERS.of((Ujo)procedure);
        out.append('{').append(' ');
        if (!((MetaColumn)((Object)propList.get(0))).isVoid()) {
            out.append("? =");
        }
        out.append(" call ");
        out.append(procedure.getProcedureName());
        if (propList.size() > 1) {
            for (int i = 1; i < propList.size(); ++i) {
                out.append(i == 1 ? "(?" : ",?");
            }
            out.append(')');
        }
        out.append(' ').append('}');
        return out;
    }

    public void printOffset(Query query, Appendable out) throws IOException {
        int limit = query.isLimit() ? query.getLimit() : Integer.MAX_VALUE;
        out.append(" LIMIT " + limit);
        out.append(" OFFSET " + query.getOffset());
    }

    protected Appendable printSequenceTableName(UjoSequencer sequence, Appendable out) throws IOException {
        String schema = sequence.getDatabaseSchema();
        if (this.isUsable(schema)) {
            out.append(schema);
            out.append('.');
        }
        out.append(this.getSeqTableModel().getTableName());
        return out;
    }

    public Appendable printSequenceTable(MetaDatabase db, Appendable out) throws IOException {
        String schema = (String)MetaDatabase.SCHEMA.of((Ujo)db);
        Integer cache = (Integer)MetaParams.SEQUENCE_CACHE.of((Ujo)db.getParams());
        out.append("CREATE TABLE ");
        if (this.isUsable(schema)) {
            out.append(schema);
            out.append('.');
        }
        MetaColumn pkType = new MetaColumn();
        MetaColumn.DB_TYPE.setValue((Ujo)pkType, (Object)DbType.BIGINT);
        out.append(this.getSeqTableModel().getTableName() + "\n\t( " + this.getSeqTableModel().getId() + " VARCHAR(96) NOT NULL PRIMARY KEY" + "\n\t, " + this.getSeqTableModel().getSequence() + " " + this.getColumnType(pkType) + " DEFAULT " + cache + " NOT NULL" + "\n\t, " + this.getSeqTableModel().getCache() + " INT DEFAULT " + cache + " NOT NULL" + "\n\t, " + this.getSeqTableModel().getMaxValue() + " " + this.getColumnType(pkType) + " DEFAULT 0 NOT NULL" + "\n\t)");
        return out;
    }

    public Appendable printSequenceInit(UjoSequencer sequence, Appendable out) throws IOException {
        Integer cache = (Integer)MetaParams.SEQUENCE_CACHE.of((Ujo)sequence.getDatabase().getParams());
        out.append("INSERT INTO ");
        this.printSequenceTableName(sequence, out);
        out.append(" (id,seq,cache) VALUES (?," + cache + "," + cache + ")");
        return out;
    }

    public Appendable printSequenceNextValue(UjoSequencer sequence, Appendable out) throws IOException {
        out.append("UPDATE ");
        this.printSequenceTableName(sequence, out);
        out.append(" SET seq=seq+cache");
        out.append(" WHERE id=?");
        return out;
    }

    public Appendable printSetMaxSequence(UjoSequencer sequence, Appendable out) throws IOException {
        out.append("UPDATE ");
        this.printSequenceTableName(sequence, out);
        out.append(" SET ");
        out.append(this.getSeqTableModel().getSequence());
        out.append("=");
        out.append(this.getSeqTableModel().getMaxValue());
        out.append(" WHERE " + this.getSeqTableModel().getId() + "=?");
        return out;
    }

    public Appendable printSequenceCurrentValue(UjoSequencer sequence, Appendable out) throws IOException {
        SeqTableModel tm = this.getSeqTableModel();
        out.append("SELECT ");
        out.append(tm.getSequence());
        out.append(", ");
        out.append(tm.getCache());
        out.append(", ");
        out.append(tm.getMaxValue());
        out.append(" FROM ");
        this.printSequenceTableName(sequence, out);
        out.append(" WHERE " + tm.getId() + "=?");
        return out;
    }

    protected final boolean isUsable(CharSequence text) {
        return text != null && text.length() > 0;
    }

    public final void println(Appendable out) throws IOException {
        out.append('\n');
    }

    public Appendable printCommit(Appendable out) throws IOException {
        out.append("COMMIT");
        return out;
    }

    public Appendable printComment(MetaTable table, Appendable out) throws IOException {
        out.append("COMMENT ON TABLE ");
        this.printFullTableName(table, out);
        out.append(" IS '");
        this.escape((CharSequence)MetaTable.COMMENT.of((Ujo)table), out);
        out.append("'");
        return out;
    }

    public Appendable printComment(MetaColumn column, Appendable out) throws IOException {
        out.append("COMMENT ON COLUMN ");
        this.printFullTableName((MetaTable)((Object)MetaColumn.TABLE.of((Ujo)column)), out);
        out.append('.');
        out.append((CharSequence)MetaColumn.NAME.of((Ujo)column));
        out.append(" IS '");
        this.escape((CharSequence)MetaColumn.COMMENT.of((Ujo)column), out);
        out.append("'");
        return out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getKeywordSet(Connection conn) {
        HashSet<String> result = new HashSet<String>(128);
        Reader reader = null;
        try {
            reader = new CharArrayReader(conn.getMetaData().getSQLKeywords().concat(",").toCharArray());
            this.assignKeywords(result, reader);
            reader = new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream("/org/ujorm/orm/sql-keywords.txt"), "UTF8"));
            this.assignKeywords(result, reader);
        }
        catch (Throwable e) {
            LOGGER.log(Level.WARNING, "Can't read SQL keywords", e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    LOGGER.log(Level.WARNING, "Can't close reader", e);
                }
            }
        }
        result.remove("");
        return result;
    }

    private void assignKeywords(Set<String> result, Reader reader) throws IOException {
        int c;
        StringBuilder builder = new StringBuilder();
        while ((c = reader.read()) != -1) {
            if (c == 44) {
                result.add(builder.toString().trim().toUpperCase());
                builder.setLength(0);
                continue;
            }
            builder.append((char)c);
        }
    }

    protected final void escape(CharSequence text, Appendable out) throws IOException {
        block3: for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            switch (c) {
                case '\'': {
                    out.append("''");
                    continue block3;
                }
                default: {
                    out.append(c);
                }
            }
        }
    }

    public SeqTableModel getSeqTableModel() {
        return this.pkTableModel;
    }
}

