/*
 * Decompiled with CFR 0.152.
 */
package org.ujorm.orm;

import java.awt.Color;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.List;
import org.ujorm.Ujo;
import org.ujorm.extensions.ValueExportable;
import org.ujorm.orm.DbType;
import org.ujorm.orm.metaModel.MetaColumn;

public class TypeService {
    public static final char UNDEFINED = '\u0000';
    public static final char BOOLEAN = '\u0001';
    public static final char BYTE = '\u0002';
    public static final char CHAR = '\u0003';
    public static final char SHORT = '\u0004';
    public static final char INT = '\u0005';
    public static final char LONG = '\u0006';
    public static final char FLOAT = '\u0007';
    public static final char DOUBLE = '\b';
    public static final char BIG_DECI = '\t';
    public static final char BIG_INTE = '\n';
    public static final char STRING = '\u000b';
    public static final char BYTES = '\f';
    public static final char DATE_UTIL = '\r';
    public static final char DATE_SQL = '\u000e';
    public static final char TIME_SQL = '\u000f';
    public static final char TIMESTAMP = '\u0010';
    public static final char BLOB = '\u0011';
    public static final char CLOB = '\u0012';
    public static final char EXPORTABLE = '\u0013';
    public static final char EXPORT_ENUM = '\u0014';
    public static final char ENUM = '\u0015';
    public static final char COLOR = '\u0016';
    private static final Class[] ARGS = new Class[]{String.class};

    public char getTypeCode(MetaColumn column) {
        List<MetaColumn> columns;
        Class type = column.getType();
        if (ValueExportable.class.isAssignableFrom(type)) {
            return type.isEnum() ? (char)'\u0014' : '\u0013';
        }
        if (type == String.class) {
            return '\u000b';
        }
        if (type == Boolean.class) {
            return '\u0001';
        }
        if (type == Byte.class) {
            return '\u0002';
        }
        if (type == Character.class) {
            return '\u0003';
        }
        if (type == Short.class) {
            return '\u0004';
        }
        if (type == Integer.class) {
            return '\u0005';
        }
        if (type == Long.class) {
            return '\u0006';
        }
        if (type == Float.class) {
            return '\u0007';
        }
        if (type == Double.class) {
            return '\b';
        }
        if (type == BigDecimal.class) {
            return '\t';
        }
        if (type == BigInteger.class) {
            return '\n';
        }
        if (type == byte[].class) {
            return '\f';
        }
        if (type == java.util.Date.class) {
            return '\r';
        }
        if (type == Date.class) {
            return '\u000e';
        }
        if (type == Time.class) {
            return '\u000f';
        }
        if (type == Timestamp.class) {
            return '\u0010';
        }
        if (type == Blob.class) {
            return '\u0011';
        }
        if (type == Clob.class) {
            return '\u0012';
        }
        if (type.isEnum()) {
            return '\u0015';
        }
        if (type == Color.class) {
            return '\u0016';
        }
        if (column.isForeignKey() && (columns = column.getForeignColumns()).size() == 1) {
            return this.getTypeCode(columns.get(0));
        }
        return '\u0000';
    }

    public Object getValue(MetaColumn mColumn, ResultSet rs) throws SQLException {
        Comparable<Boolean> r;
        String column = (String)MetaColumn.NAME.of((Ujo)mColumn);
        switch (mColumn.getTypeCode()) {
            case '\u0001': {
                r = rs.getBoolean(column);
                break;
            }
            case '\u0002': {
                r = rs.getByte(column);
                break;
            }
            case '\u0003': {
                r = Character.valueOf((char)rs.getInt(column));
                break;
            }
            case '\u0004': {
                r = rs.getShort(column);
                break;
            }
            case '\u0005': {
                r = rs.getInt(column);
                break;
            }
            case '\u0006': {
                r = rs.getLong(column);
                break;
            }
            case '\u0007': {
                r = Float.valueOf(rs.getFloat(column));
                break;
            }
            case '\b': {
                r = rs.getDouble(column);
                break;
            }
            case '\t': {
                return rs.getBigDecimal(column);
            }
            case '\n': {
                BigDecimal d = rs.getBigDecimal(column);
                return d != null ? d.toBigInteger() : null;
            }
            case '\u000b': {
                return rs.getString(column);
            }
            case '\f': {
                return rs.getBytes(column);
            }
            case '\r': {
                Timestamp t = rs.getTimestamp(column);
                return t != null ? new java.util.Date(t.getTime()) : null;
            }
            case '\u000e': {
                return rs.getDate(column);
            }
            case '\u000f': {
                return rs.getTime(column);
            }
            case '\u0010': {
                return rs.getTimestamp(column);
            }
            case '\u0011': {
                return rs.getBlob(column);
            }
            case '\u0012': {
                return rs.getClob(column);
            }
            case '\u0015': {
                int i = rs.getInt(column);
                return i == 0 && rs.wasNull() ? null : mColumn.getType().getEnumConstants()[i];
            }
            case '\u0016': {
                int c = rs.getInt(column);
                return c == 0 && rs.wasNull() ? null : new Color(c);
            }
            case '\u0013': {
                return this.getValue(rs.getString(column), mColumn);
            }
            case '\u0014': {
                return this.findEnum(rs.getString(column), mColumn);
            }
            default: {
                return rs.getObject(column);
            }
        }
        return rs.wasNull() ? null : r;
    }

    public Object getValue(MetaColumn mColumn, ResultSet rs, int column) throws SQLException {
        Comparable<Boolean> r;
        switch (mColumn.getTypeCode()) {
            case '\u0001': {
                r = rs.getBoolean(column);
                break;
            }
            case '\u0002': {
                r = rs.getByte(column);
                break;
            }
            case '\u0003': {
                r = Character.valueOf((char)rs.getInt(column));
                break;
            }
            case '\u0004': {
                r = rs.getShort(column);
                break;
            }
            case '\u0005': {
                r = rs.getInt(column);
                break;
            }
            case '\u0006': {
                r = rs.getLong(column);
                break;
            }
            case '\u0007': {
                r = Float.valueOf(rs.getFloat(column));
                break;
            }
            case '\b': {
                r = rs.getDouble(column);
                break;
            }
            case '\t': {
                return rs.getBigDecimal(column);
            }
            case '\n': {
                BigDecimal d = rs.getBigDecimal(column);
                return d != null ? d.toBigInteger() : null;
            }
            case '\u000b': {
                return rs.getString(column);
            }
            case '\f': {
                return rs.getBytes(column);
            }
            case '\r': {
                Timestamp t = rs.getTimestamp(column);
                return t != null ? new java.util.Date(t.getTime()) : null;
            }
            case '\u000e': {
                return rs.getDate(column);
            }
            case '\u000f': {
                return rs.getTime(column);
            }
            case '\u0010': {
                return rs.getTimestamp(column);
            }
            case '\u0011': {
                return rs.getBlob(column);
            }
            case '\u0012': {
                return rs.getClob(column);
            }
            case '\u0015': {
                int i = rs.getInt(column);
                return i == 0 && rs.wasNull() ? null : mColumn.getType().getEnumConstants()[i];
            }
            case '\u0016': {
                int c = rs.getInt(column);
                return c == 0 && rs.wasNull() ? null : new Color(c);
            }
            case '\u0013': {
                return this.getValue(rs.getString(column), mColumn);
            }
            case '\u0014': {
                return this.findEnum(rs.getString(column), mColumn);
            }
            default: {
                return rs.getObject(column);
            }
        }
        return rs.wasNull() ? null : r;
    }

    public Object getValue(MetaColumn mColumn, CallableStatement rs, int column) throws SQLException {
        Comparable<Boolean> r;
        switch (mColumn.getTypeCode()) {
            case '\u0001': {
                r = rs.getBoolean(column);
                break;
            }
            case '\u0002': {
                r = rs.getByte(column);
                break;
            }
            case '\u0003': {
                r = Character.valueOf((char)rs.getInt(column));
                break;
            }
            case '\u0004': {
                r = rs.getShort(column);
                break;
            }
            case '\u0005': {
                r = rs.getInt(column);
                break;
            }
            case '\u0006': {
                r = rs.getLong(column);
                break;
            }
            case '\u0007': {
                r = Float.valueOf(rs.getFloat(column));
                break;
            }
            case '\b': {
                r = rs.getDouble(column);
                break;
            }
            case '\t': {
                return rs.getBigDecimal(column);
            }
            case '\n': {
                BigDecimal d = rs.getBigDecimal(column);
                return d != null ? d.toBigInteger() : null;
            }
            case '\u000b': {
                return rs.getString(column);
            }
            case '\f': {
                return rs.getBytes(column);
            }
            case '\r': {
                Timestamp t = rs.getTimestamp(column);
                return t != null ? new java.util.Date(t.getTime()) : null;
            }
            case '\u000e': {
                return rs.getDate(column);
            }
            case '\u000f': {
                return rs.getTime(column);
            }
            case '\u0010': {
                return rs.getTimestamp(column);
            }
            case '\u0011': {
                return rs.getBlob(column);
            }
            case '\u0012': {
                return rs.getClob(column);
            }
            case '\u0015': {
                int i = rs.getInt(column);
                return i == 0 && rs.wasNull() ? null : mColumn.getType().getEnumConstants()[i];
            }
            case '\u0016': {
                int c = rs.getInt(column);
                return c == 0 && rs.wasNull() ? null : new Color(c);
            }
            case '\u0013': {
                return this.getValue(rs.getString(column), mColumn);
            }
            case '\u0014': {
                return this.findEnum(rs.getString(column), mColumn);
            }
            default: {
                return rs.getObject(column);
            }
        }
        return rs.wasNull() ? null : r;
    }

    public void setValue(MetaColumn mColumn, PreparedStatement rs, Object value, int i) throws SQLException {
        if (value == null) {
            int sqlType = ((DbType)((Object)MetaColumn.DB_TYPE.of((Ujo)mColumn))).getSqlType();
            rs.setNull(i, sqlType);
            return;
        }
        switch (mColumn.getTypeCode()) {
            case '\u0001': {
                rs.setBoolean(i, (Boolean)value);
                break;
            }
            case '\u0002': {
                rs.setByte(i, (Byte)value);
                break;
            }
            case '\u0003': {
                rs.setInt(i, ((Character)value).charValue());
                break;
            }
            case '\u0004': {
                rs.setShort(i, (Short)value);
                break;
            }
            case '\u0005': {
                rs.setInt(i, (Integer)value);
                break;
            }
            case '\u0006': {
                rs.setLong(i, (Long)value);
                break;
            }
            case '\u0007': {
                rs.setFloat(i, ((Float)value).floatValue());
                break;
            }
            case '\b': {
                rs.setDouble(i, (Double)value);
                break;
            }
            case '\t': {
                rs.setBigDecimal(i, (BigDecimal)value);
                break;
            }
            case '\n': {
                rs.setBigDecimal(i, new BigDecimal((BigInteger)value));
                break;
            }
            case '\u000b': {
                rs.setString(i, (String)value);
                break;
            }
            case '\f': {
                rs.setBytes(i, (byte[])value);
                break;
            }
            case '\r': {
                rs.setTimestamp(i, new Timestamp(((java.util.Date)value).getTime()));
                break;
            }
            case '\u000e': {
                rs.setDate(i, (Date)value);
                break;
            }
            case '\u000f': {
                rs.setTime(i, (Time)value);
                break;
            }
            case '\u0010': {
                rs.setTimestamp(i, (Timestamp)value);
                break;
            }
            case '\u0011': {
                rs.setBlob(i, (Blob)value);
                break;
            }
            case '\u0012': {
                rs.setClob(i, (Clob)value);
                break;
            }
            case '\u0015': {
                rs.setInt(i, ((Enum)value).ordinal());
                break;
            }
            case '\u0016': {
                rs.setInt(i, ((Color)value).getRGB());
                break;
            }
            case '\u0013': 
            case '\u0014': {
                rs.setString(i, value != null ? ((ValueExportable)value).exportToString() : null);
                break;
            }
            default: {
                rs.setObject(i, value);
            }
        }
    }

    private Object findEnum(String key, MetaColumn mColumn) throws IllegalArgumentException {
        if (key == null || key.length() == 0) {
            return null;
        }
        for (Object o : mColumn.getType().getEnumConstants()) {
            if (!key.equals(((ValueExportable)o).exportToString())) continue;
            return o;
        }
        throw new IllegalArgumentException("No enum key " + mColumn.getType() + "." + key);
    }

    private Object getValue(String key, MetaColumn mColumn) throws IllegalArgumentException {
        if (key == null || key.length() == 0) {
            return null;
        }
        try {
            Object result = mColumn.getType().getConstructor(ARGS).newInstance(key);
            return result;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Bad value export " + mColumn.getType() + "." + key, e);
        }
    }
}

